/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.server.model.common.ExecutionContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.discovery.DiscoveryType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import org.json.JSONObject;

@ApplicationScoped
public class ExternalDiscoveryService
extends ExternalScriptService {
    public ExternalDiscoveryService() {
        super(CustomScriptType.DISCOVERY);
    }

    public boolean modifyDiscovery(JSONObject jsonObject, ExecutionContext context) {
        CustomScriptConfiguration script = this.getDefaultExternalCustomScript();
        if (script == null) {
            this.log.trace("No discovery script set.");
            return false;
        }
        try {
            this.log.trace("Executing python 'modifyDiscovery' method, script name: {}, jsonWebResponse: {}, context: {}", new Object[]{script.getName(), jsonObject, context});
            context.setScript(script);
            DiscoveryType discoveryType = (DiscoveryType)script.getExternalType();
            boolean result = discoveryType.modifyResponse((Object)jsonObject, (Object)context);
            this.log.trace("Finished 'modifyDiscovery' method, script name: {}, jsonWebResponse: {}, context: {}, result: {}", new Object[]{script.getName(), jsonObject, context, result});
            return result;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.saveScriptError(script.getCustomScript(), e);
            return false;
        }
    }
}

