/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import com.google.common.collect.Lists;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.service.external.context.ExternalIntrospectionContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.introspection.IntrospectionType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalIntrospectionService
extends ExternalScriptService {
    private static final long serialVersionUID = -8609727759114795446L;
    @Inject
    private AppConfiguration appConfiguration;

    public ExternalIntrospectionService() {
        super(CustomScriptType.INTROSPECTION);
    }

    @NotNull
    private List<CustomScriptConfiguration> getScripts(@NotNull ExternalIntrospectionContext context) {
        List scripts;
        if (this.customScriptConfigurations == null) {
            return Lists.newArrayList();
        }
        if (this.appConfiguration.getIntrospectionScriptBackwardCompatibility().booleanValue()) {
            return this.customScriptConfigurations;
        }
        if (context.getGrantOfIntrospectionToken() != null && context.getGrantOfIntrospectionToken().getClient() != null && !(scripts = this.getCustomScriptConfigurationsByDns(context.getGrantOfIntrospectionToken().getClient().getAttributes().getIntrospectionScripts())).isEmpty()) {
            return scripts;
        }
        if (context.getTokenGrant() != null && context.getTokenGrant().getClient() != null && !(scripts = this.getCustomScriptConfigurationsByDns(context.getTokenGrant().getClient().getAttributes().getIntrospectionScripts())).isEmpty()) {
            return scripts;
        }
        this.log.trace("No introspection scripts associated with client which was used to obtain access_token.");
        return Lists.newArrayList();
    }

    public boolean executeExternalModifyResponse(JSONObject responseAsJsonObject, ExternalIntrospectionContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context);
        if (scripts.isEmpty()) {
            this.log.trace("There is no any external interception scripts defined.");
            return false;
        }
        for (CustomScriptConfiguration script : scripts) {
            if (this.executeExternalModifyResponse(script, responseAsJsonObject, context)) continue;
            this.log.debug("Stopped running external interception scripts because script {} returns false.", (Object)script.getName());
            return false;
        }
        return true;
    }

    private boolean executeExternalModifyResponse(CustomScriptConfiguration scriptConf, JSONObject responseAsJsonObject, ExternalIntrospectionContext context) {
        try {
            this.log.trace("Executing external 'executeExternalModifyResponse' method, script name: {}, responseAsJsonObject: {} , context: {}", new Object[]{scriptConf.getName(), responseAsJsonObject, context});
            IntrospectionType script = (IntrospectionType)scriptConf.getExternalType();
            context.setScript(scriptConf);
            boolean result = script.modifyResponse((Object)responseAsJsonObject, (Object)context);
            this.log.trace("Finished external 'executeExternalModifyResponse' method, script name: {}, responseAsJsonObject: {} , context: {}, result: {}", new Object[]{scriptConf.getName(), responseAsJsonObject, context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConf.getCustomScript(), ex);
            return false;
        }
    }
}

