/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import com.google.common.collect.Lists;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.token.LogoutStatusJwtType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.WebApplicationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@ApplicationScoped
public class ExternalLogoutStatusJwtService
extends ExternalScriptService {
    public ExternalLogoutStatusJwtService() {
        super(CustomScriptType.LOGOUT_STATUS_JWT);
    }

    public boolean modifyLogoutStatusJwtMethod(CustomScriptConfiguration script, JsonWebResponse jsonWebResponse, ExternalScriptContext context) {
        try {
            this.log.trace("Executing 'modifyLogoutStatusJwtMethod' method, script name: {}, jsonWebResponse: {}, context: {}", new Object[]{script.getName(), jsonWebResponse, context});
            context.getExecutionContext().setScript(script);
            LogoutStatusJwtType scriptType = (LogoutStatusJwtType)script.getExternalType();
            boolean result = scriptType.modifyPayload((Object)jsonWebResponse, (Object)context);
            this.log.trace("Finished 'modifyLogoutStatusJwtMethod' method, script name: {}, jsonWebResponse: {}, context: {}, result: {}", new Object[]{script.getName(), jsonWebResponse, context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean modifyLogoutStatusJwtMethod(JsonWebResponse jsonWebResponse, ExternalScriptContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context);
        if (scripts.isEmpty()) {
            return false;
        }
        this.log.trace("Executing {} 'modifyLogoutStatusJwtMethod' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.modifyLogoutStatusJwtMethod(script, jsonWebResponse, context)) continue;
            return false;
        }
        return true;
    }

    public int getLifetimeInSeconds(CustomScriptConfiguration script, ExternalScriptContext context) {
        try {
            this.log.trace("Executing python 'getLifetimeInSeconds' method, script name: {}, context: {}", (Object)script.getName(), (Object)context);
            context.getExecutionContext().setScript(script);
            LogoutStatusJwtType scriptType = (LogoutStatusJwtType)script.getExternalType();
            int result = scriptType.getLifetimeInSeconds((Object)context);
            this.log.trace("Finished 'getLifetimeInSeconds' method, script name: {}, context: {}, result: {}", new Object[]{script.getName(), context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return 0;
        }
    }

    public int getLifetimeInSeconds(ExternalScriptContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context);
        if (scripts.isEmpty()) {
            return 0;
        }
        this.log.trace("Executing {} 'getLifetimeInSeconds' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            int lifetime = this.getLifetimeInSeconds(script, context);
            if (lifetime <= 0) continue;
            this.log.trace("Finished 'getLifetimeInSeconds' methods, lifetime: {}", (Object)lifetime);
            return lifetime;
        }
        return 0;
    }

    @NotNull
    private List<CustomScriptConfiguration> getScripts(@NotNull ExternalScriptContext context) {
        Client client = context.getExecutionContext().getClient();
        if (this.customScriptConfigurations == null || this.customScriptConfigurations.isEmpty() || client == null) {
            this.log.trace("No LogoutStatusJwtType scripts or client is null.");
            return Lists.newArrayList();
        }
        List scripts = this.getCustomScriptConfigurationsByDns(client.getAttributes().getLogoutStatusJwtScriptDns());
        if (!scripts.isEmpty()) {
            return scripts;
        }
        this.log.trace("No LogoutStatusJwtType scripts associated with client {}", (Object)client.getClientId());
        return Lists.newArrayList();
    }
}

