/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import com.google.common.collect.Lists;
import io.jans.as.common.model.registration.Client;
import io.jans.as.persistence.model.Par;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.par.ParType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.WebApplicationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@ApplicationScoped
public class ExternalParService
extends ExternalScriptService {
    public ExternalParService() {
        super(CustomScriptType.PAR);
    }

    public boolean createPar(CustomScriptConfiguration script, Par par, ExternalScriptContext context) {
        try {
            this.log.trace("Executing 'createPar' method, script name: {}, par: {}, context: {}", new Object[]{script.getName(), par, context});
            context.getExecutionContext().setScript(script);
            ParType scriptType = (ParType)script.getExternalType();
            boolean result = scriptType.createPar((Object)par, (Object)context);
            this.log.trace("Finished 'createPar' method, script name: {}, par: {}, context: {}, result: {}", new Object[]{script.getName(), par, context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean createPar(Par par, ExternalScriptContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context);
        if (scripts.isEmpty()) {
            return true;
        }
        this.log.trace("Executing {} 'createPar' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.createPar(script, par, context)) continue;
            return false;
        }
        return true;
    }

    public boolean modifyParResponse(CustomScriptConfiguration script, JSONObject response, ExternalScriptContext context) {
        try {
            this.log.trace("Executing 'modifyParResponse' method, script name: {}, response: {}, context: {}", new Object[]{script.getName(), response, context});
            context.getExecutionContext().setScript(script);
            ParType scriptType = (ParType)script.getExternalType();
            boolean result = scriptType.modifyParResponse((Object)response, (Object)context);
            this.log.trace("Finished 'modifyParResponse' method, script name: {}, response: {}, context: {}, result: {}", new Object[]{script.getName(), response, context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean modifyParResponse(JSONObject response, ExternalScriptContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context);
        if (scripts.isEmpty()) {
            return false;
        }
        this.log.trace("Executing {} 'modifyParResponse' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.modifyParResponse(script, response, context)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private List<CustomScriptConfiguration> getScripts(@NotNull ExternalScriptContext context) {
        Client client = context.getExecutionContext().getClient();
        if (this.customScriptConfigurations == null || this.customScriptConfigurations.isEmpty() || client == null) {
            this.log.trace("No ParType scripts or client is null.");
            return Lists.newArrayList();
        }
        List scripts = this.getCustomScriptConfigurationsByDns(client.getAttributes().getParScriptDns());
        if (!scripts.isEmpty()) {
            return scripts;
        }
        this.log.trace("No ParType scripts associated with client {}", (Object)client.getClientId());
        return Lists.newArrayList();
    }
}

