/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.server.model.common.ExecutionContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.revoke.RevokeTokenType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalRevokeTokenService
extends ExternalScriptService {
    public ExternalRevokeTokenService() {
        super(CustomScriptType.REVOKE_TOKEN);
    }

    public boolean revokeToken(CustomScriptConfiguration script, ExecutionContext context) {
        try {
            this.log.trace("Executing python 'revokeToken' method, context: {}", (Object)context);
            context.setScript(script);
            RevokeTokenType revokeTokenType = (RevokeTokenType)script.getExternalType();
            boolean result = revokeTokenType.revoke((Object)context);
            this.log.trace("Finished 'revokeToken' method, result: {}, context: {}", (Object)result, (Object)context);
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean revokeTokenMethods(ExecutionContext context) {
        for (CustomScriptConfiguration script : this.customScriptConfigurations) {
            if (script.getExternalType().getApiVersion() <= 1 || this.revokeToken(script, context)) continue;
            return false;
        }
        return true;
    }
}

