/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import com.google.common.collect.Lists;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.RefreshToken;
import io.jans.as.server.service.external.context.ExternalUpdateTokenContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.token.UpdateTokenType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;

@ApplicationScoped
public class ExternalUpdateTokenService
extends ExternalScriptService {
    private static final long serialVersionUID = -1033475075863270259L;
    @Inject
    private AppConfiguration appConfiguration;

    public ExternalUpdateTokenService() {
        super(CustomScriptType.UPDATE_TOKEN);
    }

    public boolean modifyIdTokenMethod(CustomScriptConfiguration script, JsonWebResponse jsonWebResponse, ExternalUpdateTokenContext context) {
        try {
            this.log.trace("Executing python 'updateToken' method, script name: {}, jsonWebResponse: {}, context: {}", new Object[]{script.getName(), jsonWebResponse, context});
            context.setScript(script);
            UpdateTokenType updateTokenType = (UpdateTokenType)script.getExternalType();
            boolean result = updateTokenType.modifyIdToken((Object)jsonWebResponse, (Object)context);
            this.log.trace("Finished 'updateToken' method, script name: {}, jsonWebResponse: {}, context: {}, result: {}", new Object[]{script.getName(), jsonWebResponse, context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean modifyIdTokenMethods(JsonWebResponse jsonWebResponse, ExternalUpdateTokenContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context);
        if (scripts.isEmpty()) {
            return true;
        }
        this.log.trace("Executing {} update-token scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.modifyIdTokenMethod(script, jsonWebResponse, context)) continue;
            return false;
        }
        return true;
    }

    public Function<JsonWebResponse, Void> buildModifyIdTokenProcessor(ExternalUpdateTokenContext context) {
        return jsonWebResponse -> {
            this.modifyIdTokenMethods((JsonWebResponse)jsonWebResponse, context);
            return null;
        };
    }

    public int getRefreshTokenLifetimeInSeconds(CustomScriptConfiguration script, ExternalUpdateTokenContext context) {
        try {
            this.log.trace("Executing python 'getRefreshTokenLifetimeInSeconds' method, script name: {}, context: {}", (Object)script.getName(), (Object)context);
            context.setScript(script);
            UpdateTokenType updateTokenType = (UpdateTokenType)script.getExternalType();
            int result = updateTokenType.getRefreshTokenLifetimeInSeconds((Object)context);
            this.log.trace("Finished 'getRefreshTokenLifetimeInSeconds' method, script name: {}, context: {}, result: {}", new Object[]{script.getName(), context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return 0;
        }
    }

    public int getRefreshTokenLifetimeInSeconds(ExternalUpdateTokenContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context);
        if (scripts.isEmpty()) {
            return 0;
        }
        this.log.trace("Executing {} 'getRefreshTokenLifetimeInSeconds' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            int lifetime = this.getRefreshTokenLifetimeInSeconds(script, context);
            if (lifetime <= 0) continue;
            this.log.trace("Finished 'getRefreshTokenLifetimeInSeconds' methods, lifetime: {}", (Object)lifetime);
            return lifetime;
        }
        return 0;
    }

    @NotNull
    protected List<CustomScriptConfiguration> getScripts(@NotNull ExternalUpdateTokenContext context) {
        List customScriptConfigurations = this.getCustomScriptConfigurations();
        if (customScriptConfigurations == null || customScriptConfigurations.isEmpty()) {
            this.log.trace("No UpdateToken scripts.");
            return Lists.newArrayList();
        }
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getRunAllUpdateTokenScripts())) {
            this.log.trace("Run all UpdateToken scripts.");
            return customScriptConfigurations;
        }
        if (context.getClient() == null) {
            this.log.trace("No client.");
            return Lists.newArrayList();
        }
        List scripts = this.getCustomScriptConfigurationsByDns(context.getClient().getAttributes().getUpdateTokenScriptDns());
        if (!scripts.isEmpty()) {
            return scripts;
        }
        this.log.trace("No UpdateToken scripts associated with client {}", (Object)context.getClient().getClientId());
        return Lists.newArrayList();
    }

    public boolean modifyRefreshToken(CustomScriptConfiguration script, RefreshToken refreshToken, ExternalUpdateTokenContext context) {
        try {
            this.log.trace("Executing python 'modifyRefreshToken' method, script name: {}, context: {}", (Object)script.getName(), (Object)context);
            context.setScript(script);
            UpdateTokenType updateTokenType = (UpdateTokenType)script.getExternalType();
            boolean result = updateTokenType.modifyRefreshToken((Object)refreshToken, (Object)context);
            this.log.trace("Finished 'modifyRefreshToken' method, script name: {}, context: {}, result: {}", new Object[]{script.getName(), context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean modifyRefreshToken(RefreshToken refreshToken, ExternalUpdateTokenContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context);
        if (scripts.isEmpty()) {
            return true;
        }
        this.log.trace("Executing {} update-token modifyRefreshToken scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.modifyRefreshToken(script, refreshToken, context)) continue;
            return false;
        }
        return true;
    }

    public boolean modifyAccessToken(CustomScriptConfiguration script, AccessToken accessToken, ExternalUpdateTokenContext context) {
        try {
            this.log.trace("Executing python 'modifyAccessToken' method, script name: {}, context: {}", (Object)script.getName(), (Object)context);
            context.setScript(script);
            UpdateTokenType updateTokenType = (UpdateTokenType)script.getExternalType();
            boolean result = updateTokenType.modifyAccessToken((Object)accessToken, (Object)context);
            this.log.trace("Finished 'modifyAccessToken' method, script name: {}, context: {}, result: {}", new Object[]{script.getName(), context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean modifyAccessToken(AccessToken accessToken, ExternalUpdateTokenContext context) {
        if (context.getExecutionContext() != null && context.getExecutionContext().isSkipModifyAccessTokenScript()) {
            this.log.trace("Skipped modifyAccessToken because execution context has skipModifyAccessTokenScript=true");
            return true;
        }
        List<CustomScriptConfiguration> scripts = this.getScripts(context);
        if (scripts.isEmpty()) {
            this.log.trace("No UpdateToken scripts found.");
            return true;
        }
        this.log.trace("Executing {} update-token modifyAccessToken scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.modifyAccessToken(script, accessToken, context)) continue;
            return false;
        }
        return true;
    }

    public int getAccessTokenLifetimeInSeconds(CustomScriptConfiguration script, ExternalUpdateTokenContext context) {
        try {
            this.log.trace("Executing python 'getAccessTokenLifetimeInSeconds' method, script name: {}, context: {}", (Object)script.getName(), (Object)context);
            context.setScript(script);
            UpdateTokenType updateTokenType = (UpdateTokenType)script.getExternalType();
            int result = updateTokenType.getAccessTokenLifetimeInSeconds((Object)context);
            this.log.trace("Finished 'getAccessTokenLifetimeInSeconds' method, script name: {}, context: {}, result: {}", new Object[]{script.getName(), context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return 0;
        }
    }

    public int getAccessTokenLifetimeInSeconds(ExternalUpdateTokenContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context);
        if (scripts.isEmpty()) {
            return 0;
        }
        this.log.trace("Executing {} 'getAccessTokenLifetimeInSeconds' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            int lifetime = this.getAccessTokenLifetimeInSeconds(script, context);
            if (lifetime <= 0) continue;
            this.log.trace("Finished 'getAccessTokenLifetimeInSeconds' methods, lifetime: {}", (Object)lifetime);
            return lifetime;
        }
        return 0;
    }

    public int getIdTokenLifetimeInSeconds(CustomScriptConfiguration script, ExternalUpdateTokenContext context) {
        try {
            this.log.trace("Executing python 'getIdTokenLifetimeInSeconds' method, script name: {}, context: {}", (Object)script.getName(), (Object)context);
            context.setScript(script);
            UpdateTokenType updateTokenType = (UpdateTokenType)script.getExternalType();
            int result = updateTokenType.getIdTokenLifetimeInSeconds((Object)context);
            this.log.trace("Finished 'getIdTokenLifetimeInSeconds' method, script name: {}, context: {}, result: {}", new Object[]{script.getName(), context, result});
            context.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return 0;
        }
    }

    public int getIdTokenLifetimeInSeconds(ExternalUpdateTokenContext context) {
        List<CustomScriptConfiguration> scripts = this.getScripts(context);
        if (scripts.isEmpty()) {
            return 0;
        }
        this.log.trace("Executing {} 'getIdTokenLifetimeInSeconds' scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            int lifetime = this.getIdTokenLifetimeInSeconds(script, context);
            if (lifetime <= 0) continue;
            this.log.trace("Finished 'getIdTokenLifetimeInSeconds' methods, lifetime: {}", (Object)lifetime);
            return lifetime;
        }
        return 0;
    }
}

