/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.common.model.ssa.Ssa;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.server.service.external.context.ModifySsaResponseContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.ssa.ModifySsaResponseType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;

@ApplicationScoped
public class ModifySsaResponseService
extends ExternalScriptService {
    private static final long serialVersionUID = -1033475075863270259L;

    public ModifySsaResponseService() {
        super(CustomScriptType.MODIFY_SSA_RESPONSE);
    }

    public boolean create(CustomScriptConfiguration script, JsonWebResponse jsonWebResponse, ModifySsaResponseContext context) {
        try {
            this.log.trace("Executing python modify-ssa-response method create, script name: {}, jwt: {}, context: {}", new Object[]{script.getName(), jsonWebResponse, context});
            context.setScript(script);
            ModifySsaResponseType modifySsaResponseType = (ModifySsaResponseType)script.getExternalType();
            boolean result = modifySsaResponseType.create((Object)jsonWebResponse, (Object)context);
            this.log.trace("Finished modify-ssa-response method create, script name: {}, jwt: {}, context: {}, result: {}", new Object[]{script.getName(), jsonWebResponse, context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean create(JsonWebResponse jsonWebResponse, ModifySsaResponseContext context) {
        List<CustomScriptConfiguration> scripts = this.getCustomScript();
        if (scripts.isEmpty()) {
            return false;
        }
        this.log.trace("Executing {} modify-ssa-response scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.create(script, jsonWebResponse, context)) continue;
            return false;
        }
        return true;
    }

    public boolean get(JSONArray jsonArray, ModifySsaResponseContext context) {
        List<CustomScriptConfiguration> scriptList = this.getCustomScript();
        if (scriptList.isEmpty()) {
            return false;
        }
        for (CustomScriptConfiguration script : scriptList) {
            this.log.trace("Executing python modify-ssa-response method get, script name: {}, jsonArray: {}, context: {}", new Object[]{script.getName(), jsonArray, context});
            context.setScript(script);
            ModifySsaResponseType modifySsaResponseType = (ModifySsaResponseType)script.getExternalType();
            boolean result = false;
            try {
                result = modifySsaResponseType.get((Object)jsonArray, (Object)context);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                this.saveScriptError(script.getCustomScript(), e);
            }
            this.log.trace("Finished modify-ssa-response method get, script name: {}, jsonArray: {}, context: {}, result: {}", new Object[]{script.getName(), jsonArray, context, result});
            if (result) continue;
            return false;
        }
        return true;
    }

    public boolean revoke(List<Ssa> ssaList, ModifySsaResponseContext context) {
        List<CustomScriptConfiguration> scriptList = this.getCustomScript();
        if (scriptList.isEmpty()) {
            return false;
        }
        for (CustomScriptConfiguration script : scriptList) {
            this.log.trace("Executing python modify-ssa-response method revoke, script name: {}, ssaList: {}, context: {}", new Object[]{script.getName(), ssaList, context});
            context.setScript(script);
            ModifySsaResponseType modifySsaResponseType = (ModifySsaResponseType)script.getExternalType();
            boolean result = false;
            try {
                result = modifySsaResponseType.revoke(ssaList, (Object)context);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                this.saveScriptError(script.getCustomScript(), e);
            }
            this.log.trace("Finished modify-ssa-response method revoke, script name: {}, ssaList: {}, context: {}, result: {}", new Object[]{script.getName(), ssaList, context, result});
            if (result) continue;
            return false;
        }
        return true;
    }

    public Function<JsonWebResponse, Void> buildCreateProcessor(ModifySsaResponseContext context) {
        return jsonWebResponse -> {
            this.create((JsonWebResponse)jsonWebResponse, context);
            return null;
        };
    }

    @NotNull
    private List<CustomScriptConfiguration> getCustomScript() {
        return this.customScriptManager.getCustomScriptConfigurationsByScriptType(CustomScriptType.MODIFY_SSA_RESPONSE);
    }
}

