/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.stat;

import io.jans.as.common.model.stat.Stat;
import io.jans.as.common.model.stat.StatEntry;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.net.InetAddressUtility;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.model.base.SimpleBranch;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.agkn.hll.HLL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class StatService {
    private static final int REGWIDTH = 5;
    private static final int LOG_2_M = 15;
    public static final String ACCESS_TOKEN_KEY = "access_token";
    public static final String ID_TOKEN_KEY = "id_token";
    public static final String REFRESH_TOKEN_KEY = "refresh_token";
    public static final String UMA_TOKEN_KEY = "uma_token";
    public static final String LOGOUT_STATUS_TOKEN_KEY = "logout_status_jwt";
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    private String nodeId;
    private StatEntry currentEntry;
    private HLL hll;
    private ConcurrentMap<String, Map<String, Long>> tokenCounters;
    private final SimpleDateFormat periodDateFormat = new SimpleDateFormat("yyyyMM");
    private boolean initialized = false;

    @PostConstruct
    public void create() {
        this.initialized = false;
    }

    public boolean init() {
        try {
            Set featureFlags = FeatureFlagType.from((AppConfiguration)this.appConfiguration);
            if (!featureFlags.isEmpty() && !featureFlags.contains(FeatureFlagType.STAT)) {
                this.log.trace("Stat service is not enabled.");
                return false;
            }
            this.log.info("Initializing Stat Service");
            this.initNodeId();
            if (StringUtils.isBlank((CharSequence)this.nodeId)) {
                this.log.error("Failed to initialize stat service. statNodeId is not set in configuration.");
                return false;
            }
            if (StringUtils.isBlank((CharSequence)this.getBaseDn())) {
                this.log.error("Failed to initialize stat service. 'stat' base dn is not set in configuration.");
                return false;
            }
            this.prepareMonthlyBranch();
            this.setupCurrentEntry();
            this.initialized = true;
            this.log.info("Initialized Stat Service");
            return true;
        }
        catch (Exception e) {
            this.log.error("Failed to initialize Stat Service.", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStat() {
        this.log.trace("updateStat ...  (initialized: {})", (Object)this.initialized);
        if (!this.initialized) {
            return;
        }
        this.log.trace("Started updateStat ...");
        this.prepareMonthlyBranch();
        this.initNodeId();
        this.setupCurrentEntry();
        Stat stat = this.currentEntry.getStat();
        stat.setTokenCountPerGrantType(this.tokenCounters);
        stat.setLastUpdatedAt(System.currentTimeMillis());
        HLL hLL = this.hll;
        synchronized (hLL) {
            this.currentEntry.setUserHllData(Base64.getEncoder().encodeToString(this.hll.toBytes()));
        }
        this.log.trace("Updating entry dn {}", (Object)this.currentEntry.getDn());
        this.entryManager.merge((Object)this.currentEntry);
        this.log.trace("Finished updateStat.");
    }

    public String currentMonth() {
        return this.periodDateFormat.format(new Date());
    }

    public String currentMonthDn() {
        String baseDn = this.getBaseDn();
        String month = this.currentMonth();
        return String.format("ou=%s,%s", month, baseDn);
    }

    private void setupCurrentEntry() {
        boolean sameMonth;
        String currentMonth = this.currentMonth();
        String dn = String.format("jansId=%s,%s", this.nodeId, this.currentMonthDn());
        this.log.trace("Stat entry dn: {}", (Object)dn);
        boolean bl = sameMonth = this.currentEntry != null && currentMonth.equals(this.currentEntry.getStat().getMonth());
        if (sameMonth) {
            this.log.trace("Same month {}", (Object)currentMonth);
            return;
        }
        this.log.trace("Different month {}", (Object)currentMonth);
        this.currentEntry = null;
        try {
            StatEntry entryFromPersistence = (StatEntry)this.entryManager.find(StatEntry.class, (Object)dn);
            if (entryFromPersistence != null && currentMonth.equals(entryFromPersistence.getStat().getMonth())) {
                this.hll = HLL.fromBytes((byte[])Base64.getDecoder().decode(entryFromPersistence.getUserHllData()));
                this.tokenCounters = new ConcurrentHashMap<String, Map<String, Long>>(entryFromPersistence.getStat().getTokenCountPerGrantType());
                this.currentEntry = entryFromPersistence;
                this.log.trace("Stat entry {} loaded.", (Object)dn);
                if (StringUtils.isBlank((CharSequence)this.currentEntry.getMonth()) && this.currentEntry.getStat() != null) {
                    this.currentEntry.setMonth(this.currentEntry.getStat().getMonth());
                }
                return;
            }
            this.log.trace("Month does not match. Current month {}, entry month {}, entry dn: {}", new Object[]{currentMonth, entryFromPersistence != null ? entryFromPersistence.getStat().getMonth() : "", dn});
        }
        catch (EntryPersistenceException e) {
            this.log.trace("Stat entry is not found in persistence. dn: " + dn, (Throwable)e);
        }
        this.log.trace("Creating stat entry ...");
        this.hll = this.newHll();
        this.tokenCounters = new ConcurrentHashMap<String, Map<String, Long>>();
        this.currentEntry = new StatEntry();
        this.currentEntry.setId(this.nodeId);
        this.currentEntry.setDn(dn);
        this.currentEntry.setUserHllData(Base64.getEncoder().encodeToString(this.hll.toBytes()));
        this.currentEntry.getStat().setMonth(currentMonth);
        this.currentEntry.setMonth(currentMonth);
        this.entryManager.persist((Object)this.currentEntry);
        this.log.trace("Created stat entry.");
    }

    public HLL newHll() {
        return new HLL(15, 5);
    }

    private void initNodeId() {
        String currentMonth = this.currentMonth();
        if (StringUtils.isNotBlank((CharSequence)this.nodeId) && this.nodeId.endsWith(currentMonth)) {
            this.log.trace("NodeId is not blank: {}", (Object)this.nodeId);
            return;
        }
        try {
            this.nodeId = InetAddressUtility.getMACAddressOrNull() + "_" + currentMonth;
            if (StringUtils.isNotBlank((CharSequence)this.nodeId)) {
                this.log.trace("NodeId created: " + this.nodeId);
                return;
            }
            this.nodeId = UUID.randomUUID().toString() + "_" + currentMonth;
            this.log.trace("NodeId created: " + this.nodeId);
        }
        catch (Exception e) {
            this.log.error("Failed to identify nodeId.", (Throwable)e);
            this.nodeId = UUID.randomUUID().toString() + "_" + currentMonth;
            this.log.trace("NodeId created: " + this.nodeId);
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getBaseDn() {
        return this.staticConfiguration.getBaseDn().getStat();
    }

    private void prepareMonthlyBranch() {
        if (!this.entryManager.hasBranchesSupport(this.getBaseDn())) {
            this.log.trace("Monthly branch creation is skipped. DB does not support branches.");
            return;
        }
        String monthlyDn = this.currentMonthDn();
        try {
            if (!this.entryManager.contains(monthlyDn, SimpleBranch.class)) {
                this.createBranch(monthlyDn, this.currentMonth());
                this.log.info("Monthly branch is created: {}", (Object)monthlyDn);
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed to prepare monthly branch: " + monthlyDn, (Throwable)e);
            }
            throw e;
        }
    }

    public void createBranch(String branchDn, String ou) {
        block2: {
            try {
                SimpleBranch branch = new SimpleBranch();
                branch.setOrganizationalUnitName(ou);
                branch.setDn(branchDn);
                this.entryManager.persist((Object)branch);
            }
            catch (EntryPersistenceException ex) {
                if (this.entryManager.contains(branchDn, SimpleBranch.class)) break block2;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportActiveUser(String id) {
        if (!this.initialized) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        int hashCode = id.hashCode();
        try {
            this.setupCurrentEntry();
            HLL hLL = this.hll;
            synchronized (hLL) {
                this.hll.addRaw((long)hashCode);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to report active user, id: " + id + ", hash: " + hashCode, (Throwable)e);
        }
    }

    public void reportAccessToken(GrantType grantType) {
        this.reportToken(grantType, ACCESS_TOKEN_KEY);
    }

    public void reportLogoutStatusJwt(GrantType grantType) {
        this.reportToken(grantType, LOGOUT_STATUS_TOKEN_KEY);
    }

    public void reportIdToken(GrantType grantType) {
        this.reportToken(grantType, ID_TOKEN_KEY);
    }

    public void reportRefreshToken(GrantType grantType) {
        this.reportToken(grantType, REFRESH_TOKEN_KEY);
    }

    public void reportUmaToken(GrantType grantType) {
        this.reportToken(grantType, UMA_TOKEN_KEY);
    }

    private void reportToken(GrantType grantType, String tokenKey) {
        if (!this.initialized) {
            return;
        }
        if (grantType == null || tokenKey == null) {
            return;
        }
        if (this.tokenCounters == null) {
            this.log.error("Stat service is not initialized.");
            return;
        }
        Map tokenMap = this.tokenCounters.computeIfAbsent(grantType.getValue(), k -> new ConcurrentHashMap());
        Long counter = (Long)tokenMap.get(tokenKey);
        if (counter == null) {
            counter = 1L;
        } else {
            Long l = counter;
            counter = counter + 1L;
        }
        tokenMap.put(tokenKey, counter);
    }
}

