/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.token;

import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.token.JwtSigner;
import io.jans.as.server.service.DiscoveryService;
import io.jans.as.server.service.cluster.StatusIndexPoolService;
import io.jans.model.token.AbstractIndexPool;
import io.jans.model.tokenstatus.StatusList;
import io.jans.model.tokenstatus.TokenStatus;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class StatusListService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private DiscoveryService discoveryService;
    @Inject
    private StatusIndexPoolService statusTokenPoolService;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;

    public Response requestStatusList(String acceptHeader, String time) {
        this.log.debug("Attempting to request status_list, acceptHeader: {}, time: {} ...", (Object)acceptHeader, (Object)time);
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.STATUS_LIST);
        try {
            String responseType;
            this.validateTime(time);
            List pools = this.statusTokenPoolService.getAllPools();
            StatusList statusList = StatusListService.join(pools, this.appConfiguration.getStatusListBitSize(), this.log);
            boolean isJsonRequested = "application/statuslist+json".equalsIgnoreCase(acceptHeader);
            String entity = this.createEntity(isJsonRequested, statusList);
            String string = responseType = isJsonRequested ? "application/statuslist+json" : "application/statuslist+jwt";
            if (this.log.isTraceEnabled()) {
                this.log.trace("Response entity {}, responseType {}", (Object)entity, (Object)responseType);
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).type(responseType).build();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    public void validateTime(String time) {
        if (StringUtils.isNotBlank((CharSequence)time)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)"Time parameter is not supported.").build());
        }
    }

    private String createEntity(boolean isJsonRequested, StatusList statusList) throws Exception {
        JSONObject jsonObject = new JSONObject(statusList.encodeAsJSON());
        if (isJsonRequested) {
            return jsonObject.toString();
        }
        return this.createResponseJwt(jsonObject);
    }

    public static StatusList join(List<? extends AbstractIndexPool> pools, int bitSize, Logger log) {
        StatusList result = new StatusList(bitSize);
        for (AbstractIndexPool abstractIndexPool : pools) {
            try {
                String data = abstractIndexPool.getData();
                if (StringUtils.isBlank((CharSequence)data)) continue;
                StatusList poolStatusList = StatusList.fromEncoded((String)data, (int)bitSize);
                for (int i = 0; i < poolStatusList.getBitSetLength(); ++i) {
                    boolean isNotDefault;
                    int value = poolStatusList.get(i);
                    boolean bl = isNotDefault = value != TokenStatus.VALID.getValue();
                    if (!isNotDefault) continue;
                    result.set(i, value);
                }
            }
            catch (Exception e) {
                String msg = String.format("Failed to process status list from pool: %s, nodeId: %s", abstractIndexPool.getId(), abstractIndexPool.getNodeId());
                log.error(msg, (Throwable)e);
            }
        }
        return result;
    }

    public void addStatusClaimWithIndex(JsonWebResponse jwr, ExecutionContext executionContext) {
        if (!this.errorResponseFactory.isFeatureFlagEnabled(FeatureFlagType.STATUS_LIST)) {
            this.log.trace("Skipped status claim addition because {} feature flag is disabled.", (Object)FeatureFlagType.STATUS_LIST.getValue());
            return;
        }
        Integer index = executionContext.getStatusListIndex();
        if (index == null || index < 0) {
            return;
        }
        JSONObject indexAndUri = new JSONObject();
        indexAndUri.put("idx", (Object)index);
        indexAndUri.put("uri", (Object)this.getSub());
        JSONObject statusList = new JSONObject();
        statusList.put("status_list", (Object)indexAndUri);
        jwr.getClaims().setClaim("status", statusList);
    }

    public String getSub() {
        return this.discoveryService.getStatusListEndpoint();
    }

    public String createResponseJwt(JSONObject response) throws Exception {
        this.log.trace("Creating status list JWT response {} ...", (Object)response);
        JwtSigner jwtSigner = this.newJwtSigner();
        Jwt jwt = jwtSigner.newJwt();
        jwt.getHeader().setType(JwtType.STATUS_LIST_JWT);
        this.fillPayload((JsonWebResponse)jwt, response);
        String jwtString = jwtSigner.sign().toString();
        this.log.trace("Created status list JWT response {}", (Object)jwtString);
        return jwtString;
    }

    private JwtSigner newJwtSigner() {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm());
        if (this.appConfiguration.getStatusListResponseJwtSignatureAlgorithm() != null) {
            signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getStatusListResponseJwtSignatureAlgorithm());
        }
        return new JwtSigner(this.appConfiguration, (JSONWebKeySet)this.webKeysConfiguration, signatureAlgorithm, "", null);
    }

    public void fillPayload(JsonWebResponse jwr, JSONObject response) throws InvalidJwtException {
        int lifetime = this.appConfiguration.getStatusListResponseJwtLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifetime);
        Date expiration = calendar.getTime();
        jwr.getClaims().setExpirationTime(expiration);
        jwr.getClaims().setIat(issuedAt);
        jwr.getClaims().setNbf(issuedAt);
        jwr.getClaims().setClaim("ttl", Integer.valueOf(lifetime));
        jwr.getClaims().setClaim("sub", this.getSub());
        try {
            jwr.getClaims().setClaim("status_list", response);
        }
        catch (Exception e) {
            this.log.error("Failed to put claims into status list jwt. Key: status_list, response: " + response.toString(), (Throwable)e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Response before signing: {}", (Object)jwr.getClaims().toJsonString());
        }
    }
}

