/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.servlet;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.util.CertUtils;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.token.TokenService;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

@WebServlet(urlPatterns={"/open-banking/v3.1/aisp/accounts"}, loadOnStartup=9)
public class AccountsServlet
extends HttpServlet {
    private static final long serialVersionUID = -8224898157373678903L;
    @Inject
    private Logger log;
    @Inject
    private TokenService tokenService;
    @Inject
    private ClientService clientService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;

    public void init() throws ServletException {
        this.log.info("Inside init method of get Accounts Servlet  ***********************************************************************");
    }

    JSONObject getAccount(String nickname, String currency, String accountId, String openingDate, String statusUpdateDateTime, String accountSubType, String status, String accountType) {
        JSONObject account = new JSONObject();
        account.put("Nickname", (Object)nickname);
        account.put("Currency", (Object)currency);
        account.put("AccountId", (Object)accountId);
        account.put("OpeningDate", (Object)openingDate);
        account.put("StatusUpdateDateTime", (Object)statusUpdateDateTime);
        account.put("AccountSubType", (Object)accountSubType);
        account.put("Status", (Object)status);
        account.put("AccountType", (Object)accountType);
        return account;
    }

    protected void processRequest(HttpServletRequest servletRequest, HttpServletResponse httpResponse) {
        this.log.info("Starting processRequest method of get Account Servlet***********************************************************************");
        String authFromReq = null;
        String xfapiinteractionid = null;
        String tempaccess_token = null;
        httpResponse.setCharacterEncoding("UTF-8");
        httpResponse.setContentType("application/json;charset=UTF-8");
        try (PrintWriter out = httpResponse.getWriter();){
            String clientCertAsPem;
            xfapiinteractionid = servletRequest.getHeader("x-fapi-interaction-id");
            tempaccess_token = servletRequest.getParameter("access_token");
            if (xfapiinteractionid != null) {
                httpResponse.addHeader("x-fapi-interaction-id", xfapiinteractionid);
            } else {
                xfapiinteractionid = UUID.randomUUID().toString();
                httpResponse.addHeader("x-fapi-interaction-id", xfapiinteractionid);
            }
            if (tempaccess_token != null && xfapiinteractionid != null) {
                if (tempaccess_token.startsWith("Bearer")) {
                    httpResponse.sendError(400, "Bearer token in query is disallowed");
                    this.log.info("FAPI ACcount: Authorization Bearer Token is not allowed in query*********************************************");
                } else {
                    httpResponse.sendError(400, "token in query is disallowed");
                    this.log.info("FAPI: Authorization token is non-Bearer is not allowed in query*********************************************");
                }
            }
            if ((clientCertAsPem = servletRequest.getHeader("X-ClientCert")) != null) {
                this.log.info("FAPI Account: clientCertAsPem found*****************************************" + clientCertAsPem);
            } else {
                this.log.info("FAPI Account: Nooooooooo clientCertAsPem *****************************************");
            }
            authFromReq = servletRequest.getHeader("Authorization");
            String clientDn = null;
            Client cl = null;
            clientDn = this.tokenService.getClientDn(authFromReq);
            X509Certificate cert = CertUtils.x509CertificateFromPem((String)clientCertAsPem);
            AuthorizationGrant authorizationGrant = this.tokenService.getBearerAuthorizationGrant(authFromReq);
            if (authorizationGrant == null || cert == null) {
                this.sendError(httpResponse, authorizationGrant == null ? "Unable to find authorization grant." : "Failed to parse client certificate.");
                return;
            }
            PublicKey publicKey = cert.getPublicKey();
            byte[] encodedKey = publicKey.getEncoded();
            if (clientDn != null) {
                this.log.info("FAPI Account: ClientDn from Authoirization(tokenService) *********************************************" + clientDn);
                cl = this.clientService.getClientByDn(clientDn);
                JSONObject jsonWebKeys = new JSONObject(cl.getJwks());
                if (jsonWebKeys == null) {
                    this.log.debug("FAPI Account:********************Unable to load json web keys for client: {}, jwks_uri: {}, jks: {}", new Object[]{cl.getClientId(), cl.getJwksUri(), cl.getJwks()});
                }
                int matchctr = 0;
                JSONWebKeySet keySet = JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys);
                try {
                    for (JSONWebKey key : keySet.getKeys()) {
                        if (!ArrayUtils.isEquals((Object)encodedKey, (Object)this.cryptoProvider.getPublicKey(key.getKid(), jsonWebKeys, null).getEncoded())) continue;
                        ++matchctr;
                        this.log.debug("FAPI  Account: ********************************Client {} authenticated via `self_signed_tls_client_auth`, matched kid: {}.", (Object)cl.getClientId(), (Object)key.getKid());
                    }
                    if (matchctr == 0) {
                        this.log.error("FAPI Account: Client certificate does not match clientId. clientId: " + cl.getClientId() + "*********************************************");
                        httpResponse.setStatus(401, "The resource owner or authorization server denied the request");
                        return;
                    }
                }
                catch (Exception e) {
                    this.log.info("FAPI Account: Exception while keymatching****************************************************************");
                }
            } else {
                this.log.info("FAPI Account: ClientDn from Authoirization(tokenService) is NULL*********************************************");
            }
            JSONObject jsonObj = new JSONObject();
            JSONArray accounts = new JSONArray();
            jsonObj.put("Links", (Object)new JSONObject().put("self", (Object)"/open-banking/v3.1/aisp/accounts"));
            jsonObj.put("Meta", (Object)new JSONObject().put("TotalPages", 1));
            accounts.put((Object)this.getAccount("Account1", "GBP", "352413", "05 May 2021", "08 Jun 2021", "CurrentAccount", "Enabled", "Personal"));
            accounts.put((Object)this.getAccount("Account2", "GBP", "4736325", "25 Mar 2021", "23 Apr 2021", "CurrentAccount", "Enabled", "Personal"));
            jsonObj.put("Data", (Object)new JSONObject().put("Account", (Object)accounts));
            out.print(jsonObj.toString());
            httpResponse.setStatus(200, "OK");
            out.flush();
            this.log.info("Finished processRequest method of get Account Servlet ***********************************************************************");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void sendError(HttpServletResponse response, String error) throws IOException {
        this.log.error(error);
        response.sendError(401, error);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Account Access Consent";
    }
}

