/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.servlet;

import io.jans.as.common.service.OrganizationService;
import io.jans.as.persistence.model.GluuOrganization;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(urlPatterns={"/servlet/favicon"})
public class FaviconServlet
extends HttpServlet {
    @Inject
    private OrganizationService organizationService;
    private static final long serialVersionUID = 5445488800130871634L;
    private static final Logger log = LoggerFactory.getLogger(FaviconServlet.class);
    public static final String BASE_OXAUTH_FAVICON_PATH = "/opt/gluu/jetty/jans-auth/custom/static/favicon/";

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("image/x-icon");
        response.setDateHeader("Expires", new Date().getTime() + 1800000L);
        GluuOrganization organization = this.organizationService.getOrganization();
        boolean hasSucceed = this.readCustomFavicon(response, organization);
        if (!hasSucceed) {
            this.readDefaultFavicon(response);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean readDefaultFavicon(HttpServletResponse response) {
        String defaultFaviconFileName = "/WEB-INF/static/favicon.ico";
        try (InputStream in = this.getServletContext().getResourceAsStream(defaultFaviconFileName);){
            boolean bl;
            block14: {
                ServletOutputStream out = response.getOutputStream();
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    bl = true;
                    if (out == null) break block14;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                out.close();
            }
            return bl;
        }
        catch (IOException e) {
            log.debug("Error loading default favicon: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean readCustomFavicon(HttpServletResponse response, GluuOrganization organization) {
        File faviconPath;
        if (organization.getJsFaviconPath() == null || StringUtils.isEmpty((CharSequence)organization.getJsFaviconPath())) {
            return false;
        }
        File directory = new File(BASE_OXAUTH_FAVICON_PATH);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (!(faviconPath = new File(organization.getJsFaviconPath())).exists()) {
            return false;
        }
        try (FileInputStream in = new FileInputStream(faviconPath);){
            boolean bl;
            block16: {
                ServletOutputStream out = response.getOutputStream();
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    bl = true;
                    if (out == null) break block16;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                out.close();
            }
            return bl;
        }
        catch (IOException e) {
            log.debug("Error loading custom favicon: " + e.getMessage());
            return false;
        }
    }
}

