/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.session.ws.rs;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.server.service.CookieService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.util.ServerUtil;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;

@Path(value="/")
public class CheckSessionStatusRestWebServiceImpl {
    public static final String SESSION_CUSTOM_STATE = "session_custom_state";
    @Inject
    private Logger log;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    @GET
    @Path(value="/session_status")
    @Produces(value={"application/json"})
    public Response requestCheckSessionStatus(@Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse, @Context SecurityContext securityContext) throws IOException {
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.STATUS_SESSION);
        String sessionIdCookie = this.cookieService.getSessionIdFromCookie(httpRequest);
        this.log.debug("Found session '{}' cookie: '{}'", (Object)"session_id", (Object)sessionIdCookie);
        CheckSessionResponse response = new CheckSessionResponse("unknown", "");
        SessionId sessionId = this.sessionIdService.getSessionId(sessionIdCookie);
        if (sessionId != null) {
            response.setState(sessionId.getState().getValue());
            response.setAuthTime(sessionId.getAuthenticationTime());
            String sessionCustomState = (String)sessionId.getSessionAttributes().get(SESSION_CUSTOM_STATE);
            if (StringHelper.isNotEmpty((String)sessionCustomState)) {
                response.setCustomState(sessionCustomState);
            }
        }
        String responseJson = ServerUtil.asJson(response);
        this.log.debug("Check session status response: '{}'", (Object)responseJson);
        return Response.ok().type("application/json").entity((Object)responseJson).cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate()).header("Pragma", (Object)"no-cache").build();
    }

    class CheckSessionResponse {
        @JsonProperty(value="state")
        String state;
        @JsonProperty(value="custom_state")
        String customState;
        @JsonProperty(value="auth_time")
        Date authTime;

        public CheckSessionResponse(String state, String stateExt) {
            this.state = state;
            this.customState = stateExt;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getCustomState() {
            return this.customState;
        }

        public void setCustomState(String customState) {
            this.customState = customState;
        }

        public Date getAuthTime() {
            return this.authTime;
        }

        public void setAuthTime(Date authTime) {
            this.authTime = authTime;
        }
    }
}

