/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.session.ws.rs;

import io.jans.as.client.service.ClientFactory;
import io.jans.as.model.util.Util;
import io.jans.as.server.util.ServerUtil;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndSessionUtils {
    private static final Logger log = LoggerFactory.getLogger(EndSessionUtils.class);

    private EndSessionUtils() {
    }

    public static ExecutorService getExecutorService() {
        return Executors.newCachedThreadPool(ServerUtil.daemonThreadFactory());
    }

    public static void callRpWithBackchannelUri(String backchannelLogoutUri, String logoutToken) {
        ResteasyClient client = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine((ClientHttpEngine)ClientFactory.instance().createEngine(true)).build();
        WebTarget target = client.target(backchannelLogoutUri);
        log.debug("Calling RP with backchannel, backchannel_logout_uri: {}", (Object)backchannelLogoutUri);
        try (Response response = target.request().post(Entity.form((Form)new Form("logout_token", logoutToken)));){
            log.debug("Backchannel RP response, status: {}, backchannel_logout_uri: {}", (Object)response.getStatus(), (Object)backchannelLogoutUri);
        }
        catch (Exception e) {
            log.error("Failed to call backchannel_logout_uri" + backchannelLogoutUri + ", message: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String appendState(String uri, String state) {
        if (StringUtils.isBlank((CharSequence)state)) {
            return uri;
        }
        if (uri.contains("?")) {
            if (uri.contains("state=")) {
                return uri;
            }
            return uri + "&state=" + state;
        }
        return uri + "?state=" + state;
    }

    public static String appendSid(String logoutUri, String sid, String issuer) {
        if (logoutUri.contains("?")) {
            return logoutUri + "&sid=" + sid + "&iss=" + issuer;
        }
        return logoutUri + "?sid=" + sid + "&iss=" + issuer;
    }

    public static String createFronthannelHtml(Set<String> logoutUris, String postLogoutUrl, String state) {
        Object iframes = "";
        for (String logoutUri : logoutUris) {
            iframes = (String)iframes + String.format("<iframe height=\"0\" width=\"0\" src=\"%s\" sandbox=\"allow-same-origin allow-scripts allow-popups allow-forms\"></iframe>", logoutUri);
        }
        Object html = "<!DOCTYPE html><html><head>";
        if (!Util.isNullOrEmpty((String)postLogoutUrl)) {
            if (!Util.isNullOrEmpty((String)state)) {
                postLogoutUrl = ((String)postLogoutUrl).contains("?") ? (String)postLogoutUrl + "&state=" + state : (String)postLogoutUrl + "?state=" + state;
            }
            html = (String)html + "<script>window.onload=function() {window.location='" + (String)postLogoutUrl + "'}</script>";
        }
        html = (String)html + "<title>Your logout was successful</title></head><body>Your logout was successful.<br/>" + (String)iframes + "</body></html>";
        return html;
    }
}

