/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ssa.ws.rs;

import io.jans.as.common.model.ssa.Ssa;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.json.JsonApplier;
import io.jans.as.model.ssa.SsaRequestParam;
import io.jans.as.model.util.DateUtil;
import io.jans.as.model.util.Util;
import io.jans.orm.annotation.AttributeEnum;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Stateless
@Named
public class SsaJsonService {
    @Inject
    private AppConfiguration appConfiguration;

    public String jsonObjectToString(JSONObject jsonObject) throws JSONException {
        return jsonObject.toString(4).replace("\\/", "/");
    }

    public String jsonArrayToString(JSONArray jsonArray) throws JSONException {
        return jsonArray.toString(4).replace("\\/", "/");
    }

    public JSONArray getJSONArray(List<Ssa> ssaList) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        if (ssaList == null) {
            return jsonArray;
        }
        for (Ssa ssa : ssaList) {
            JSONObject responseJsonObject = new JSONObject();
            JsonApplier.getInstance().apply(ssaList, responseJsonObject);
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)SsaRequestParam.CREATED_AT.getName(), (Object)DateUtil.dateToUnixEpoch((Date)ssa.getCreationDate()));
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)SsaRequestParam.EXPIRATION.getName(), (Object)DateUtil.dateToUnixEpoch((Date)ssa.getExpirationDate()));
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)SsaRequestParam.ISSUER.getName(), (Object)ssa.getCreatorId());
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)SsaRequestParam.STATUS.getName(), (AttributeEnum)ssa.getState());
            JSONObject jsonSsa = new JSONObject();
            JsonApplier.getInstance().apply((Object)ssa, jsonSsa);
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.ORG_ID.getName(), (Object)ssa.getOrgId());
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.SOFTWARE_ID.getName(), (Object)ssa.getAttributes().getSoftwareId());
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.SOFTWARE_ROLES.getName(), (Object)ssa.getAttributes().getSoftwareRoles());
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.GRANT_TYPES.getName(), (Object)ssa.getAttributes().getGrantTypes());
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.ISS.getName(), (Object)this.appConfiguration.getIssuer());
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.IAT.getName(), (Object)DateUtil.dateToUnixEpoch((Date)ssa.getCreationDate()));
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.EXP.getName(), (Object)DateUtil.dateToUnixEpoch((Date)ssa.getExpirationDate()));
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.JTI.getName(), (Object)ssa.getId());
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.DESCRIPTION.getName(), (Object)ssa.getDescription());
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.ONE_TIME_USE.getName(), (Object)ssa.getAttributes().getOneTimeUse());
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.ROTATE_SSA.getName(), (Object)ssa.getAttributes().getRotateSsa());
            Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)SsaRequestParam.LIFETIME.getName(), (Object)ssa.getAttributes().getLifetime());
            if (!ssa.getAttributes().getCustomAttributes().isEmpty()) {
                ssa.getAttributes().getCustomAttributes().forEach((key, value) -> Util.addToJSONObjectIfNotNull((JSONObject)jsonSsa, (String)key, (Object)value));
            }
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)SsaRequestParam.SSA.getName(), (Object)jsonSsa);
            jsonArray.put((Object)responseJsonObject);
        }
        return jsonArray;
    }

    public JSONObject getJSONObject(String jwt) throws JSONException {
        JSONObject responseJsonObject = new JSONObject();
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)SsaRequestParam.SSA.getName(), (Object)jwt);
        return responseJsonObject;
    }
}

