/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ssa.ws.rs.action;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.ssa.Ssa;
import io.jans.as.common.model.ssa.SsaState;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.ssa.SsaErrorResponseType;
import io.jans.as.model.ssa.SsaScopeType;
import io.jans.as.server.service.external.ModifySsaResponseService;
import io.jans.as.server.service.external.context.ModifySsaResponseContext;
import io.jans.as.server.ssa.ws.rs.SsaContextBuilder;
import io.jans.as.server.ssa.ws.rs.SsaJsonService;
import io.jans.as.server.ssa.ws.rs.SsaRestWebServiceValidator;
import io.jans.as.server.ssa.ws.rs.SsaService;
import io.jans.as.server.util.ServerUtil;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.slf4j.Logger;

@Stateless
@Named
public class SsaGetAction {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private SsaJsonService ssaJsonService;
    @Inject
    private SsaService ssaService;
    @Inject
    private ModifySsaResponseService modifySsaResponseService;
    @Inject
    private SsaRestWebServiceValidator ssaRestWebServiceValidator;
    @Inject
    private SsaContextBuilder ssaContextBuilder;

    public Response get(String jti, String orgId, HttpServletRequest httpRequest) {
        this.log.debug("Attempting to read ssa: softwareRoles = {}, orgId = {}", (Object)jti, (Object)orgId);
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.SSA);
        Response.ResponseBuilder builder = Response.ok();
        try {
            Client client = this.ssaRestWebServiceValidator.getClientFromSession();
            this.ssaRestWebServiceValidator.checkScopesPolicy(client, Arrays.asList(SsaScopeType.SSA_ADMIN.getValue(), SsaScopeType.SSA_PORTAL.getValue(), SsaScopeType.SSA_DEVELOPER.getValue()));
            List<Ssa> ssaList = this.ssaService.getSsaList(jti, orgId, SsaState.ACTIVE, client.getClientId(), client.getScopes());
            JSONArray jsonArray = this.ssaJsonService.getJSONArray(ssaList);
            ModifySsaResponseContext context = this.ssaContextBuilder.buildModifySsaResponseContext(httpRequest, client);
            jsonArray = this.modifyGetScript(jsonArray, context, ssaList);
            builder.entity((Object)this.ssaJsonService.jsonArrayToString(jsonArray));
        }
        catch (WebApplicationException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)SsaErrorResponseType.UNKNOWN_ERROR, "Unknown error");
        }
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        builder.type(MediaType.APPLICATION_JSON_TYPE);
        return builder.build();
    }

    private JSONArray modifyGetScript(JSONArray jsonArray, ModifySsaResponseContext context, List<Ssa> ssaList) {
        if (!this.modifySsaResponseService.get(jsonArray, context)) {
            return this.ssaJsonService.getJSONArray(ssaList);
        }
        return jsonArray;
    }
}

