/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.token.ws.rs;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.AttributeService;
import io.jans.as.common.util.CommonUtils;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.authorize.ws.rs.AuthzDetailsService;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.common.IdToken;
import io.jans.as.server.model.common.JwtBearerGrant;
import io.jans.as.server.model.common.RefreshToken;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.UserService;
import io.jans.as.server.service.external.ExternalUpdateTokenService;
import io.jans.as.server.service.external.context.ExternalUpdateTokenContext;
import io.jans.as.server.token.ws.rs.TokenCreatorService;
import io.jans.as.server.token.ws.rs.TokenRestWebServiceImpl;
import io.jans.as.server.util.ServerUtil;
import io.jans.util.security.StringEncrypter;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class JwtGrantService {
    public static final User EMPTY_USER = new User();
    @Inject
    private Logger log;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private ClientService clientService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private AuthzDetailsService authzDetailsService;
    @Inject
    private TokenCreatorService tokenCreatorService;
    @Inject
    private ExternalUpdateTokenService externalUpdateTokenService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private UserService userService;

    public JSONObject processJwtBearer(String assertion, String scope, HttpServletRequest httpRequest, Client client, Function<JsonWebResponse, Void> idTokenPreProcessing, ExecutionContext executionContext) throws StringEncrypter.EncryptionException, CryptoProviderException {
        this.log.debug("processJwtBearer - started with client_id: {}, assertion: {}", (Object)client.getClientId(), (Object)assertion);
        User user = this.validateAssertion(assertion, client, executionContext);
        JwtBearerGrant grant = this.authorizationGrantList.createJwtBearerGrant(user, client);
        executionContext.setGrant(grant);
        scope = grant.checkScopesPolicy(scope);
        this.log.trace("Granted scopes: {}", (Object)scope);
        AuthzDetails checkedAuthzDetails = this.authzDetailsService.checkAuthzDetailsAndSave(executionContext.getAuthzDetails(), grant);
        AccessToken accessToken = grant.createAccessToken(executionContext);
        IdToken idToken = null;
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getOpenidScopeBackwardCompatibility()) && grant.getScopes().contains("openid")) {
            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
            ExternalUpdateTokenContext context = new ExternalUpdateTokenContext(httpRequest, grant, client, this.appConfiguration, this.attributeService);
            executionContext.setIncludeIdTokenClaims(includeIdTokenClaims);
            executionContext.setPreProcessing(idTokenPreProcessing);
            executionContext.setPostProcessor(this.externalUpdateTokenService.buildModifyIdTokenProcessor(context));
            idToken = grant.createIdToken(null, null, null, null, null, executionContext);
        }
        RefreshToken reToken = this.tokenCreatorService.createRefreshToken(executionContext, scope);
        executionContext.getAuditLog().updateOAuth2AuditLog(grant, true);
        JSONObject jsonObj = new JSONObject();
        try {
            TokenRestWebServiceImpl.fillJsonObject(jsonObj, accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), reToken, scope, idToken, checkedAuthzDetails);
            jsonObj.put("issued_token_type", (Object)"urn:ietf:params:oauth:token-type:access_token");
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        this.log.debug("processJwtBearer - Built jsonResponse: {}", (Object)jsonObj.toString());
        return jsonObj;
    }

    private User validateAssertion(String assertion, Client client, ExecutionContext executionContext) throws CryptoProviderException, StringEncrypter.EncryptionException {
        this.log.debug("Assertion: {}", (Object)assertion);
        Jwt jwt = Jwt.parseSilently((String)assertion);
        if (jwt == null) {
            String msg = "'assertion' parameter is not valid JWT.";
            this.log.debug("'assertion' parameter is not valid JWT.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "'assertion' parameter is not valid JWT."), executionContext.getAuditLog()));
        }
        try {
            this.verifySignature(jwt, client, executionContext);
            this.verifyIssuer(jwt, executionContext);
            this.verifySubject(jwt, executionContext);
            this.verifyAudience(jwt, executionContext);
            this.verifyExpiration(jwt, executionContext);
            this.verifyNbf(jwt, executionContext);
            this.log.debug("Assertion validated successfully.");
            String uid = jwt.getClaims().getClaimAsString("uid");
            if (StringUtils.isNotBlank((CharSequence)uid) && this.appConfiguration.getJwtGrantAllowUserByUidInAssertion().booleanValue()) {
                this.log.debug("Trying to find user by uid {}", (Object)uid);
                User user = this.userService.getUser(uid, new String[0]);
                this.log.debug("User by uid {} {}", (Object)uid, (Object)(user != null ? " is found" : " is NOT found"));
                return user != null ? user : EMPTY_USER;
            }
            return EMPTY_USER;
        }
        catch (InvalidJwtException e) {
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "'assertion' parameter is not valid."), executionContext.getAuditLog()));
        }
    }

    private void verifyNbf(Jwt jwt, ExecutionContext executionContext) {
        Date nbf = jwt.getClaims().getClaimAsDate("nbf");
        if (nbf == null || new Date().after(nbf)) {
            return;
        }
        String msg = "Forbidden by 'nbf': " + nbf;
        this.log.debug(msg);
        throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, msg), executionContext.getAuditLog()));
    }

    private void verifySignature(Jwt jwt, Client client, ExecutionContext executionContext) throws StringEncrypter.EncryptionException, CryptoProviderException, InvalidJwtException {
        SignatureAlgorithm signatureAlgorithm = jwt.getHeader().getSignatureAlgorithm();
        String clientSecret = this.clientService.decryptSecret(client.getClientSecret());
        String keyId = jwt.getHeader().getKeyId();
        JSONObject jwks = CommonUtils.getJwks((Client)client);
        boolean validSignature = this.cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), keyId, jwks, clientSecret, signatureAlgorithm);
        if (!validSignature) {
            String msg = "'assertion' signature is not valid.";
            this.log.debug("'assertion' signature is not valid.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "'assertion' signature is not valid."), executionContext.getAuditLog()));
        }
    }

    private void verifyIssuer(Jwt jwt, ExecutionContext executionContext) {
        String issuer = jwt.getClaims().getClaimAsString("iss");
        if (StringUtils.isBlank((CharSequence)issuer)) {
            String msg = "'iss' claim value is absent.";
            this.log.debug("'iss' claim value is absent.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "'iss' claim value is absent."), executionContext.getAuditLog()));
        }
        Map trustedIssuers = this.appConfiguration.getTrustedSsaIssuers();
        if (!trustedIssuers.isEmpty() && !trustedIssuers.keySet().contains(issuer)) {
            String msg = "Issuer is not trusted. Please configure 'trustedSsaIssuers' AS configuration property.";
            this.log.debug("Issuer is not trusted. Please configure 'trustedSsaIssuers' AS configuration property.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "Issuer is not trusted. Please configure 'trustedSsaIssuers' AS configuration property."), executionContext.getAuditLog()));
        }
    }

    private void verifySubject(Jwt jwt, ExecutionContext executionContext) {
        String subject = jwt.getClaims().getClaimAsString("sub");
        if (StringUtils.isBlank((CharSequence)subject)) {
            String msg = "'sub' claim value is absent.";
            this.log.debug("'sub' claim value is absent.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "'sub' claim value is absent."), executionContext.getAuditLog()));
        }
    }

    private void verifyAudience(Jwt jwt, ExecutionContext executionContext) {
        List audience = jwt.getClaims().getClaimAsStringList("aud");
        if (audience.isEmpty()) {
            String msg = "'aud' claim value is absent.";
            this.log.debug("'aud' claim value is absent.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "'aud' claim value is absent."), executionContext.getAuditLog()));
        }
        String serverIssuer = this.appConfiguration.getIssuer();
        if (audience.stream().noneMatch(aud -> aud.equals(serverIssuer) || aud.startsWith(serverIssuer))) {
            String msg = "'aud' is invalid.";
            this.log.debug("'aud' is invalid.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "'aud' is invalid."), executionContext.getAuditLog()));
        }
    }

    public void verifyExpiration(Jwt jwt, ExecutionContext executionContext) {
        Date expirationTime = jwt.getClaims().getClaimAsDate("exp");
        if (expirationTime != null && expirationTime.after(new Date())) {
            return;
        }
        String msg = "'assertion' is expired";
        this.log.debug("'assertion' is expired");
        throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "'assertion' is expired"), executionContext.getAuditLog()));
    }

    private Response response(Response.ResponseBuilder builder, OAuth2AuditLog oAuth2AuditLog) {
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    public Response.ResponseBuilder error(int status, TokenErrorResponseType type, String reason) {
        return Response.status((int)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)type, reason));
    }
}

