/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.token.ws.rs;

import com.google.common.base.Strings;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.model.session.SessionIdState;
import io.jans.as.model.authorize.CodeVerifier;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.AuthorizationCodeGrant;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.DeviceAuthorizationCacheControl;
import io.jans.as.server.model.common.RefreshToken;
import io.jans.as.server.util.ServerUtil;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Named
@Stateless
public class TokenRestWebServiceValidator {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private AbstractCryptoProvider cryptoProvider;

    public void validatePKCE(AuthorizationCodeGrant grant, String codeVerifier, OAuth2AuditLog oAuth2AuditLog, Client client) {
        boolean requirePkce;
        this.log.trace("PKCE validation, code_verifier: {}, code_challenge: {}, method: {}", new Object[]{codeVerifier, grant.getCodeChallenge(), grant.getCodeChallengeMethod()});
        boolean bl = requirePkce = BooleanUtils.isTrue((Boolean)this.appConfiguration.getRequirePkce()) || client.getAttributes().getRequirePkce() != false;
        if (requirePkce && (Strings.isNullOrEmpty((String)codeVerifier) || Strings.isNullOrEmpty((String)grant.getCodeChallenge()))) {
            if (this.log.isErrorEnabled()) {
                this.log.error("PKCE is required but code_challenge or code verifier is blank, grantId: {}, codeVerifier: {}, codeChallenge: {}", new Object[]{grant.getGrantId(), codeVerifier, grant.getCodeChallenge()});
            }
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "PKCE check fails. Code challenge does not match to request code verifier."), oAuth2AuditLog));
        }
        if (Strings.isNullOrEmpty((String)grant.getCodeChallenge()) && Strings.isNullOrEmpty((String)codeVerifier)) {
            return;
        }
        if (!CodeVerifier.matched((String)grant.getCodeChallenge(), (String)grant.getCodeChallengeMethod(), (String)codeVerifier)) {
            this.log.error("PKCE check fails. Code challenge does not match to request code verifier, grantId: {}, codeVerifier: {}", (Object)grant.getGrantId(), (Object)codeVerifier);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "PKCE check fails. Code challenge does not match to request code verifier."), oAuth2AuditLog));
        }
    }

    public void validateParams(String grantType, String code, String refreshToken, OAuth2AuditLog auditLog) {
        this.log.debug("Starting to validate request parameters");
        if (grantType == null || grantType.isEmpty()) {
            String msg = "Grant Type is not set.";
            this.log.trace("Grant Type is not set.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "Grant Type is not set."), auditLog));
        }
        GrantType gt = GrantType.fromString((String)grantType);
        if (gt == GrantType.AUTHORIZATION_CODE) {
            if (StringUtils.isBlank((CharSequence)code)) {
                String msg = "Code is not set for AUTHORIZATION_CODE.";
                this.log.trace("Code is not set for AUTHORIZATION_CODE.");
                throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "Code is not set for AUTHORIZATION_CODE."), auditLog));
            }
            return;
        }
        if (gt == GrantType.REFRESH_TOKEN && StringUtils.isBlank((CharSequence)refreshToken)) {
            String msg = "Refresh Token is not set for REFRESH_TOKEN.";
            this.log.trace("Refresh Token is not set for REFRESH_TOKEN.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "Refresh Token is not set for REFRESH_TOKEN."), auditLog));
        }
    }

    public static boolean validateParams(String clientId, String clientSecret) {
        return StringUtils.isNotBlank((CharSequence)clientId) && StringUtils.isNotBlank((CharSequence)clientSecret);
    }

    public void validateGrantType(GrantType requestedGrantType, Client client, OAuth2AuditLog auditLog) {
        List<GrantType> clientGrantTypes = Arrays.asList(client.getGrantTypes());
        if (!clientGrantTypes.contains(requestedGrantType)) {
            String msg = "GrantType is not allowed by client's grantTypes.";
            this.log.trace("GrantType is not allowed by client's grantTypes.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "GrantType is not allowed by client's grantTypes."), auditLog));
        }
        if (!this.appConfiguration.getGrantTypesSupported().contains(requestedGrantType)) {
            String msg = "GrantType is not allowed by AS configuration";
            this.log.trace("GrantType is not allowed by AS configuration");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "GrantType is not allowed by AS configuration"), auditLog));
        }
    }

    private Response response(Response.ResponseBuilder builder, OAuth2AuditLog oAuth2AuditLog) {
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    public Response.ResponseBuilder error(int status, TokenErrorResponseType type, String reason) {
        return Response.status((int)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)type, reason));
    }

    @NotNull
    public Client validateClient(Client client, OAuth2AuditLog auditLog) {
        if (client == null) {
            throw new WebApplicationException(this.response(this.error(Response.Status.UNAUTHORIZED.getStatusCode(), TokenErrorResponseType.INVALID_GRANT, "Unable to find client."), auditLog));
        }
        this.log.debug("Get client from session: '{}'", (Object)client.getClientId());
        if (client.isDisabled()) {
            throw new WebApplicationException(this.response(this.error(Response.Status.FORBIDDEN.getStatusCode(), TokenErrorResponseType.DISABLED_CLIENT, "Client is disabled."), auditLog));
        }
        return client;
    }

    public void validateDeviceAuthorization(Client client, String deviceCode, DeviceAuthorizationCacheControl cacheData, OAuth2AuditLog oAuth2AuditLog) {
        if (cacheData == null) {
            this.log.debug("The authentication request has expired for deviceCode: '{}'", (Object)deviceCode);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.EXPIRED_TOKEN, "The authentication request has expired."), oAuth2AuditLog));
        }
        if (!cacheData.getClient().getClientId().equals(client.getClientId())) {
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "The client is not authorized."), oAuth2AuditLog));
        }
    }

    public void validateGrant(AuthorizationGrant grant, Client client, Object identifier, OAuth2AuditLog auditLog) {
        this.validateGrant(grant, client, identifier, auditLog, null);
    }

    public void validateRedirectUri(String redirectUri, OAuth2AuditLog auditLog) {
        if (StringUtils.isBlank((CharSequence)redirectUri)) {
            String msg = "redirect_uri is not set for AUTHORIZATION_CODE.";
            this.log.trace("redirect_uri is not set for AUTHORIZATION_CODE.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "redirect_uri is not set for AUTHORIZATION_CODE."), auditLog));
        }
    }

    public void validateGrant(AuthorizationGrant grant, Client client, Object identifier, OAuth2AuditLog auditLog, Consumer<AuthorizationGrant> onFailure) {
        if (grant == null) {
            this.log.debug("AuthorizationGrant not found by clientId: '{}', identifier: '{}'", (Object)client.getClientId(), identifier);
            if (onFailure != null) {
                onFailure.accept(grant);
            }
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Unable to find grant object for given code."), auditLog));
        }
        if (!client.getClientId().equals(grant.getClientId())) {
            this.log.debug("AuthorizationGrant is found but belongs to another client. Grant's clientId: '{}', identifier: '{}'", (Object)grant.getClientId(), identifier);
            if (onFailure != null) {
                onFailure.accept(grant);
            }
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Client mismatch."), auditLog));
        }
    }

    public void validateRefreshToken(RefreshToken refreshTokenObject, OAuth2AuditLog auditLog) {
        if (refreshTokenObject == null || !refreshTokenObject.isValid()) {
            this.log.trace("Invalid refresh token.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Unable to find refresh token or otherwise token type or client does not match."), auditLog));
        }
    }

    public void validateUser(User user, OAuth2AuditLog auditLog) {
        if (user == null) {
            this.log.debug("Invalid user", (Throwable)new RuntimeException("User is empty"));
            throw new WebApplicationException(this.response(this.error(401, TokenErrorResponseType.INVALID_CLIENT, "Invalid user."), auditLog));
        }
    }

    public void validateSubjectTokenType(String subjectTokenType, OAuth2AuditLog auditLog) {
        if (!"urn:ietf:params:oauth:token-type:id_token".equalsIgnoreCase(subjectTokenType)) {
            String msg = String.format("Unsupported subject_token_type: %s", subjectTokenType);
            this.log.trace(msg);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, msg), auditLog));
        }
    }

    public void validateActorTokenType(String actorTokenType, OAuth2AuditLog auditLog) {
        if (!"urn:x-oath:params:oauth:token-type:device-secret".equalsIgnoreCase(actorTokenType)) {
            String msg = String.format("Unsupported actor_token_type: %s", actorTokenType);
            this.log.trace(msg);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, msg), auditLog));
        }
    }

    public void validateActorToken(String actorToken, OAuth2AuditLog auditLog) {
        if (StringUtils.isBlank((CharSequence)actorToken)) {
            String msg = "actor_token is blank";
            this.log.trace(msg);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, msg), auditLog));
        }
    }

    public void validateSessionForTokenExchange(SessionId session, String actorToken, OAuth2AuditLog auditLog) {
        if (session == null) {
            String msg = String.format("Unable to find session for device_secret (actor_token): %s", actorToken);
            this.log.trace(msg);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, msg), auditLog));
        }
        if (session.getState() != SessionIdState.AUTHENTICATED) {
            String msg = String.format("Session found by device_secret (actor_token) '%s' is not authenticated. SessionId: %s", actorToken, session.getId());
            this.log.trace(msg);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, msg), auditLog));
        }
    }

    public void validateSubjectToken(String deviceSecret, String subjectToken, SessionId sidSession, OAuth2AuditLog auditLog) {
        try {
            Jwt jwt = Jwt.parse((String)subjectToken);
            this.validateSubjectTokenSignature(deviceSecret, sidSession, jwt, auditLog);
        }
        catch (InvalidJwtException e) {
            this.log.error("Unable to parse subject_token as JWT, subjectToken: " + subjectToken, (Throwable)e);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "Unable to parse subject_token as JWT."), auditLog));
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Unable to validate subject_token, subjectToken: " + subjectToken, (Throwable)e);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "Unable to validate subject_token as JWT."), auditLog));
        }
    }

    private void validateSubjectTokenSignature(String deviceSecret, SessionId sidSession, Jwt jwt, OAuth2AuditLog auditLog) throws InvalidJwtException, CryptoProviderException {
        if (!this.cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), jwt.getHeader().getKeyId(), null, null, jwt.getHeader().getSignatureAlgorithm())) {
            this.log.error("subject_token signature verification failed.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "subject_token signature verification failed."), auditLog));
        }
        String sid = jwt.getClaims().getClaimAsString("sid");
        if (StringUtils.isBlank((CharSequence)sid) || !StringUtils.equals((CharSequence)sidSession.getOutsideSid(), (CharSequence)sid)) {
            this.log.error("sid claim from subject_token does not match to session sid.");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "sid claim from subject_token does not match to session sid."), auditLog));
        }
        String dsHash = jwt.getClaims().getClaimAsString("ds_hash");
        if (StringUtils.isBlank((CharSequence)dsHash) || !dsHash.equals(CodeVerifier.s256((String)deviceSecret))) {
            String msg = "ds_hash claim from subject_token does not match to hash of device_secret";
            this.log.error("ds_hash claim from subject_token does not match to hash of device_secret");
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "ds_hash claim from subject_token does not match to hash of device_secret"), auditLog));
        }
    }

    public void validateAudience(String audience, OAuth2AuditLog auditLog) {
        if (StringUtils.isBlank((CharSequence)audience)) {
            String msg = "audience is blank";
            this.log.trace(msg);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, msg), auditLog));
        }
    }
}

