/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.userinfo.ws.rs;

import io.jans.as.common.claims.Audience;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.AttributeService;
import io.jans.as.common.util.CommonUtils;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.common.ScopeType;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.InvalidClaimException;
import io.jans.as.model.exception.InvalidJweException;
import io.jans.as.model.jwe.Jwe;
import io.jans.as.model.jwe.JweEncrypterImpl;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.as.model.jwk.Use;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.jwt.JwtSubClaimObject;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.model.userinfo.UserInfoErrorResponseType;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.authorize.Claim;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.common.AuthorizationGrantType;
import io.jans.as.server.model.common.DefaultScope;
import io.jans.as.server.model.common.UnmodifiableAuthorizationGrant;
import io.jans.as.server.model.userinfo.UserInfoParamsValidator;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.ScopeService;
import io.jans.as.server.service.ServerCryptoProvider;
import io.jans.as.server.service.UserService;
import io.jans.as.server.service.date.DateFormatterService;
import io.jans.as.server.service.external.ExternalDynamicScopeService;
import io.jans.as.server.service.external.context.DynamicScopeExternalContext;
import io.jans.as.server.service.token.TokenService;
import io.jans.as.server.userinfo.ws.rs.UserInfoRestWebService;
import io.jans.as.server.userinfo.ws.rs.UserInfoService;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.JansAttribute;
import io.jans.orm.exception.EntryPersistenceException;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/")
public class UserInfoRestWebServiceImpl
implements UserInfoRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ClientService clientService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private UserService userService;
    @Inject
    private ExternalDynamicScopeService externalDynamicScopeService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private TokenService tokenService;
    @Inject
    private DateFormatterService dateFormatterService;
    @Inject
    private UserInfoService userInfoService;

    @Override
    public Response requestUserInfoGet(String accessToken, String authorization, HttpServletRequest request, SecurityContext securityContext) {
        return this.requestUserInfo(accessToken, authorization, request, securityContext);
    }

    @Override
    public Response requestUserInfoPost(String accessToken, String authorization, HttpServletRequest request, SecurityContext securityContext) {
        return this.requestUserInfo(accessToken, authorization, request, securityContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response requestUserInfo(String accessToken, String authorization, HttpServletRequest request, SecurityContext securityContext) {
        if (this.tokenService.isBearerAuthToken(authorization)) {
            accessToken = this.tokenService.getBearerToken(authorization);
        }
        this.log.debug("Attempting to request User Info, Access token = {}, Is Secure = {}", (Object)accessToken, (Object)securityContext.isSecure());
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.USERINFO);
        Response.ResponseBuilder builder = Response.ok();
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.USER_INFO);
        try {
            if (!UserInfoParamsValidator.validateParams(accessToken)) {
                Response response = this.response(400, UserInfoErrorResponseType.INVALID_REQUEST, "access token is not valid.");
                return response;
            }
            AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
            if (authorizationGrant == null) {
                this.log.trace("Failed to find authorization grant by access_token: {}", (Object)accessToken);
                Response response = this.response(401, UserInfoErrorResponseType.INVALID_TOKEN);
                return response;
            }
            oAuth2AuditLog.updateOAuth2AuditLog(authorizationGrant, false);
            AbstractToken accessTokenObject = authorizationGrant.getAccessToken(accessToken);
            if (accessTokenObject == null || !accessTokenObject.isValid()) {
                this.log.trace("Invalid access token object, access_token: {}, isNull: {}, isValid: {}", new Object[]{accessToken, accessTokenObject == null, false});
                Response response = this.response(401, UserInfoErrorResponseType.INVALID_TOKEN);
                return response;
            }
            if (authorizationGrant.getAuthorizationGrantType() == AuthorizationGrantType.CLIENT_CREDENTIALS) {
                Response response = this.response(403, UserInfoErrorResponseType.INSUFFICIENT_SCOPE, "Grant object has client_credentials grant_type which is not valid.");
                return response;
            }
            if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && !authorizationGrant.getScopes().contains(DefaultScope.OPEN_ID.toString()) && !authorizationGrant.getScopes().contains(DefaultScope.PROFILE.toString())) {
                Response response = this.response(403, UserInfoErrorResponseType.INSUFFICIENT_SCOPE, "Both openid and profile scopes are not present.");
                return response;
            }
            if (!this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && !authorizationGrant.getScopes().contains(DefaultScope.OPEN_ID.toString())) {
                Response response = this.response(403, UserInfoErrorResponseType.INSUFFICIENT_SCOPE, "Missed openid scope.");
                return response;
            }
            oAuth2AuditLog.updateOAuth2AuditLog(authorizationGrant, true);
            builder.cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate());
            builder.header("Pragma", (Object)"no-cache");
            User currentUser = authorizationGrant.getUser();
            try {
                currentUser = this.userService.getUserByDn(authorizationGrant.getUserDn(), new String[0]);
            }
            catch (EntryPersistenceException ex) {
                this.log.warn("Failed to reload user entry: '{}'", (Object)authorizationGrant.getUserDn());
            }
            if (authorizationGrant.getClient() != null && authorizationGrant.getClient().getUserInfoEncryptedResponseAlg() != null && authorizationGrant.getClient().getUserInfoEncryptedResponseEnc() != null) {
                KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getUserInfoEncryptedResponseAlg());
                BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getUserInfoEncryptedResponseEnc());
                builder.type("application/jwt");
                builder.entity((Object)this.getJweResponse(keyEncryptionAlgorithm, blockEncryptionAlgorithm, currentUser, authorizationGrant, authorizationGrant.getScopes()));
            } else if (authorizationGrant.getClient() != null && authorizationGrant.getClient().getUserInfoSignedResponseAlg() != null) {
                SignatureAlgorithm algorithm = SignatureAlgorithm.fromString((String)authorizationGrant.getClient().getUserInfoSignedResponseAlg());
                builder.type("application/jwt");
                builder.entity((Object)this.getJwtResponse(algorithm, currentUser, authorizationGrant, authorizationGrant.getScopes()));
            } else {
                builder.type("application/json;charset=UTF-8");
                builder.entity((Object)this.getJSonResponse(currentUser, authorizationGrant, authorizationGrant.getScopes()));
            }
            Response response = builder.build();
            return response;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            Response response = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).build();
            return response;
        }
        finally {
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        }
    }

    private Response response(int status, UserInfoErrorResponseType errorResponseType) {
        return this.response(status, errorResponseType, "");
    }

    private Response response(int status, UserInfoErrorResponseType errorResponseType, String reason) {
        this.log.error("Status: {}, Reason: {}", (Object)status, (Object)reason);
        return Response.status((int)status).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)errorResponseType, reason)).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate()).build();
    }

    private String getJwtResponse(SignatureAlgorithm signatureAlgorithm, User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws Exception {
        this.log.trace("Building JWT reponse with next scopes {0} for user {1} and user custom attributes {0}", new Object[]{scopes, user.getUserId(), user.getCustomAttributes()});
        Jwt jwt = new Jwt();
        jwt.getHeader().setType(JwtType.JWT);
        jwt.getHeader().setAlgorithm(signatureAlgorithm);
        String keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId((JSONWebKeySet)this.webKeysConfiguration, Algorithm.fromString((String)signatureAlgorithm.getName()), Use.SIGNATURE, KeyOpsType.CONNECT);
        if (keyId != null) {
            jwt.getHeader().setKeyId(keyId);
        }
        jwt.setClaims(this.createJwtClaims(user, authorizationGrant, scopes));
        String sharedSecret = this.clientService.decryptSecret(authorizationGrant.getClient().getClientSecret());
        String signature = this.cryptoProvider.sign(jwt.getSigningInput(), jwt.getHeader().getKeyId(), sharedSecret, signatureAlgorithm);
        jwt.setEncodedSignature(signature);
        return jwt.toString();
    }

    private JwtClaims createJwtClaims(User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws InvalidClaimException {
        String claimsString = this.getJSonResponse(user, authorizationGrant, scopes);
        JwtClaims claims = new JwtClaims(new JSONObject(claimsString));
        claims.setIssuer(this.appConfiguration.getIssuer());
        Audience.setAudience((JwtClaims)claims, (Client)authorizationGrant.getClient());
        return claims;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getJweResponse(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws Exception {
        this.log.trace("Building JWE reponse with next scopes {} for user {} and user custom attributes {}", new Object[]{scopes, user.getUserId(), user.getCustomAttributes()});
        Jwe jwe = new Jwe();
        jwe.getHeader().setType(JwtType.JWT);
        jwe.getHeader().setAlgorithm(keyEncryptionAlgorithm);
        jwe.getHeader().setEncryptionMethod(blockEncryptionAlgorithm);
        jwe.setClaims(this.createJwtClaims(user, authorizationGrant, scopes));
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
            JSONObject jsonWebKeys = CommonUtils.getJwks((Client)authorizationGrant.getClient());
            String keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId(JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys), Algorithm.fromString((String)keyEncryptionAlgorithm.getName()), Use.ENCRYPTION, KeyOpsType.CONNECT);
            PublicKey publicKey = this.cryptoProvider.getPublicKey(keyId, jsonWebKeys, null);
            if (publicKey == null) throw new InvalidJweException("The public key is not valid");
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, publicKey);
            jwe = jweEncrypter.encrypt(jwe);
            return jwe.toString();
        }
        if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A128KW && keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A256KW) return jwe.toString();
        try {
            byte[] sharedSymmetricKey = this.clientService.decryptSecret(authorizationGrant.getClient().getClientSecret()).getBytes(StandardCharsets.UTF_8);
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, sharedSymmetricKey);
            jwe = jweEncrypter.encrypt(jwe);
            return jwe.toString();
        }
        catch (Exception e) {
            throw new InvalidJweException((Throwable)e);
        }
    }

    public String getJSonResponse(User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws InvalidClaimException {
        Object claimsObj;
        this.log.trace("Building JSON reponse with next scopes {} for user {} and user custom attributes {}", new Object[]{scopes, user.getUserId(), user.getCustomAttributes()});
        JsonWebResponse jwr = new JsonWebResponse();
        this.userInfoService.fillJwr(jwr, authorizationGrant);
        ArrayList<Scope> dynamicScopes = new ArrayList<Scope>();
        for (String scopeName : scopes) {
            Scope scope = this.scopeService.getScopeById(scopeName);
            if (scope != null && ScopeType.DYNAMIC == scope.getScopeType()) {
                dynamicScopes.add(scope);
                continue;
            }
            Map<String, Object> claims = this.scopeService.getClaims(user, scope);
            if (claims == null) continue;
            if (scope == null) {
                this.log.trace("Unable to find scope in persistence. Is it removed? Scope name: {}", (Object)scopeName);
            }
            if (scope != null && Boolean.TRUE.equals(scope.isGroupClaims())) {
                JwtSubClaimObject groupClaim = new JwtSubClaimObject();
                groupClaim.setName(scope.getId());
                for (Map.Entry<String, Object> entry : claims.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof List) {
                        groupClaim.setClaim(key, (List)value);
                        continue;
                    }
                    groupClaim.setClaim(key, String.valueOf(value));
                }
                jwr.getClaims().setClaim(scope.getId(), groupClaim);
                continue;
            }
            for (Map.Entry entry : claims.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof List) {
                    jwr.getClaims().setClaim(key, (List)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    jwr.getClaims().setClaim(key, (Boolean)value);
                    continue;
                }
                if (value instanceof Date) {
                    Serializable formattedValue = this.dateFormatterService.formatClaim((Date)value, key);
                    jwr.getClaims().setClaimObject(key, (Object)formattedValue, true);
                    continue;
                }
                jwr.getClaims().setClaim(key, String.valueOf(value));
            }
        }
        if (authorizationGrant.getClaims() != null && (claimsObj = new JSONObject(authorizationGrant.getClaims())).has("userinfo")) {
            JSONObject userInfoObj = claimsObj.getJSONObject("userinfo");
            Iterator it = userInfoObj.keys();
            while (it.hasNext()) {
                String claimName = (String)it.next();
                boolean optional = true;
                JansAttribute jansAttribute = this.attributeService.getByClaimName(claimName);
                if (jansAttribute == null) continue;
                String ldapClaimName = jansAttribute.getName();
                Object attribute = user.getAttribute(ldapClaimName, optional, jansAttribute.getOxMultiValuedAttribute().booleanValue());
                jwr.getClaims().setClaimFromJsonObject(claimName, attribute);
            }
        }
        if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember() != null) {
            for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember().getClaims()) {
                Client client;
                boolean optional = true;
                JansAttribute jansAttribute = this.attributeService.getByClaimName(claim.getName());
                if (jansAttribute == null || !this.validateRequesteClaim(jansAttribute, (client = authorizationGrant.getClient()).getClaims(), scopes)) continue;
                String string = jansAttribute.getName();
                Object attribute = user.getAttribute(string, optional, jansAttribute.getOxMultiValuedAttribute().booleanValue());
                jwr.getClaims().setClaimFromJsonObject(claim.getName(), attribute);
            }
        }
        jwr.getClaims().setSubjectIdentifier(authorizationGrant.getSub());
        if (dynamicScopes.size() > 0 && this.externalDynamicScopeService.isEnabled()) {
            UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(authorizationGrant);
            DynamicScopeExternalContext dynamicScopeContext = new DynamicScopeExternalContext(dynamicScopes, jwr, unmodifiableAuthorizationGrant);
            this.externalDynamicScopeService.executeExternalUpdateMethods(dynamicScopeContext);
        }
        return jwr.toString();
    }

    public boolean validateRequesteClaim(JansAttribute jansAttribute, String[] clientAllowedClaims, Collection<String> scopes) {
        if (jansAttribute == null) {
            this.log.trace("jansAttribute is null.");
            return false;
        }
        if (clientAllowedClaims != null) {
            for (String clientAllowedClaim : clientAllowedClaims) {
                if (!jansAttribute.getDn().equals(clientAllowedClaim)) continue;
                return true;
            }
        }
        for (String scopeName : scopes) {
            Scope scope = this.scopeService.getScopeById(scopeName);
            if (scope == null || scope.getClaims() == null) continue;
            for (String claimDn : scope.getClaims()) {
                if (!jansAttribute.getDisplayName().equals(this.attributeService.getAttributeByDn(claimDn).getDisplayName())) continue;
                return true;
            }
        }
        return false;
    }
}

