/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.util;

import io.jans.as.common.util.RedirectUri;
import io.jans.as.model.common.ResponseMode;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.MalformedURLException;
import java.net.URI;
import org.jboss.resteasy.specimpl.ResponseBuilderImpl;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectUtil {
    private static final Logger log = LoggerFactory.getLogger(RedirectUtil.class);
    public static final String JSON_REDIRECT_PROPNAME = "redirect";
    public static final int HTTP_REDIRECT = 302;

    private RedirectUtil() {
    }

    public static Response.ResponseBuilder getRedirectResponseBuilder(RedirectUri redirectUriResponse, HttpServletRequest httpRequest) {
        ResponseBuilderImpl builder;
        if (httpRequest != null && httpRequest.getHeader("X-Gluu-NoRedirect") != null) {
            try {
                URI redirectURI = URI.create(redirectUriResponse.toString());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(JSON_REDIRECT_PROPNAME, (Object)redirectURI.toURL());
                String jsonResp = jsonObject.toString();
                jsonResp = jsonResp.replace("\\/", "/");
                builder = Response.ok((Object)new GenericEntity((Object)jsonResp, String.class), (MediaType)MediaType.APPLICATION_JSON_TYPE);
            }
            catch (MalformedURLException | JSONException e) {
                builder = Response.serverError();
                log.debug(e.getMessage(), e);
            }
        } else if (redirectUriResponse.getResponseMode() == ResponseMode.FORM_POST || redirectUriResponse.getResponseMode() == ResponseMode.FORM_POST_JWT) {
            builder = new ResponseBuilderImpl();
            builder.status(Response.Status.OK);
            builder.type(MediaType.TEXT_HTML_TYPE);
            builder.cacheControl(CacheControl.valueOf((String)"no-cache, no-store"));
            builder.header("Pragma", (Object)"no-cache");
            builder.entity((Object)redirectUriResponse.toString());
        } else {
            URI redirectURI = URI.create(redirectUriResponse.toString());
            builder = Response.status((int)302);
            builder.location(redirectURI);
        }
        return builder;
    }
}

