/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.test;

import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.Id;
import io.jans.as.model.uma.PermissionTicket;
import io.jans.as.model.uma.RPTResponse;
import io.jans.as.model.uma.RptIntrospectionResponse;
import io.jans.as.model.uma.UmaMetadata;
import io.jans.as.model.uma.UmaNeedInfoResponse;
import io.jans.as.model.uma.UmaResource;
import io.jans.as.model.uma.UmaResourceResponse;
import io.jans.as.model.uma.UmaScopeDescription;
import io.jans.as.model.uma.UmaTokenResponse;
import io.jans.as.model.uma.wrapper.Token;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.testng.Assert;

public class UmaTestUtil {
    private UmaTestUtil() {
    }

    public static void assertIt(UmaScopeDescription scopeDescription) {
        Assert.assertNotNull((Object)scopeDescription, (String)"Scope description is null");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)scopeDescription.getName()), (String)"Scope name is empty");
    }

    public static void assertIt(RptIntrospectionResponse rptStatus) {
        Assert.assertNotNull((Object)rptStatus, (String)"Token response status is null");
        Assert.assertTrue((boolean)rptStatus.getActive(), (String)"Token is not active");
        Assert.assertTrue((rptStatus.getPermissions() != null && !rptStatus.getPermissions().isEmpty() ? 1 : 0) != 0, (String)"Permissions are empty.");
        Assert.assertNotNull((Object)rptStatus.getExpiresAt(), (String)"Expiration date is null");
    }

    public static void assertIt(UmaMetadata metadata) {
        Assert.assertNotNull((Object)metadata, (String)"Metadata is null");
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])metadata.getGrantTypesSupported(), (Object)GrantType.UMA_TICKET.getValue()));
        Assert.assertNotNull((Object)metadata.getIssuer(), (String)"Issuer isn't correct");
        Assert.assertNotNull((Object)metadata.getTokenEndpoint(), (String)"Token endpoint isn't correct");
        Assert.assertNotNull((Object)metadata.getIntrospectionEndpoint(), (String)"Introspection endpoint isn't correct");
        Assert.assertNotNull((Object)metadata.getResourceRegistrationEndpoint(), (String)"Resource registration endpoint isn't correct");
        Assert.assertNotNull((Object)metadata.getPermissionEndpoint(), (String)"Permission registration endpoint isn't correct");
        Assert.assertNotNull((Object)metadata.getAuthorizationEndpoint(), (String)"Authorization request endpoint isn't correct");
    }

    public static void assertIt(Token token) {
        Assert.assertNotNull((Object)token, (String)"The token object is null");
        Assert.assertNotNull((Object)token.getAccessToken(), (String)"The access token is null");
    }

    public static void assertIt(UmaResourceResponse resourceResponse) {
        Assert.assertNotNull((Object)resourceResponse, (String)"Resource status is null");
        Assert.assertNotNull((Object)resourceResponse.getId(), (String)"Resource description id is null");
    }

    public static UmaResource createResource() {
        UmaResource resource = new UmaResource();
        resource.setName("Server Photo Album");
        resource.setIconUri("http://www.example.com/icons/flower.png");
        resource.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
        resource.setType("myType");
        return resource;
    }

    public static void assertIt(PermissionTicket ticket) {
        Assert.assertNotNull((Object)ticket, (String)"Ticket is null");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)ticket.getTicket()), (String)"Ticket is empty");
    }

    public static void assertIt(RPTResponse response) {
        Assert.assertNotNull((Object)response, (String)"RPT response is null");
        Assert.assertNotNull((Object)response.getRpt(), (String)"RPT is null");
    }

    public static void assertIt(ClientResponse response) {
        Assert.assertNotNull((Object)response, (String)"Response is null");
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus(), (String)"Response http code is not OK.");
    }

    public static void assertIt(Id id) {
        Assert.assertNotNull((Object)id, (String)"ID is null");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)id.getId()), (String)"ID is blank");
    }

    public static void assertIt(UmaTokenResponse response) {
        Assert.assertNotNull((Object)response, (String)"UMA Token response is null");
        Assert.assertNotNull((Object)response.getAccessToken(), (String)"RPT is null");
        Assert.assertNotNull((Object)response.getPct(), (String)"PCT is null");
    }

    public static void assertIt(UmaNeedInfoResponse response) {
        Assert.assertNotNull((Object)response, (String)"UMA Need Info response is null");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)response.getError()), (String)"need_info error is blank");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)response.getTicket()), (String)"need_info ticket is blank");
        Assert.assertTrue((response.getRequiredClaims() != null && !response.getRequiredClaims().isEmpty() ? 1 : 0) != 0, (String)"need_info required claims are empty");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)response.getRedirectUser()), (String)"need_info redirect user uri is blank");
    }
}

