/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.exception;

import io.jans.configapi.core.model.ApiError;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.slf4j.Logger;

@Provider
public class GlobalErrorHandler
implements ExceptionMapper<Exception> {
    @Inject
    Logger log;

    public Response toResponse(Exception e) {
        this.log.error(e.getMessage(), (Throwable)e);
        if (e instanceof WebApplicationException && ((WebApplicationException)e).getResponse() != null) {
            return ((WebApplicationException)e).getResponse();
        }
        if (e instanceof ConstraintViolationException && ((ConstraintViolationException)e).getMessage() != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        return Response.serverError().entity((Object)new ApiError.ErrorBuilder().withCode(String.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).withMessage("Internal Server error").andDescription("Internal error occurs, for more details please check log files.").build()).build();
    }
}

