/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.model.configuration;

import jakarta.servlet.ServletException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CorsConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Collection<String> allowedOrigins = new HashSet<String>();
    private final Collection<String> allowedHttpMethods = new HashSet<String>();
    private final Collection<String> allowedHttpHeaders = new HashSet<String>();
    private final Collection<String> exposedHeaders = new HashSet<String>();
    private boolean supportsCredentials;
    private long preflightMaxAge;
    private boolean decorateRequest;
    private boolean enabled;

    public Collection<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(Collection<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public boolean isSupportsCredentials() {
        return this.supportsCredentials;
    }

    public void setSupportsCredentials(boolean supportsCredentials) {
        this.supportsCredentials = supportsCredentials;
    }

    public long getPreflightMaxAge() {
        return this.preflightMaxAge;
    }

    public void setPreflightMaxAge(long preflightMaxAge) {
        this.preflightMaxAge = preflightMaxAge;
    }

    public boolean isDecorateRequest() {
        return this.decorateRequest;
    }

    public void setDecorateRequest(boolean decorateRequest) {
        this.decorateRequest = decorateRequest;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Collection<String> getAllowedHttpMethods() {
        return this.allowedHttpMethods;
    }

    public Collection<String> getAllowedHttpHeaders() {
        return this.allowedHttpHeaders;
    }

    public Collection<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public void parseAndStore(String corsEnabled, String allowedOrigins, String allowedHttpMethods, String allowedHttpHeaders, String exposedHeaders, String supportsCredentials, String preflightMaxAge, String decorateRequest) throws ServletException {
        this.enabled = Boolean.parseBoolean(corsEnabled);
        if (allowedOrigins != null && !allowedOrigins.trim().equals("*")) {
            Set<String> setAllowedOrigins = this.parseStringToSet(allowedOrigins);
            this.allowedOrigins.clear();
            this.allowedOrigins.addAll(setAllowedOrigins);
        }
        if (allowedHttpMethods != null) {
            Set<String> setAllowedHttpMethods = this.parseStringToSet(allowedHttpMethods);
            this.allowedHttpMethods.clear();
            this.allowedHttpMethods.addAll(setAllowedHttpMethods);
        }
        if (allowedHttpHeaders != null) {
            Set<String> setAllowedHttpHeaders = this.parseStringToSet(allowedHttpHeaders);
            HashSet<String> lowerCaseHeaders = new HashSet<String>();
            for (String header : setAllowedHttpHeaders) {
                String lowerCase = header.toLowerCase();
                lowerCaseHeaders.add(lowerCase);
            }
            this.allowedHttpHeaders.clear();
            this.allowedHttpHeaders.addAll(lowerCaseHeaders);
        }
        if (exposedHeaders != null) {
            Set<String> setExposedHeaders = this.parseStringToSet(exposedHeaders);
            this.exposedHeaders.clear();
            this.exposedHeaders.addAll(setExposedHeaders);
        }
        if (supportsCredentials != null) {
            this.supportsCredentials = Boolean.parseBoolean(supportsCredentials);
        }
        if (preflightMaxAge != null) {
            try {
                this.preflightMaxAge = !preflightMaxAge.isEmpty() ? Long.parseLong(preflightMaxAge) : 0L;
            }
            catch (NumberFormatException e) {
                throw new ServletException("corsFilter.invalidPreflightMaxAge", (Throwable)e);
            }
        }
        if (decorateRequest != null) {
            this.decorateRequest = Boolean.parseBoolean(decorateRequest);
        }
    }

    private Set<String> parseStringToSet(String data) {
        String[] splits = data != null && data.length() > 0 ? data.split(",") : new String[]{};
        HashSet<String> set = new HashSet<String>();
        if (splits.length > 0) {
            for (String split : splits) {
                set.add(split.trim());
            }
        }
        return set;
    }

    public boolean isOriginAllowed(String origin) {
        if (this.isAnyOriginAllowed()) {
            return true;
        }
        return this.allowedOrigins.contains(origin);
    }

    public boolean isAnyOriginAllowed() {
        return this.allowedOrigins != null && this.allowedOrigins.size() == 0;
    }

    public String toString() {
        return "CorsConfiguration [enabled=" + this.enabled + " ,allowedOrigins=" + this.allowedOrigins + ", allowedHttpMethods=" + this.allowedHttpMethods + ", allowedHttpHeaders=" + this.allowedHttpHeaders + ", exposedHeaders=" + this.exposedHeaders + ", supportsCredentials=" + this.supportsCredentials + ", preflightMaxAge=" + this.preflightMaxAge + ", decorateRequest=" + this.decorateRequest + "]";
    }
}

