/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.model.configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.jans.as.model.configuration.Configuration;
import io.jans.configapi.model.configuration.AgamaConfiguration;
import io.jans.configapi.model.configuration.AssetMgtConfiguration;
import io.jans.configapi.model.configuration.AuditLogConf;
import io.jans.configapi.model.configuration.CorsConfigurationFilter;
import io.jans.configapi.model.configuration.DataFormatConversionConf;
import io.jans.configapi.model.configuration.PluginConf;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiAppConfiguration
implements Configuration {
    @Schema(description="Config API service name.")
    private String serviceName;
    @Schema(description="OAuth authentication enable/disable flag. Default value `true`.")
    private boolean configOauthEnabled;
    @Schema(description="Flag to enable/disable timer to dynamically reflect log configuration changes. Default value `true`Default value `false`.")
    private boolean disableLoggerTimer;
    @Schema(description="Flag to enable/disable request audit. Default value `false`.")
    private boolean disableAuditLogger;
    @Schema(description="Flag to enable/disable check if custom attribue is declared in schema. Default value `true`.")
    private boolean customAttributeValidationEnabled;
    @Schema(description="Flag to enable/disable check if acr customScript is enabled. Default value `true`.")
    private boolean acrValidationEnabled;
    @Schema(description="Flag to enable/disable sending clientSecret in response. Default value `true`.")
    private boolean returnClientSecretInResponse;
    @Schema(description="Flag to enable/disable sending encrypted clientSecret in response. Default value `true`.")
    private boolean returnEncryptedClientSecretInResponse;
    @Schema(description="List of approved external Auth server to validate token.")
    private List<String> apiApprovedIssuer;
    @Schema(description="Name of supported API protection mechansim. Supported type is `OAuth2`.")
    private String apiProtectionType;
    @Schema(description="Config-API client ID.")
    private String apiClientId;
    @Schema(description="Config-API client password.")
    private String apiClientPassword;
    private boolean endpointInjectionEnabled;
    @Schema(description="Issuer Identifier of Jans OpenID Connect Provider.")
    private String authIssuerUrl;
    @Schema(description="Jans OpenID Connect Provider Well-Known Configuration URL.")
    private String authOpenidConfigurationUrl;
    @Schema(description="Jans URL of the OpenID Connect Provider's OAuth 2.0 Authorization Endpoint.")
    private String authOpenidIntrospectionUrl;
    @Schema(description="Jans URL of the OpenID Connect Provider's OAuth 2.0 Token Endpoint.")
    private String authOpenidTokenUrl;
    @Schema(description="Jans URL of the OpenID Connect Provider's OAuth 2.0 Revoke Token Endpoint.")
    private String authOpenidRevokeUrl;
    @Schema(description="List of oAuth scope that can be validity for an access tokens only by underlying Jans Auth server.")
    private List<String> exclusiveAuthScopes;
    @Schema(description="CORS configuration filter properties.")
    private List<CorsConfigurationFilter> corsConfigurationFilters;
    @Schema(description="Specify logging level of Loggers. Default level is `INFO`.")
    private String loggingLevel;
    @Schema(description="Log4j logging layout. Default value `TEXT`.")
    private String loggingLayout;
    @Schema(description="The path to the external log4j2 logging configuration.")
    private String externalLoggerConfiguration;
    @Schema(description="Choose whether to disable JDK loggers.")
    private Boolean disableJdkLogger = true;
    private Boolean disableExternalLoggerConfiguration = true;
    @Schema(description="Maximum number of results per page in search endpoints.")
    private int maxCount;
    @Schema(description="List of ACR values that should be excluded from active validation check.")
    private List<String> acrExclusionList;
    @Schema(description="User attribute that should not be returned in response.")
    private List<String> userExclusionAttributes;
    @Schema(description="List of User mandatory attribute for user creation request.")
    private List<String> userMandatoryAttributes;
    @Schema(description="Agama configuration details.")
    private AgamaConfiguration agamaConfiguration;
    @Schema(description="Audit Log configuration details.")
    private AuditLogConf auditLogConf;
    @Schema(description="Configuration for data-type converstion.")
    private DataFormatConversionConf dataFormatConversionConf;
    @Schema(description="Details of enabled plugins.")
    private List<PluginConf> plugins;
    @Schema(description="Asset management configuration details.")
    private AssetMgtConfiguration assetMgtConfiguration;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isConfigOauthEnabled() {
        return this.configOauthEnabled;
    }

    public void setConfigOauthEnabled(boolean configOauthEnabled) {
        this.configOauthEnabled = configOauthEnabled;
    }

    public boolean isDisableLoggerTimer() {
        return this.disableLoggerTimer;
    }

    public void setDisableLoggerTimer(boolean disableLoggerTimer) {
        this.disableLoggerTimer = disableLoggerTimer;
    }

    public boolean isDisableAuditLogger() {
        return this.disableAuditLogger;
    }

    public void setDisableAuditLogger(boolean disableAuditLogger) {
        this.disableAuditLogger = disableAuditLogger;
    }

    public boolean isCustomAttributeValidationEnabled() {
        return this.customAttributeValidationEnabled;
    }

    public void setCustomAttributeValidationEnabled(boolean customAttributeValidationEnabled) {
        this.customAttributeValidationEnabled = customAttributeValidationEnabled;
    }

    public boolean isAcrValidationEnabled() {
        return this.acrValidationEnabled;
    }

    public void setAcrValidationEnabled(boolean acrValidationEnabled) {
        this.acrValidationEnabled = acrValidationEnabled;
    }

    public boolean isReturnClientSecretInResponse() {
        return this.returnClientSecretInResponse;
    }

    public void setReturnClientSecretInResponse(boolean returnClientSecretInResponse) {
        this.returnClientSecretInResponse = returnClientSecretInResponse;
    }

    public boolean isReturnEncryptedClientSecretInResponse() {
        return this.returnEncryptedClientSecretInResponse;
    }

    public void setReturnEncryptedClientSecretInResponse(boolean returnEncryptedClientSecretInResponse) {
        this.returnEncryptedClientSecretInResponse = returnEncryptedClientSecretInResponse;
    }

    public List<String> getApiApprovedIssuer() {
        return this.apiApprovedIssuer;
    }

    public void setApiApprovedIssuer(List<String> apiApprovedIssuer) {
        this.apiApprovedIssuer = apiApprovedIssuer;
    }

    public String getApiProtectionType() {
        return this.apiProtectionType;
    }

    public void setApiProtectionType(String apiProtectionType) {
        this.apiProtectionType = apiProtectionType;
    }

    public String getApiClientId() {
        return this.apiClientId;
    }

    public void setApiClientId(String apiClientId) {
        this.apiClientId = apiClientId;
    }

    public String getApiClientPassword() {
        return this.apiClientPassword;
    }

    public void setApiClientPassword(String apiClientPassword) {
        this.apiClientPassword = apiClientPassword;
    }

    public boolean isEndpointInjectionEnabled() {
        return this.endpointInjectionEnabled;
    }

    public void setEndpointInjectionEnabled(boolean endpointInjectionEnabled) {
        this.endpointInjectionEnabled = endpointInjectionEnabled;
    }

    public String getAuthIssuerUrl() {
        return this.authIssuerUrl;
    }

    public void setAuthIssuerUrl(String authIssuerUrl) {
        this.authIssuerUrl = authIssuerUrl;
    }

    public String getAuthOpenidConfigurationUrl() {
        return this.authOpenidConfigurationUrl;
    }

    public void setAuthOpenidConfigurationUrl(String authOpenidConfigurationUrl) {
        this.authOpenidConfigurationUrl = authOpenidConfigurationUrl;
    }

    public String getAuthOpenidIntrospectionUrl() {
        return this.authOpenidIntrospectionUrl;
    }

    public void setAuthOpenidIntrospectionUrl(String authOpenidIntrospectionUrl) {
        this.authOpenidIntrospectionUrl = authOpenidIntrospectionUrl;
    }

    public String getAuthOpenidTokenUrl() {
        return this.authOpenidTokenUrl;
    }

    public void setAuthOpenidTokenUrl(String authOpenidTokenUrl) {
        this.authOpenidTokenUrl = authOpenidTokenUrl;
    }

    public String getAuthOpenidRevokeUrl() {
        return this.authOpenidRevokeUrl;
    }

    public void setAuthOpenidRevokeUrl(String authOpenidRevokeUrl) {
        this.authOpenidRevokeUrl = authOpenidRevokeUrl;
    }

    public List<String> getExclusiveAuthScopes() {
        return this.exclusiveAuthScopes;
    }

    public void setExclusiveAuthScopes(List<String> exclusiveAuthScopes) {
        this.exclusiveAuthScopes = exclusiveAuthScopes;
    }

    public List<CorsConfigurationFilter> getCorsConfigurationFilters() {
        return this.corsConfigurationFilters;
    }

    public void setCorsConfigurationFilters(List<CorsConfigurationFilter> corsConfigurationFilters) {
        this.corsConfigurationFilters = corsConfigurationFilters;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public String getLoggingLayout() {
        return this.loggingLayout;
    }

    public void setLoggingLayout(String loggingLayout) {
        this.loggingLayout = loggingLayout;
    }

    public String getExternalLoggerConfiguration() {
        return this.externalLoggerConfiguration;
    }

    public void setExternalLoggerConfiguration(String externalLoggerConfiguration) {
        this.externalLoggerConfiguration = externalLoggerConfiguration;
    }

    public Boolean getDisableJdkLogger() {
        return this.disableJdkLogger;
    }

    public void setDisableJdkLogger(Boolean disableJdkLogger) {
        this.disableJdkLogger = disableJdkLogger;
    }

    public Boolean getDisableExternalLoggerConfiguration() {
        return this.disableExternalLoggerConfiguration;
    }

    public void setDisableExternalLoggerConfiguration(Boolean disableExternalLoggerConfiguration) {
        this.disableExternalLoggerConfiguration = disableExternalLoggerConfiguration;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
        if (this.maxCount <= 0) {
            this.maxCount = 200;
        }
    }

    public List<String> getAcrExclusionList() {
        return this.acrExclusionList;
    }

    public void setAcrExclusionList(List<String> acrExclusionList) {
        this.acrExclusionList = acrExclusionList;
    }

    public List<String> getUserExclusionAttributes() {
        return this.userExclusionAttributes;
    }

    public void setUserExclusionAttributes(List<String> userExclusionAttributes) {
        this.userExclusionAttributes = userExclusionAttributes;
    }

    public List<String> getUserMandatoryAttributes() {
        return this.userMandatoryAttributes;
    }

    public void setUserMandatoryAttributes(List<String> userMandatoryAttributes) {
        this.userMandatoryAttributes = userMandatoryAttributes;
    }

    public AgamaConfiguration getAgamaConfiguration() {
        return this.agamaConfiguration;
    }

    public void setAgamaConfiguration(AgamaConfiguration agamaConfiguration) {
        this.agamaConfiguration = agamaConfiguration;
    }

    public AuditLogConf getAuditLogConf() {
        return this.auditLogConf;
    }

    public void setAuditLogConf(AuditLogConf auditLogConf) {
        this.auditLogConf = auditLogConf;
    }

    public DataFormatConversionConf getDataFormatConversionConf() {
        return this.dataFormatConversionConf;
    }

    public void setDataFormatConversionConf(DataFormatConversionConf dataFormatConversionConf) {
        this.dataFormatConversionConf = dataFormatConversionConf;
    }

    public List<PluginConf> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<PluginConf> plugins) {
        this.plugins = plugins;
    }

    public AssetMgtConfiguration getAssetMgtConfiguration() {
        return this.assetMgtConfiguration;
    }

    public void setAssetMgtConfiguration(AssetMgtConfiguration assetMgtConfiguration) {
        this.assetMgtConfiguration = assetMgtConfiguration;
    }

    public String toString() {
        return "ApiAppConfiguration [serviceName=" + this.serviceName + ", configOauthEnabled=" + this.configOauthEnabled + ", disableLoggerTimer=" + this.disableLoggerTimer + ", disableAuditLogger=" + this.disableAuditLogger + ", customAttributeValidationEnabled=" + this.customAttributeValidationEnabled + ", acrValidationEnabled=" + this.acrValidationEnabled + ", returnClientSecretInResponse=" + this.returnClientSecretInResponse + ", returnEncryptedClientSecretInResponse=" + this.returnEncryptedClientSecretInResponse + ", apiApprovedIssuer=" + this.apiApprovedIssuer + ", apiProtectionType=" + this.apiProtectionType + ", apiClientId=" + this.apiClientId + ", endpointInjectionEnabled=" + this.endpointInjectionEnabled + ", authIssuerUrl=" + this.authIssuerUrl + ", authOpenidConfigurationUrl=" + this.authOpenidConfigurationUrl + ", authOpenidIntrospectionUrl=" + this.authOpenidIntrospectionUrl + ", authOpenidTokenUrl=" + this.authOpenidTokenUrl + ", authOpenidRevokeUrl=" + this.authOpenidRevokeUrl + ", exclusiveAuthScopes=" + this.exclusiveAuthScopes + ", corsConfigurationFilters=" + this.corsConfigurationFilters + ", loggingLevel=" + this.loggingLevel + ", loggingLayout=" + this.loggingLayout + ", externalLoggerConfiguration=" + this.externalLoggerConfiguration + ", disableJdkLogger=" + this.disableJdkLogger + ", maxCount=" + this.maxCount + ", acrExclusionList=" + this.acrExclusionList + ", userExclusionAttributes=" + this.userExclusionAttributes + ", userMandatoryAttributes=" + this.userMandatoryAttributes + ", agamaConfiguration=" + this.agamaConfiguration + ", auditLogConf=" + this.auditLogConf + ", dataFormatConversionConf=" + this.dataFormatConversionConf + ", plugins=" + this.plugins + ", assetMgtConfiguration=" + this.assetMgtConfiguration + "]";
    }
}

