/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.external.service;

import io.jans.configapi.external.context.ConfigAuthContext;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.configapi.ConfigApiType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class ExternalConfigService
extends ExternalScriptService {
    private static final long serialVersionUID = 1767751544454591666L;
    @Inject
    transient Logger logger;

    public ExternalConfigService() {
        super(CustomScriptType.CONFIG_API);
    }

    private void logAndSave(CustomScriptConfiguration customScriptConfiguration, Exception ex) {
        this.logger.error(ex.getMessage(), (Throwable)ex);
        this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
    }

    public boolean checkAuthorization(HttpServletRequest request, HttpServletResponse response, ApiAppConfiguration apiAppConfiguration, Map<String, Object> requestParameters, JSONObject responseAsJsonObject) {
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (this.executeAuthorizeMethod(request, response, apiAppConfiguration, requestParameters, responseAsJsonObject, customScriptConfiguration)) continue;
            return false;
        }
        return true;
    }

    private boolean executeAuthorizeMethod(HttpServletRequest request, HttpServletResponse response, ApiAppConfiguration apiAppConfiguration, Map<String, Object> requestParameters, JSONObject responseAsJsonObject, CustomScriptConfiguration customScriptConfiguration) {
        boolean isAuthorized = false;
        this.logger.debug("External Config Authorization script params -  request:{}, response:{}, apiAppConfiguration:{}, requestParameters:{}, responseAsJsonObject:{}, this.customScriptConfigurations:{} ", new Object[]{request, response, apiAppConfiguration, requestParameters, responseAsJsonObject, this.customScriptConfigurations});
        try {
            ConfigApiType externalType = (ConfigApiType)customScriptConfiguration.getExternalType();
            ConfigAuthContext context = new ConfigAuthContext(request, response, apiAppConfiguration, requestParameters, customScriptConfiguration);
            return externalType.authorize((Object)responseAsJsonObject, (Object)context);
        }
        catch (Exception ex) {
            this.logAndSave(customScriptConfiguration, ex);
            return isAuthorized;
        }
    }
}

