/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.filters;

import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.model.configuration.CorsConfigurationFilter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsFilterConfig
implements FilterConfig {
    private static Logger log = LoggerFactory.getLogger(CorsFilterConfig.class);
    private String filterName;
    private Map<String, String> initParameters;
    public static final String PARAM_CORS_ENABLED = "cors.enabled";
    public static final String PARAM_CORS_ALLOWED_ORIGINS = "cors.allowed.origins";
    public static final String PARAM_CORS_ALLOWED_METHODS = "cors.allowed.methods";
    public static final String PARAM_CORS_ALLOWED_HEADERS = "cors.allowed.headers";
    public static final String PARAM_CORS_EXPOSED_HEADERS = "cors.exposed.headers";
    public static final String PARAM_CORS_SUPPORT_CREDENTIALS = "cors.support.credentials";
    public static final String PARAM_CORS_LOGGING_ENABLED = "cors.logging.enabled";
    public static final String PARAM_CORS_PREFLIGHT_MAXAGE = "cors.preflight.maxage";
    public static final String PARAM_CORS_REQUEST_DECORATE = "cors.request.decorate";

    public CorsFilterConfig(String filterName, ApiAppConfiguration appConfiguration) {
        this.filterName = filterName;
        this.initParameters = new HashMap<String, String>();
        List corsConfigurationFilters = appConfiguration.getCorsConfigurationFilters();
        log.debug(" CorsFilterConfig::CorsFilterConfig() -  filterName:{} , corsConfigurationFilters:{} ", (Object)filterName, (Object)corsConfigurationFilters);
        for (CorsConfigurationFilter corsConfigurationFilter : corsConfigurationFilters) {
            log.debug("  CorsFilterConfig::CorsFilterConfig() corsConfigurationFilter.getFilterName():{}", (Object)corsConfigurationFilter.getFilterName());
            if (!filterName.equals(corsConfigurationFilter.getFilterName())) continue;
            this.initParameters.put(PARAM_CORS_ENABLED, corsConfigurationFilter.getCorsEnabled().toString());
            this.initParameters.put(PARAM_CORS_ALLOWED_ORIGINS, corsConfigurationFilter.getCorsAllowedOrigins());
            this.initParameters.put(PARAM_CORS_ALLOWED_METHODS, corsConfigurationFilter.getCorsAllowedMethods());
            this.initParameters.put(PARAM_CORS_ALLOWED_HEADERS, corsConfigurationFilter.getCorsAllowedHeaders());
            this.initParameters.put(PARAM_CORS_EXPOSED_HEADERS, corsConfigurationFilter.getCorsExposedHeaders());
            this.initParameters.put(PARAM_CORS_SUPPORT_CREDENTIALS, corsConfigurationFilter.getCorsSupportCredentials().toString());
            this.initParameters.put(PARAM_CORS_LOGGING_ENABLED, corsConfigurationFilter.getCorsLoggingEnabled().toString());
            this.initParameters.put(PARAM_CORS_PREFLIGHT_MAXAGE, corsConfigurationFilter.getCorsPreflightMaxAge().toString());
            this.initParameters.put(PARAM_CORS_REQUEST_DECORATE, corsConfigurationFilter.getCorsRequestDecorate().toString());
        }
    }

    public String getFilterName() {
        return this.filterName;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public String getInitParameter(String name) {
        if (this.initParameters == null) {
            return null;
        }
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }
}

