/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.as.model.util.Util;
import io.jans.configapi.core.model.ApiError;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.model.configuration.AssetDirMapping;
import io.jans.configapi.rest.form.AssetForm;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.AssetService;
import io.jans.model.JansAttribute;
import io.jans.model.SearchRequest;
import io.jans.orm.model.PagedResult;
import io.jans.service.document.store.model.Document;
import io.jans.util.exception.InvalidAttributeException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.slf4j.Logger;

@Path(value="/jans-assets")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AssetResource
extends ConfigBaseResource {
    private static final String APPLICATION_ERROR = "APPLICATION_ERROR";
    private static final String NOT_FOUND_ERROR = "NOT_FOUND_ERROR";
    private static final String ASSET_DATA = "Asset Data";
    private static final String ASSET_DATA_FORM = "Asset Data From";
    private static final String ASSET_NAME_CONFLICT = "NAME_CONFLICT";
    private static final String ASSET_NAME_CONFLICT_MSG = "Asset with same name %s already exist!";
    private static final String ASSET_NOT_FOUND = "Asset identified by %s not found!";
    private static final String ASSET_INUM = "Asset Identifier Inum";
    private static final String RESOURCE_NULL = "RESOURCE_NULL";
    private static final String RESOURCE_NULL_MSG = "%s is null";
    @Inject
    Logger log;
    @Inject
    AssetService assetService;

    @Operation(summary="Gets all Jans assets.", description="Gets all Jans assets.", operationId="get-all-assets", tags={"Jans Assets"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans_asset-read"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=DocumentPagedResult.class), examples={@ExampleObject(name="Response example", value="example/assets/get-all-asset.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans_asset-read"}, groupScopes={"https://jans.io/oauth/config/jans_asset-write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getAssets(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="Status of the attribute") @DefaultValue(value="all") @QueryParam(value="status") String status, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="inum") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="adminCanEdit=true,dataType=string")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Search Asset filters with limit:{}, pattern:{}, status:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)status), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.assetService.getDnForAsset(null), pattern, sortBy, sortOrder, startIndex, limit, null, null, this.getMaxCount(), fieldValuePair, JansAttribute.class);
        return Response.ok((Object)((Object)this.doSearch(searchReq, status))).build();
    }

    @Operation(summary="Gets an asset by inum - unique identifier", description="Gets an asset by inum - unique identifier", operationId="get-asset-by-inum", tags={"Jans Assets"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans_asset-read"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=PagedResult.class), examples={@ExampleObject(name="Response example", value="example/assets/get-asset-by-inum.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans_asset-read"}, groupScopes={"https://jans.io/oauth/config/jans_asset-write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="{inum}")
    public Response getAssetByInum(@Parameter(description="Asset Inum") @PathParam(value="inum") @NotNull String inum) throws Exception {
        Document asset;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Search Asset with inum:{}", (Object)Util.escapeLog((Object)inum));
        }
        if ((asset = this.assetService.getAssetByInum(inum)) == null) {
            this.log.error("No asset found with the inum:{}", (Object)inum);
            AssetResource.throwNotFoundException((String)NOT_FOUND_ERROR, (String)String.format(ASSET_NOT_FOUND, inum));
        }
        this.logger.info("Asset fetched based on inum:{} is:{}", (Object)inum, (Object)asset);
        return Response.ok((Object)asset).build();
    }

    @Operation(summary="Fetch asset by name", description="Fetch asset by name.", operationId="get-asset-by-name", tags={"Jans Assets"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans_asset-read"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=DocumentPagedResult.class), examples={@ExampleObject(name="Response example", value="example/assets/get-asset-by-name.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans_asset-read"}, groupScopes={"https://jans.io/oauth/config/jans_asset-write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="name/{name}")
    public Response getAssetByName(@Parameter(description="Asset Name") @PathParam(value="name") @NotNull String name) throws Exception {
        SearchRequest searchReq;
        DocumentPagedResult documentPagedResult;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Search Asset with name:{}", (Object)Util.escapeLog((Object)name));
        }
        if ((documentPagedResult = this.searchByName(searchReq = this.createSearchRequest(this.assetService.getDnForAsset(null), name, "inum", "ascending", Integer.parseInt("0"), Integer.parseInt("50"), null, null, this.getMaxCount(), null, JansAttribute.class))) == null || documentPagedResult.getEntriesCount() <= 0) {
            this.log.error("No asset found with the name:{}", (Object)name);
            AssetResource.throwNotFoundException((String)NOT_FOUND_ERROR, (String)String.format(ASSET_NOT_FOUND, name));
        }
        this.logger.info("Asset fetched based on name are:{}", (Object)documentPagedResult);
        return Response.ok((Object)((Object)documentPagedResult)).build();
    }

    @Operation(summary="Gets asset services", description="Gets asset services", operationId="get-asset-services", tags={"Jans Assets"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans_asset-read"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class, type="enum")))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans_asset-read"}, groupScopes={"https://jans.io/oauth/config/jans_asset-write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/services")
    public Response getJansServices() {
        List<String> services = this.assetService.getValidModuleName();
        if (services == null) {
            services = Collections.emptyList();
        }
        this.logger.info("Asset fetched based on services:{}", services);
        return Response.ok(services).build();
    }

    @Operation(summary="Get valid asset types", description="Get valid asset types", operationId="get-asset-types", tags={"Jans Assets"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans_asset-read"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class, type="enum")))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans_asset-read"}, groupScopes={"https://jans.io/oauth/config/jans_asset-write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/asset-type")
    public Response getValidAssetTypes() {
        List<String> validTypes = this.assetService.getValidFileExtension();
        this.logger.info("validTypes:{}", validTypes);
        return Response.ok(validTypes).build();
    }

    @Operation(summary="Get valid asset types", description="Get valid asset types", operationId="get-asset-dir-mapping", tags={"Jans Assets"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans_asset-read"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AssetDirMapping.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans_asset-read"}, groupScopes={"https://jans.io/oauth/config/jans_asset-write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/asset-dir-mapping")
    public Response getAssetDirMapping() {
        List<AssetDirMapping> assetDirMappingList = this.assetService.getAssetDirMapping();
        this.logger.info("validTypes:{}", assetDirMappingList);
        return Response.ok(assetDirMappingList).build();
    }

    @Operation(summary="Upload new asset", description="Upload new asset", operationId="post-new-asset", tags={"Jans Assets"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans_asset-write"})})
    @RequestBody(description="String multipart form.", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=AssetForm.class), examples={@ExampleObject(name="Response json example", value="example/assets/post-asset.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Newly created Asset", content={@Content(mediaType="application/json-patch+json", schema=@Schema(implementation=Document.class), examples={@ExampleObject(name="Response json example", value="example/assets/post-asset.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @Consumes(value={"multipart/form-data"})
    @POST
    @Path(value="/upload")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans_asset-write"})
    public Response uploadAsset(@MultipartForm AssetForm assetForm) throws Exception {
        InputStream assetStream;
        if (this.log.isInfoEnabled()) {
            this.log.info("Create Asset details assetForm:{}", (Object)assetForm);
        }
        AssetResource.checkResourceNotNull((Object)assetForm, (String)ASSET_DATA_FORM);
        Document asset = assetForm.getDocument();
        this.log.info(" Create asset:{} ", (Object)asset);
        AssetResource.checkResourceNotNull((Object)asset, (String)ASSET_DATA);
        AssetResource.checkNotNull((String)asset.getFileName(), (String)"fileName");
        List<Document> assets = this.assetService.getAssetByName(asset.getFileName());
        if (assets != null && !assets.isEmpty()) {
            asset.setInum(assets.get(0).getInum());
            asset.setBaseDn(assets.get(0).getBaseDn());
        }
        if ((assetStream = assetForm.getAssetFile()) == null || assetStream.available() <= 0) {
            this.log.error("No asset file provided");
            AssetResource.throwBadRequestException((String)RESOURCE_NULL, (String)String.format(RESOURCE_NULL_MSG, "Asset File"));
        }
        try {
            asset = this.assetService.saveAsset(asset, assetStream, false);
            this.log.debug("Saved asset:{} ", (Object)asset);
        }
        catch (Exception ex) {
            this.log.error("Application Error while creating asset is - {}", (Object)ex.getMessage());
            AssetResource.throwInternalServerException((String)APPLICATION_ERROR, (Throwable)ex);
        }
        this.log.info("Create IdentityProvider - asset:{}", (Object)asset);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)asset).build();
    }

    @Operation(summary="Update existing asset", description="Update existing asset", operationId="put-asset", tags={"Jans Assets"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans_asset-write"})})
    @RequestBody(description="String multipart form.", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=AssetForm.class), examples={@ExampleObject(name="Response json example", value="example/assets/put-asset.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Modified Asset", content={@Content(mediaType="application/json-patch+json", schema=@Schema(implementation=Document.class), examples={@ExampleObject(name="Response json example", value="example/assets/put-asset.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="Unauthorized"))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @Consumes(value={"multipart/form-data"})
    @PUT
    @Path(value="/upload")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans_asset-write"})
    public Response updateAsset(@MultipartForm AssetForm assetForm) throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("Update Asset details assetForm:{}", (Object)assetForm);
        }
        AssetResource.checkResourceNotNull((Object)assetForm, (String)ASSET_DATA_FORM);
        Document asset = assetForm.getDocument();
        String inum = asset.getInum();
        this.log.debug(" Create asset:{} ", (Object)asset);
        AssetResource.checkResourceNotNull((Object)asset, (String)ASSET_DATA);
        AssetResource.checkResourceNotNull((Object)inum, (String)ASSET_INUM);
        AssetResource.checkNotNull((String)asset.getFileName(), (String)"fileName");
        Document existingDoc = this.assetService.getAssetByInum(asset.getInum());
        if (existingDoc == null) {
            throw new InvalidAttributeException("Asset with inum '" + asset.getInum() + "' does not exist!!!");
        }
        List<Document> assets = this.assetService.getAssetByName(asset.getFileName());
        this.log.info("Check if asset with inum different then:{} but with same name exist - asset.getDisplayName():{}, assets:{}", new Object[]{inum, asset.getFileName(), assets});
        if (assets != null && !assets.isEmpty()) {
            List list = assets.stream().filter(e -> !e.getInum().equalsIgnoreCase(inum)).collect(Collectors.toList());
            this.logger.info("Other asset with same name:{} are list:{}", (Object)asset.getFileName(), list);
            if (list != null && !list.isEmpty()) {
                this.log.error("Another asset with same name:{}", (Object)asset.getFileName());
                AssetResource.throwBadRequestException((String)ASSET_NAME_CONFLICT, (String)String.format(ASSET_NAME_CONFLICT_MSG, asset.getFileName()));
            }
        }
        InputStream assetFile = assetForm.getAssetFile();
        this.log.debug(" Update asset assetFile:{} ", (Object)assetFile);
        try {
            asset = this.assetService.saveAsset(asset, assetFile, true);
            this.log.debug(" Updated asset:{} ", (Object)asset);
        }
        catch (Exception ex) {
            this.log.error("Application Error while updated asset is:{}", (Object)ex.getMessage());
            AssetResource.throwInternalServerException((String)APPLICATION_ERROR, (Throwable)ex);
        }
        this.log.info("Updated asset:{}", (Object)asset);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)asset).build();
    }

    @Operation(summary="Load assets on server for a service", description="Load assets on server for a service", operationId="load-service-asset", tags={"Jans Assets"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans_asset-write"})})
    @RequestBody(description="String multipart form.", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=String.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Asset file loaded", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class), examples={@ExampleObject(name="Response json example", value="example/assets/load-service-assets.json")})}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @Consumes(value={"multipart/form-data"})
    @POST
    @Path(value="/service/{service-name}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans_asset-write"})
    public Response loadServiceAsset(@Parameter(description="Service Name") @PathParam(value="service-name") @NotNull String serviceName) throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("Create Asset details serviceName:{}", (Object)serviceName);
        }
        AssetResource.checkResourceNotNull((Object)serviceName, (String)"Service Name");
        String result = null;
        try {
            result = this.assetService.loadServiceAsset(serviceName);
        }
        catch (Exception ex) {
            this.log.error("Application Error while loading asset is - {}", (Object)ex.getMessage());
            AssetResource.throwInternalServerException((String)APPLICATION_ERROR, (Throwable)ex);
        }
        this.log.debug("Load asset for:{}, result is:{} ", (Object)serviceName, (Object)result);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @Operation(summary="Delete an asset", description="Delete an asset", operationId="delete-asset", tags={"Jans Assets"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jans_asset-delete"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="NotFoundException"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @DELETE
    @Path(value="{inum}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jans_asset-delete"})
    public Response deleteAsset(@Parameter(description="Asset identifier") @PathParam(value="inum") @NotNull String inum) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Delete an Asset identified inum:{}", (Object)inum);
        }
        try {
            boolean status = this.assetService.removeAsset(inum);
            this.log.debug(" Delete asset status:{} ", (Object)status);
        }
        catch (Exception ex) {
            this.log.error("Error while asset deletion is:{}", (Object)ex.getMessage());
            if (ex instanceof NotFoundException) {
                AssetResource.throwNotFoundException((String)NOT_FOUND_ERROR, (String)ex.getMessage());
            }
            AssetResource.throwInternalServerException((String)APPLICATION_ERROR, (Throwable)ex);
        }
        return Response.noContent().build();
    }

    private DocumentPagedResult doSearch(SearchRequest searchReq, String status) throws Exception {
        this.logger.debug("Asset search params - searchReq:{} , status:{} ", (Object)searchReq, (Object)status);
        DocumentPagedResult documentPagedResult = null;
        PagedResult<Document> pagedResult = this.assetService.searchAsset(searchReq, status);
        this.logger.debug("PagedResult  - pagedResult:{}", pagedResult);
        if (pagedResult != null) {
            this.logger.debug("Asset fetched  - pagedResult.getTotalEntriesCount():{}, pagedResult.getEntriesCount():{}, pagedResult.getEntries():{}", new Object[]{pagedResult.getTotalEntriesCount(), pagedResult.getEntriesCount(), pagedResult.getEntries()});
            documentPagedResult = this.getDocumentPagedResult(pagedResult);
        }
        this.logger.debug("Asset documentPagedResult:{} ", documentPagedResult);
        return documentPagedResult;
    }

    private DocumentPagedResult searchByName(SearchRequest searchReq) throws Exception {
        this.logger.debug("Search asset by name params - searchReq:{} ", (Object)searchReq);
        DocumentPagedResult documentPagedResult = null;
        PagedResult<Document> pagedResult = this.assetService.searchAssetByName(searchReq);
        this.logger.debug("PagedResult  - pagedResult:{}", pagedResult);
        if (pagedResult != null) {
            this.logger.debug("Asset fetched  - pagedResult.getTotalEntriesCount():{}, pagedResult.getEntriesCount():{}, pagedResult.getEntries():{}", new Object[]{pagedResult.getTotalEntriesCount(), pagedResult.getEntriesCount(), pagedResult.getEntries()});
            documentPagedResult = this.getDocumentPagedResult(pagedResult);
        }
        this.logger.debug("Asset documentPagedResult:{} ", documentPagedResult);
        return documentPagedResult;
    }

    private DocumentPagedResult getDocumentPagedResult(PagedResult<Document> pagedResult) {
        DocumentPagedResult documentPagedResult = null;
        if (pagedResult != null) {
            List identityProviderList = pagedResult.getEntries();
            documentPagedResult = new DocumentPagedResult();
            documentPagedResult.setStart(pagedResult.getStart());
            documentPagedResult.setEntriesCount(pagedResult.getEntriesCount());
            documentPagedResult.setTotalEntriesCount(pagedResult.getTotalEntriesCount());
            documentPagedResult.setEntries(identityProviderList);
        }
        return documentPagedResult;
    }

    private class DocumentPagedResult
    extends PagedResult<Document> {
        private DocumentPagedResult() {
        }
    }
}

