/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.security.service;

import io.jans.configapi.external.service.ExternalConfigService;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="interceptionService")
public class ExternalInterceptionService
implements Serializable {
    private static final long serialVersionUID = 4564959567069741194L;
    @Inject
    transient Logger log;
    @Inject
    ExternalConfigService externalConfigService;

    public boolean authorization(HttpServletRequest request, HttpServletResponse response, ApiAppConfiguration apiAppConfiguration, Map<String, Object> requestParameters, JSONObject responseAsJsonObject) {
        this.log.debug("External Interception Service - Authorization script params -  request:{}, response:{}, apiAppConfiguration:{}, requestParameters:{}, responseAsJsonObject:{}, externalConfigService{}, externalConfigService.isEnabled():{} ", new Object[]{request, response, apiAppConfiguration, requestParameters, responseAsJsonObject, this.externalConfigService, this.externalConfigService.isEnabled()});
        if (this.externalConfigService.isEnabled()) {
            return this.externalConfigService.checkAuthorization(request, response, apiAppConfiguration, requestParameters, responseAsJsonObject);
        }
        return true;
    }
}

