/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.security.service;

import io.jans.as.model.common.IntrospectionResponse;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.core.util.ProtectionScopeType;
import io.jans.configapi.security.service.AuthorizationService;
import io.jans.configapi.security.service.ExternalInterceptionService;
import io.jans.configapi.security.service.OpenIdService;
import io.jans.configapi.util.JwtUtil;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="openIdAuthorizationService")
@Alternative
@Priority(value=1)
public class OpenIdAuthorizationService
extends AuthorizationService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String AUTHENTICATION_SCHEME = "Bearer ";
    @Inject
    transient Logger logger;
    @Context
    transient HttpServletRequest request;
    @Context
    transient HttpServletResponse response;
    @Inject
    transient JwtUtil jwtUtil;
    @Inject
    OpenIdService openIdService;
    @Inject
    ExternalInterceptionService externalInterceptionService;

    @Override
    public String processAuthorization(String token, String issuer, ResourceInfo resourceInfo, String method, String path) throws WebApplicationException, Exception {
        this.logger.debug("oAuth  Authorization parameters , token:{}, issuer:{}, resourceInfo:{}, method: {}, path: {} ", new Object[]{token, issuer, resourceInfo, method, path});
        if (StringUtils.isBlank((CharSequence)token)) {
            this.logger.error("Token is blank !!!");
            throw new WebApplicationException("Token is blank.", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        this.logger.info("Validate issuer");
        if (StringUtils.isNotBlank((CharSequence)issuer) && !this.authUtil.isValidIssuer(issuer)) {
            throw new WebApplicationException("Header Issuer is Invalid.", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        this.logger.info("Verify if JWT");
        String acccessToken = token.substring("Bearer".length()).trim();
        boolean isJwtToken = this.jwtUtil.isJwt(acccessToken);
        if (isJwtToken) {
            try {
                this.logger.info("Since token is JWT Validate it");
                this.jwtUtil.parse(acccessToken);
                List<String> tokenScopes = this.jwtUtil.validateToken(acccessToken);
                this.logger.debug(" tokenScopes:{} ", tokenScopes);
                return this.validateScope(acccessToken, tokenScopes, resourceInfo, issuer);
            }
            catch (InvalidJwtException exp) {
                this.logger.error("oAuth Invalid Jwt token:{}, exception:{} ", (Object)token, (Object)exp);
                throw new WebApplicationException("Jwt Token is Invalid.", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        }
        this.logger.info("Token is NOT JWT hence introspecting it as Reference token ");
        IntrospectionResponse introspectionResponse = this.openIdService.getIntrospectionResponse(token, token.substring("Bearer".length()).trim(), issuer);
        this.logger.trace("oAuth  Authorization introspectionResponse:{}", (Object)introspectionResponse);
        if (introspectionResponse == null || !introspectionResponse.isActive()) {
            this.logger.error("Token is Invalid.");
            throw new WebApplicationException("Token is Invalid.", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        List tokenScopes = introspectionResponse.getScope();
        acccessToken = this.validateScope(acccessToken, tokenScopes, resourceInfo, issuer);
        boolean isAuthorized = this.externalAuthorization(token, issuer, method, path);
        this.logger.debug("Custom authorization - isAuthorized:{}", (Object)isAuthorized);
        return acccessToken;
    }

    private String validateScope(String accessToken, List<String> tokenScopes, ResourceInfo resourceInfo, String issuer) throws WebApplicationException {
        this.logger.info("Validate scope, accessToken:{}, tokenScopes:{}, resourceInfo: {}, issuer: {}", new Object[]{accessToken, tokenScopes, resourceInfo, issuer});
        try {
            Map<ProtectionScopeType, List<String>> resourceScopesByType = this.getRequestedScopes(resourceInfo);
            List<String> resourceScopes = this.getAllScopeList(resourceScopesByType);
            this.logger.debug("Validate scope, resourceScopesByType: {}, resourceScopes: {}", resourceScopesByType, resourceScopes);
            if (resourceScopes == null || resourceScopes.isEmpty()) {
                this.logger.info(" If no resource scopes required return original accessToken");
                return AUTHENTICATION_SCHEME + accessToken;
            }
            List<String> missingScopes = this.findMissingScopes(resourceScopesByType, tokenScopes);
            this.logger.info("missingScopes:{}", missingScopes);
            List<String> authSpecificScope = this.getAuthSpecificScopeRequired(resourceInfo);
            this.logger.info(" resourceScopes:{}, authSpecificScope:{} ", resourceScopes, authSpecificScope);
            if (authSpecificScope == null || authSpecificScope.isEmpty()) {
                this.logger.info("Validating token scopes as no authSpecificScope required");
                if (missingScopes != null && !missingScopes.isEmpty()) {
                    this.logger.error("Insufficient scopes! Required scope:{} -  however token scopes:{}", resourceScopes, tokenScopes);
                    throw new WebApplicationException("Insufficient scopes! , Required scope: " + resourceScopes + ", however token scopes: " + tokenScopes, Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                }
                return AUTHENTICATION_SCHEME + accessToken;
            }
            if (missingScopes != null && !missingScopes.isEmpty() && !this.isEqualCollection(missingScopes, authSpecificScope)) {
                this.logger.error("Insufficient scopes!! Required scope:{}, , however token scopes:{} ", resourceScopes, tokenScopes);
                throw new WebApplicationException("Insufficient scopes!! , Required scope: " + resourceScopes + ", however token scopes: " + tokenScopes, Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            if (missingScopes == null || missingScopes.isEmpty()) {
                this.logger.info(" No missing scopes and hence returning original accessToken");
                return AUTHENTICATION_SCHEME + accessToken;
            }
            this.logger.info("Generating new token with authSpecificScope");
            resourceScopes.addAll(authSpecificScope);
            accessToken = this.openIdService.requestAccessToken(this.authUtil.getClientId(), resourceScopes);
            this.logger.debug("Introspecting new accessToken:{}", (Object)accessToken);
            IntrospectionResponse introspectionResponse = this.openIdService.getIntrospectionResponse(AUTHENTICATION_SCHEME + accessToken, accessToken, this.authUtil.getIssuer());
            if (!this.validateScope(introspectionResponse.getScope(), resourceScopes)) {
                this.logger.error("Insufficient scopes!!! for new token as well - Required scope:{}, token scopes:{}", resourceScopes, (Object)introspectionResponse.getScope());
                throw new WebApplicationException("Insufficient scopes!!! Required scope: " + resourceScopes + ", token scopes: " + introspectionResponse.getScope(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            this.logger.info("Token scopes Valid Returning accessToken:{}", (Object)accessToken);
            return AUTHENTICATION_SCHEME + accessToken;
        }
        catch (Exception ex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("oAuth authorization error:{} ", (Object)ex.getMessage());
            }
            throw new WebApplicationException("oAuth authorization error " + ex.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
    }

    private boolean externalAuthorization(String token, String issuer, String method, String path) {
        this.logger.debug("External Authorization script params -  request:{}, response:{}, token:{}, issuer:{}, method:{}, path:{} ", new Object[]{this.request, this.response, token, issuer, method, path});
        HashMap<String, Object> requestParameters = new HashMap<String, Object>();
        requestParameters.put("ISSUER", issuer);
        requestParameters.put("TOKEN", token);
        requestParameters.put("METHOD", method);
        requestParameters.put("PATH", path);
        JSONObject responseAsJsonObject = Jackson.createJSONObject(requestParameters);
        return this.externalInterceptionService.authorization(this.request, this.response, this.configurationFactory.getApiAppConfiguration(), requestParameters, responseAsJsonObject);
    }

    private List<String> findMissingScopes(Map<ProtectionScopeType, List<String>> scopeMap, List<String> tokenScopes) {
        this.logger.info("Check scopeMap:{}, tokenScopes:{}", scopeMap, tokenScopes);
        List<String> scopeList = new ArrayList<String>();
        if (scopeMap == null || scopeMap.isEmpty()) {
            return scopeList;
        }
        scopeList = scopeMap.get(ProtectionScopeType.SUPER);
        this.logger.debug("SUPER Scopes:{}", scopeList);
        List<String> missingScopes = null;
        boolean containsScope = false;
        if (scopeList != null && !scopeList.isEmpty()) {
            containsScope = this.containsAnyElement(scopeList, tokenScopes);
            this.logger.debug("Token contains SUPER scopes?:{}", (Object)containsScope);
            if (containsScope) {
                return missingScopes;
            }
        }
        scopeList = scopeMap.get(ProtectionScopeType.GROUP);
        this.logger.debug("GROUP Scopes:{}", scopeList);
        if (scopeList != null && !scopeList.isEmpty()) {
            containsScope = this.containsAnyElement(scopeList, tokenScopes);
            this.logger.debug("Token contains GROUP scopes?:{}", (Object)containsScope);
            if (containsScope) {
                return missingScopes;
            }
        }
        scopeList = scopeMap.get(ProtectionScopeType.SCOPE);
        this.logger.debug("SCOPE Scopes:{}", scopeList);
        if (scopeList != null && !scopeList.isEmpty()) {
            missingScopes = this.findMissingElements(scopeList, tokenScopes);
            this.logger.debug("SCOPE Missing Scopes:{}", missingScopes);
        }
        return missingScopes;
    }
}

