/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import io.jans.as.model.config.Conf;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.config.GluuConfiguration;
import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.core.model.PersistenceConfiguration;
import io.jans.configapi.model.status.StatsData;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PersistenceMetadata;
import io.jans.service.document.store.conf.DocumentStoreConfiguration;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import org.slf4j.Logger;

@ApplicationScoped
public class ConfigurationService {
    @Inject
    Logger logger;
    @Inject
    @Named(value="persistenceEntryManager")
    PersistenceEntryManager persistenceManager;
    @Inject
    ConfigurationFactory configurationFactory;
    private StatsData statsData;

    public Conf findConf() {
        String dn = this.configurationFactory.getAuthConfigurationDn();
        return (Conf)this.persistenceManager.find((Object)dn, Conf.class, null);
    }

    public void merge(Conf conf) {
        conf.setRevision(conf.getRevision() + 1L);
        this.persistenceManager.merge((Object)conf);
    }

    public void merge(GluuConfiguration conf) {
        this.persistenceManager.merge((Object)conf);
    }

    public AppConfiguration find() {
        Conf conf = this.findConf();
        return conf.getDynamic();
    }

    public GluuConfiguration findGluuConfiguration() {
        String configurationDn = this.findConf().getStatics().getBaseDn().getConfiguration();
        if (StringHelper.isEmpty((String)configurationDn)) {
            return null;
        }
        return (GluuConfiguration)this.persistenceManager.find(GluuConfiguration.class, (Object)configurationDn);
    }

    public DocumentStoreConfiguration getDocumentStoreConfiguration() {
        GluuConfiguration gluuConfiguration = this.findGluuConfiguration();
        this.logger.info("gluuConfiguration:{}", (Object)gluuConfiguration);
        DocumentStoreConfiguration documentStoreConfiguration = null;
        if (gluuConfiguration == null) {
            throw new WebApplicationException("Cannot fetch DocumentStoreConfiguration as GluuConfiguration is null! ");
        }
        documentStoreConfiguration = gluuConfiguration.getDocumentStoreConfiguration();
        this.logger.info("Fetched documentStoreConfiguration:{}", (Object)documentStoreConfiguration);
        return documentStoreConfiguration;
    }

    public DocumentStoreConfiguration updateDocumentStoreConfiguration(DocumentStoreConfiguration documentStoreConfiguration) {
        this.logger.info("documentStoreConfiguration:{}", (Object)documentStoreConfiguration);
        if (documentStoreConfiguration == null) {
            return documentStoreConfiguration;
        }
        GluuConfiguration gluuConfiguration = this.findGluuConfiguration();
        this.logger.info("gluuConfiguration:{}", (Object)gluuConfiguration);
        if (gluuConfiguration == null) {
            throw new WebApplicationException("Cannot update DocumentStoreConfiguration as GluuConfiguration is null! ");
        }
        gluuConfiguration.setDocumentStoreConfiguration(documentStoreConfiguration);
        this.merge(gluuConfiguration);
        documentStoreConfiguration = gluuConfiguration.getDocumentStoreConfiguration();
        this.logger.info("Updated documentStoreConfiguration:{}", (Object)documentStoreConfiguration);
        return documentStoreConfiguration;
    }

    public String getPersistenceType() {
        return this.configurationFactory.getBaseConfiguration().getString("persistence.type");
    }

    public StatsData getStatsData() {
        return this.statsData;
    }

    public void setStatsData(StatsData statsData) {
        this.statsData = statsData;
    }

    public boolean isLowercaseFilter(String baseDn) {
        return !PersistenceEntryManager.PERSITENCE_TYPES.ldap.name().equals(this.persistenceManager.getPersistenceType(baseDn));
    }

    public String getRevokeUrl() {
        return this.configurationFactory.getApiAppConfiguration().getAuthOpenidRevokeUrl();
    }

    public PersistenceConfiguration getPersistenceMetadata() {
        PersistenceMetadata persistenceMetadata = this.persistenceManager.getPersistenceMetadata("o=jans");
        return this.getPersistenceConfiguration(persistenceMetadata);
    }

    private PersistenceConfiguration getPersistenceConfiguration(PersistenceMetadata persistenceMetadata) {
        PersistenceConfiguration persistenceConfiguration = new PersistenceConfiguration();
        if (persistenceMetadata == null) {
            return persistenceConfiguration;
        }
        persistenceConfiguration.setDatabaseName(persistenceMetadata.getDatabaseName());
        persistenceConfiguration.setSchemaName(persistenceMetadata.getSchemaName());
        persistenceConfiguration.setProductName(persistenceMetadata.getProductName());
        persistenceConfiguration.setProductVersion(persistenceMetadata.getProductVersion());
        persistenceConfiguration.setDriverName(persistenceMetadata.getDriverName());
        persistenceConfiguration.setDriverVersion(persistenceMetadata.getDriverVersion());
        return persistenceConfiguration;
    }
}

