/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import com.github.fge.jackson.JacksonUtils;
import com.google.common.collect.Lists;
import io.jans.config.GluuConfiguration;
import io.jans.config.IDPAuthConf;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.orm.couchbase.model.CouchbaseConnectionConfiguration;
import io.jans.service.EncryptionService;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
public class CouchbaseConfService {
    private static final String AUTH = "auth";
    @Inject
    ConfigurationService configurationService;
    @Inject
    private EncryptionService encryptionService;

    public List<CouchbaseConnectionConfiguration> findAll() {
        return this.getIDPAuthConf().stream().filter(c -> c.asCouchbaseConfiguration() != null).map(IDPAuthConf::asCouchbaseConfiguration).collect(Collectors.toList());
    }

    public void save(CouchbaseConnectionConfiguration conf) {
        this.save(Lists.newArrayList((Object[])new CouchbaseConnectionConfiguration[]{conf}));
    }

    public void save(List<CouchbaseConnectionConfiguration> confs) {
        GluuConfiguration configuration = this.configurationService.findGluuConfiguration();
        configuration.setIdpAuthn(this.getOrCreateIDPAuthConfs(configuration.getIdpAuthn(), confs));
        this.configurationService.merge(configuration);
    }

    public void remove(String name) {
        GluuConfiguration gluuConfiguration = this.configurationService.findGluuConfiguration();
        List existing = gluuConfiguration.getIdpAuthn();
        Optional<IDPAuthConf> existingConf = existing.stream().filter(o -> o.getName() != null && o.getName().equals(name)).findFirst();
        if (existingConf.isEmpty()) {
            return;
        }
        existing.remove(existingConf.get());
        gluuConfiguration.setIdpAuthn(existing);
        this.configurationService.merge(gluuConfiguration);
    }

    public Optional<CouchbaseConnectionConfiguration> findByName(String name) {
        List<CouchbaseConnectionConfiguration> all = this.findAll();
        return all.stream().filter(d -> d != null && d.getConfigId() != null && d.getConfigId().equals(name)).findFirst();
    }

    private List<IDPAuthConf> getIDPAuthConf() {
        List idpConfList = this.configurationService.findGluuConfiguration().getIdpAuthn();
        if (idpConfList == null) {
            return Lists.newArrayList();
        }
        return idpConfList;
    }

    private List<IDPAuthConf> getOrCreateIDPAuthConfs(List<IDPAuthConf> existing, List<CouchbaseConnectionConfiguration> confs) {
        if (existing == null) {
            existing = Lists.newArrayList();
        }
        for (CouchbaseConnectionConfiguration conf : confs) {
            IDPAuthConf idpConf;
            Optional<IDPAuthConf> existingConf = existing.stream().filter(o -> o.getName() != null && o.getName().equals(conf.getConfigId())).findFirst();
            if (existingConf.isEmpty()) {
                idpConf = new IDPAuthConf();
                existing.add(idpConf);
            } else {
                idpConf = existingConf.get();
            }
            if (this.shouldEncryptPassword(conf)) {
                try {
                    conf.setUserPassword(this.encryptionService.encrypt(conf.getUserPassword()));
                }
                catch (StringEncrypter.EncryptionException e) {
                    throw new RuntimeException("Unable to decrypt password.", e);
                }
            }
            idpConf.setType(AUTH);
            idpConf.setVersion(idpConf.getVersion() + 1);
            idpConf.setName(conf.getConfigId());
            idpConf.setEnabled(true);
            idpConf.setConfig(JacksonUtils.newMapper().valueToTree((Object)conf));
        }
        return existing;
    }

    private boolean shouldEncryptPassword(CouchbaseConnectionConfiguration conf) {
        Optional<CouchbaseConnectionConfiguration> oldConfiguration = this.findByName(conf.getConfigId());
        if (oldConfiguration.isEmpty()) {
            return false;
        }
        String encryptedOldPassword = oldConfiguration.get().getUserPassword();
        return !StringUtils.equals((CharSequence)encryptedOldPassword, (CharSequence)conf.getUserPassword());
    }
}

