/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import com.github.fge.jackson.JacksonUtils;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.jans.config.GluuConfiguration;
import io.jans.config.IDPAuthConf;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.model.ldap.GluuLdapConfiguration;
import io.jans.service.EncryptionService;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class LdapConfigurationService {
    private static final String AUTH = "auth";
    @Inject
    Logger log;
    @Inject
    ConfigurationService configurationService;
    @Inject
    private EncryptionService encryptionService;

    public List<GluuLdapConfiguration> findLdapConfigurations() {
        return this.getIDPAuthConf().stream().map(IDPAuthConf::asLdapConfiguration).collect(Collectors.toList());
    }

    public void save(GluuLdapConfiguration ldapConfiguration) {
        ArrayList<GluuLdapConfiguration> ldapConfigurations = new ArrayList<GluuLdapConfiguration>(this.findLdapConfigurations());
        ldapConfigurations.add(ldapConfiguration);
        this.save(ldapConfigurations);
    }

    public void save(List<GluuLdapConfiguration> ldapConfigurations) {
        GluuConfiguration configuration = this.configurationService.findGluuConfiguration();
        configuration.setIdpAuthn(this.getIDPAuthConfs(ldapConfigurations));
        this.configurationService.merge(configuration);
    }

    public void update(GluuLdapConfiguration ldapConfiguration) {
        List<GluuLdapConfiguration> ldapConfigurations = this.excludeFromConfigurations(new ArrayList<GluuLdapConfiguration>(this.findLdapConfigurations()), ldapConfiguration);
        ldapConfigurations.add(ldapConfiguration);
        this.save(ldapConfigurations);
    }

    public void remove(String name) {
        GluuLdapConfiguration toRemove = this.findByName(name);
        ArrayList<GluuLdapConfiguration> allConfiguration = new ArrayList<GluuLdapConfiguration>(this.findLdapConfigurations());
        List<GluuLdapConfiguration> newConfigurations = this.excludeFromConfigurations(allConfiguration, toRemove);
        this.save(newConfigurations);
    }

    public GluuLdapConfiguration findByName(String name) {
        List<GluuLdapConfiguration> ldapConfigurations = this.findLdapConfigurations();
        this.log.debug(" findByName name = name " + name + " ldapConfigurations = " + ldapConfigurations);
        Optional<GluuLdapConfiguration> matchingLdapConfiguration = ldapConfigurations.stream().filter(d -> d.getConfigId().equals(name)).findFirst();
        return matchingLdapConfiguration.get();
    }

    private List<IDPAuthConf> getIDPAuthConf() {
        List idpConfList = this.configurationService.findGluuConfiguration().getIdpAuthn();
        if (idpConfList == null) {
            return Lists.newArrayList();
        }
        return idpConfList.stream().filter(c -> c.getType().equalsIgnoreCase(AUTH)).collect(Collectors.toCollection(ArrayList::new));
    }

    private List<IDPAuthConf> getIDPAuthConfs(List<GluuLdapConfiguration> ldapConfigurations) {
        ArrayList<IDPAuthConf> idpConf = new ArrayList<IDPAuthConf>();
        for (GluuLdapConfiguration ldapConfig : ldapConfigurations) {
            if (this.shouldEncryptPassword(ldapConfig)) {
                try {
                    ldapConfig.setBindPassword(this.encryptionService.encrypt(ldapConfig.getBindPassword()));
                }
                catch (StringEncrypter.EncryptionException e) {
                    throw new RuntimeException("Unable to decrypt password.", e);
                }
            }
            if (ldapConfig.isUseAnonymousBind()) {
                ldapConfig.setBindDN(null);
            }
            IDPAuthConf ldapConfigIdpAuthConf = new IDPAuthConf();
            ldapConfig.updateStringsLists();
            ldapConfigIdpAuthConf.setType(AUTH);
            ldapConfigIdpAuthConf.setVersion(ldapConfigIdpAuthConf.getVersion() + 1);
            ldapConfigIdpAuthConf.setName(ldapConfig.getConfigId());
            ldapConfigIdpAuthConf.setEnabled(ldapConfig.isEnabled());
            ldapConfigIdpAuthConf.setConfig(JacksonUtils.newMapper().valueToTree((Object)ldapConfig));
            idpConf.add(ldapConfigIdpAuthConf);
        }
        return idpConf;
    }

    private List<GluuLdapConfiguration> excludeFromConfigurations(List<GluuLdapConfiguration> ldapConfigurations, GluuLdapConfiguration ldapConfiguration) {
        this.log.debug("\n\n\n excludeFromConfigurations ldapConfigurations = " + ldapConfigurations + " , ldapConfiguration = " + ldapConfiguration + "\n\n\n");
        boolean hadConfiguration = Iterables.removeIf(ldapConfigurations, c -> c.getConfigId().equals(ldapConfiguration.getConfigId()));
        if (!hadConfiguration) {
            throw new NoSuchElementException(ldapConfiguration.getConfigId());
        }
        return ldapConfigurations;
    }

    public boolean shouldEncryptPassword(GluuLdapConfiguration ldapConfiguration) {
        try {
            GluuLdapConfiguration oldConfiguration = this.findByName(ldapConfiguration.getConfigId());
            String encryptedOldPassword = oldConfiguration.getBindPassword();
            return !StringUtils.equals((CharSequence)encryptedOldPassword, (CharSequence)ldapConfiguration.getBindPassword());
        }
        catch (NoSuchElementException ex) {
            return true;
        }
    }
}

