/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.service.ConfigHttpService;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.util.AuthUtil;
import io.jans.model.net.HttpServiceResponse;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class SsaService {
    @Inject
    private Logger logger;
    @Inject
    AuthUtil authUtil;
    @Inject
    ConfigHttpService configHttpService;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String AUTHORIZATION = "Authorization";

    public JSONObject revokeSsa(String accessToken, String jti) throws JsonProcessingException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Revoke SSA parameters - jti:{}", (Object)Util.escapeLog((Object)jti));
        }
        if (StringUtils.isBlank((CharSequence)jti)) {
            throw new WebApplicationException("SSA unique identifier - JTI is required!", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE, "application/json");
        headers.put(AUTHORIZATION, accessToken);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("jti", jti);
        HttpServiceResponse httpServiceResponse = this.configHttpService.executeDelete(this.getSsaEndpoint(), headers, data);
        JSONObject jSONObject = null;
        this.logger.debug(" Revoke SSA httpServiceResponse:{}", (Object)httpServiceResponse);
        if (httpServiceResponse != null && httpServiceResponse.getHttpResponse() != null) {
            Response.Status status = this.configHttpService.getResponseStatus(httpServiceResponse);
            jSONObject = this.getResponseJSONObject(httpServiceResponse);
            this.logger.info(" status:{}, status.getStatusCode():{}, getResponseJSONObject(httpServiceResponse):{}", new Object[]{status, status.getStatusCode(), this.getResponseJSONObject(httpServiceResponse)});
            if (status.getStatusCode() != Response.Status.OK.getStatusCode()) {
                if (httpServiceResponse.getHttpResponse().getStatusLine() != null) {
                    throw new WebApplicationException(httpServiceResponse.getHttpResponse().getStatusLine().getReasonPhrase(), httpServiceResponse.getHttpResponse().getStatusLine().getStatusCode());
                }
                throw new WebApplicationException("Error while revoking SSA", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            }
        }
        this.logger.info(" Revoke SSA response jSONObject:{}", jSONObject);
        return jSONObject;
    }

    private String getSsaEndpoint() throws JsonProcessingException {
        String configurationEndpoint = this.authUtil.getIssuer() + ConfigHttpService.getOpenidConfigurationUrl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE, "application/json");
        this.logger.debug(" configurationEndpoint:{}", (Object)configurationEndpoint);
        HttpServiceResponse httpServiceResponse = this.configHttpService.executeGet(configurationEndpoint, headers, null);
        String jsonString = null;
        String endpoint = null;
        if (httpServiceResponse.getHttpResponse() != null && httpServiceResponse.getHttpResponse().getStatusLine() != null) {
            this.logger.trace(" FINAL  httpServiceResponse.getHttpResponse():{}, httpServiceResponse.getHttpResponse().getStatusLine():{}, httpServiceResponse.getHttpResponse().getEntity():{}", new Object[]{httpServiceResponse.getHttpResponse(), httpServiceResponse.getHttpResponse().getStatusLine(), httpServiceResponse.getHttpResponse().getEntity()});
            HttpEntity httpEntity = httpServiceResponse.getHttpResponse().getEntity();
            if (httpEntity != null) {
                jsonString = this.configHttpService.getContent(httpEntity);
                endpoint = Jackson.getElement((String)jsonString, (String)"ssa_endpoint");
                this.logger.debug("endpoint:{}", (Object)endpoint);
                if (StringUtils.isBlank((CharSequence)endpoint)) {
                    throw new WebApplicationException("Error while fetching ssa_endpoint from configurationEndpoint {" + configurationEndpoint + "} ");
                }
            }
        }
        this.logger.info(" Return endpoint:{}", endpoint);
        return endpoint;
    }

    private JSONObject getResponseJSONObject(HttpServiceResponse httpServiceResponse) {
        JSONObject jsonObj = null;
        if (httpServiceResponse == null) {
            return jsonObj;
        }
        jsonObj = new JSONObject();
        if (httpServiceResponse.getHttpResponse() != null) {
            jsonObj.put("description", (Object)httpServiceResponse.getHttpResponse().getStatusLine());
            if (httpServiceResponse.getHttpResponse().getStatusLine() != null) {
                jsonObj.put("status", httpServiceResponse.getHttpResponse().getStatusLine().getStatusCode());
            }
        }
        this.logger.info(" Return jsonObj:{}", (Object)jsonObj);
        return jsonObj;
    }
}

