/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.status;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.model.util.Util;
import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.model.status.FacterData;
import io.jans.configapi.model.status.StatsData;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.configapi.service.cdi.event.StatusCheckerTimerEvent;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import io.jans.util.StringHelper;
import io.jans.util.process.ProcessHelper;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class StatusCheckerTimer {
    private static final int DEFAULT_INTERVAL = 300;
    public static final String PROGRAM_FACTER = "facter";
    public static final String PROGRAM_SHOW_VERSION = "/opt/jans/printVersion.py";
    public static final String SERVICE_STATUS = "/opt/jans/bin/jans_services_status.py";
    public static final String GET_AGAMA_LAB_PROJECTS = "/opt/jans/bin/get_agama_lab_projects.py";
    private static final String JSON_ARG = "--json";
    private static final String PROG_EXEC_MSG = "Failed to execute program {} output";
    private static final String PROG_PARSE_MSG = "Failed to parse program {} output";
    private static final String RESULT_OUTPUT = "resultOutput:{}";
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    private AtomicBoolean isActive;

    @PostConstruct
    public void create() {
        this.log.debug("Creating Status Cheker Timer");
    }

    public void initTimer() {
        this.log.debug("Initializing Status Checker Timer");
        this.isActive = new AtomicBoolean(false);
        int delay = 60;
        int interval = 300;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(60, 300), (Object)new StatusCheckerTimerEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void process(@Observes @Scheduled StatusCheckerTimerEvent statusCheckerTimerEvent) {
        this.log.debug("Status Checker Timer Process");
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processInt();
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void processInt() {
        this.log.debug("Starting update of sever status");
        StatsData statsData = new StatsData();
        Date currentDateTime = new Date();
        statsData.setLastUpdate(currentDateTime);
        statsData.setFacterData(this.getFacterData());
        statsData.setDbType(this.configurationService.getPersistenceType());
        this.configurationService.setStatsData(statsData);
        this.log.debug("Configuration status update finished");
    }

    public StatsData getServerStatsData() {
        this.log.debug("Starting update of sever status");
        StatsData statsData = new StatsData();
        Date currentDateTime = new Date();
        statsData.setLastUpdate(currentDateTime);
        statsData.setFacterData(this.getFacterData());
        statsData.setDbType(this.configurationService.getPersistenceType());
        this.configurationService.setStatsData(statsData);
        this.log.debug("statsData:{}", (Object)statsData);
        return statsData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FacterData getFacterData() {
        this.log.debug("Getting Server status");
        FacterData facterData = new FacterData();
        ObjectMapper mapper = new ObjectMapper();
        if (!this.isLinux()) {
            return facterData;
        }
        CommandLine commandLine = new CommandLine(PROGRAM_FACTER);
        commandLine.addArgument("-j");
        this.log.debug("Getting server status for commandLine:{}", (Object)commandLine);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);){
            boolean result = ProcessHelper.executeProgram((CommandLine)commandLine, (boolean)false, (int)0, (OutputStream)bos);
            if (!result) {
                FacterData facterData2 = facterData;
                return facterData2;
            }
            String resultOutput = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            facterData = (FacterData)mapper.readValue(resultOutput, FacterData.class);
        }
        catch (UnsupportedEncodingException uex) {
            this.log.error(PROG_PARSE_MSG, (Object)PROGRAM_FACTER, (Object)uex);
            return facterData;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute program {} output:{}", (Object)PROGRAM_FACTER, (Object)ex);
        }
        this.log.debug("Server status - facterData:{}", (Object)facterData);
        return facterData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonNode getAppVersionData(String artifact) {
        if (this.log.isInfoEnabled()) {
            this.log.debug("Getting application version for artifact:{}", (Object)Util.escapeLog((Object)artifact));
        }
        JsonNode appVersion = null;
        if (!this.isLinux()) {
            return appVersion;
        }
        CommandLine commandLine = new CommandLine(PROGRAM_SHOW_VERSION);
        if (StringUtils.isNotBlank((CharSequence)artifact) && !artifact.equalsIgnoreCase("all")) {
            commandLine.addArgument("-artifact=" + artifact);
        }
        commandLine.addArgument(JSON_ARG);
        this.log.debug("Getting application version for commandLine:{}", (Object)commandLine);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);){
            boolean result = ProcessHelper.executeProgram((CommandLine)commandLine, (boolean)false, (int)0, (OutputStream)bos);
            if (!result) {
                JsonNode jsonNode = appVersion;
                return jsonNode;
            }
            String resultOutput = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            this.log.debug(RESULT_OUTPUT, (Object)resultOutput);
            if (StringUtils.isNotBlank((CharSequence)resultOutput)) {
                appVersion = Jackson.asJsonNode((String)resultOutput);
            }
        }
        catch (UnsupportedEncodingException uex) {
            this.log.debug(PROG_PARSE_MSG, (Object)PROGRAM_SHOW_VERSION, (Object)uex);
            return appVersion;
        }
        catch (Exception ex) {
            this.log.error(PROG_EXEC_MSG, (Object)PROGRAM_SHOW_VERSION, (Object)ex);
            return appVersion;
        }
        this.log.debug("Server application version - appVersion:{}", (Object)appVersion);
        return appVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonNode getServiceStatus(String serviceName) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Getting status for serviceName:{}", (Object)Util.escapeLog((Object)serviceName));
        }
        JsonNode serviceStatus = null;
        ObjectMapper mapper = new ObjectMapper();
        if (!this.isLinux()) {
            return serviceStatus;
        }
        CommandLine commandLine = new CommandLine(SERVICE_STATUS);
        if (StringUtils.isNotBlank((CharSequence)serviceName) && !serviceName.equalsIgnoreCase("all")) {
            commandLine.addArgument(" " + serviceName);
        }
        commandLine.addArgument(JSON_ARG);
        this.log.debug("Getting service status for commandLine:{}", (Object)commandLine);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);){
            boolean result = ProcessHelper.executeProgram((CommandLine)commandLine, (boolean)false, (int)0, (OutputStream)bos);
            if (!result) {
                JsonNode jsonNode = serviceStatus;
                return jsonNode;
            }
            String resultOutput = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            this.log.info(RESULT_OUTPUT, (Object)resultOutput);
            if (StringUtils.isNotBlank((CharSequence)resultOutput)) {
                serviceStatus = (JsonNode)mapper.readValue(resultOutput, JsonNode.class);
            }
        }
        catch (UnsupportedEncodingException uex) {
            this.log.error("Failed to parse serviceStatus data program {} output", (Object)SERVICE_STATUS, (Object)uex);
            return serviceStatus;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute serviceStatus program {} output", (Object)SERVICE_STATUS, (Object)ex);
            return serviceStatus;
        }
        this.log.debug("Service Status data - serviceStatus:{}", (Object)serviceStatus);
        return serviceStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonNode getAllAgamaRepositories() {
        if (this.log.isInfoEnabled()) {
            this.log.debug("Getting All Agama Lab Projects");
        }
        JsonNode appVersion = null;
        if (!this.isLinux()) {
            return appVersion;
        }
        CommandLine commandLine = new CommandLine(GET_AGAMA_LAB_PROJECTS);
        commandLine.addArgument(JSON_ARG);
        this.log.error("Getting Agama Lab Projects version for commandLine:{}", (Object)commandLine);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);){
            boolean result = ProcessHelper.executeProgram((CommandLine)commandLine, (boolean)false, (int)0, (OutputStream)bos);
            if (!result) {
                JsonNode jsonNode = appVersion;
                return jsonNode;
            }
            String resultOutput = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            this.log.error(RESULT_OUTPUT, (Object)resultOutput);
            if (StringUtils.isNotBlank((CharSequence)resultOutput)) {
                appVersion = Jackson.asJsonNode((String)resultOutput);
            }
        }
        catch (UnsupportedEncodingException uex) {
            this.log.error(PROG_PARSE_MSG, (Object)PROGRAM_SHOW_VERSION, (Object)uex);
            return appVersion;
        }
        catch (Exception ex) {
            this.log.error(PROG_EXEC_MSG, (Object)PROGRAM_SHOW_VERSION, (Object)ex);
            return appVersion;
        }
        this.log.debug("Server application version - appVersion:{}", (Object)appVersion);
        return appVersion;
    }

    public void printDirectory() {
        this.log.debug("printDirectory");
        if (!this.isLinux()) {
            return;
        }
        CommandLine commandLine = new CommandLine("pwd");
        String resultOutput = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);){
            boolean result = ProcessHelper.executeProgram((CommandLine)commandLine, (boolean)false, (int)0, (OutputStream)bos);
            if (!result) {
                return;
            }
            resultOutput = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            this.log.debug("Directory:{}", (Object)resultOutput);
        }
        catch (UnsupportedEncodingException uex) {
            this.log.debug("Failed to parse Directory program {} output", (Object)"Directory", (Object)uex);
            return;
        }
        catch (Exception ex) {
            this.log.error(PROG_EXEC_MSG, (Object)PROGRAM_SHOW_VERSION, (Object)ex);
        }
        this.log.debug(" Server Directory:{}", resultOutput);
    }

    private boolean isLinux() {
        String osName = System.getProperty("os.name");
        return !StringHelper.isEmpty((String)osName) && osName.toLowerCase().contains("linux");
    }
}

