/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.configuration;

import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.model.configuration.AssetMgtConfiguration;
import io.jans.configapi.security.api.ApiProtectionService;
import io.jans.configapi.security.service.AuthorizationService;
import io.jans.configapi.security.service.OpenIdAuthorizationService;
import io.jans.configapi.service.logger.LoggerService;
import io.jans.exception.ConfigurationException;
import io.jans.exception.OxIntializationException;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.service.PersistanceFactoryService;
import io.jans.service.PythonService;
import io.jans.service.cdi.event.LdapConfigurationReload;
import io.jans.service.cdi.util.CdiUtil;
import io.jans.service.custom.script.CustomScriptManager;
import io.jans.service.document.store.manager.DocumentStoreManager;
import io.jans.service.timer.QuartzSchedulerManager;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="appInitializer")
public class AppInitializer {
    @Inject
    Logger log;
    @Inject
    @Named(value="persistenceEntryManager")
    Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    @Inject
    BeanManager beanManager;
    @Inject
    ConfigurationFactory configurationFactory;
    @Inject
    private PersistanceFactoryService persistanceFactoryService;
    @Inject
    private ApiProtectionService apiProtectionService;
    @Inject
    private Instance<AuthorizationService> authorizationServiceInstance;
    @Inject
    private LoggerService loggerService;
    @Inject
    private QuartzSchedulerManager quartzSchedulerManager;
    @Inject
    private CustomScriptManager customScriptManager;
    @Inject
    private PythonService pythonService;
    @Inject
    DocumentStoreManager documentStoreManager;

    public void onStart(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        this.log.info("=============  STARTING API APPLICATION  ========================");
        this.log.info("init:{}", init);
        System.setProperty("resteasy.patchfilter.disabled", "true");
        ResteasyProviderFactory instance = ResteasyProviderFactory.getInstance();
        RegisterBuiltin.register((ResteasyProviderFactory)instance);
        instance.registerProvider(ResteasyJackson2Provider.class);
        this.configurationFactory.create();
        this.persistenceEntryManagerInstance.get();
        this.createAuthorizationService();
        ApiAppConfiguration apiAppConfiguration = this.configurationFactory.getApiAppConfiguration();
        this.log.info("Initialized ApiAppConfiguration:{}", (Object)apiAppConfiguration);
        this.pythonService.initPythonInterpreter(this.configurationFactory.getBaseConfiguration().getString("pythonModulesDir", null));
        this.initSchedulerService();
        this.initCustomScripts();
        this.configurationFactory.initTimer();
        this.loadCustomAsset(apiAppConfiguration.getServiceName());
        if (!apiAppConfiguration.isDisableLoggerTimer()) {
            this.log.debug("LoggerService timer enabled!");
            this.loggerService.initTimer(true);
        }
        this.log.info("==============  APPLICATION IS UP AND RUNNING ===================");
    }

    public void destroy(@Observes @BeforeDestroyed(value=ApplicationScoped.class) ServletContext init) {
        this.log.info("================================================================");
        this.log.info("===========  API APPLICATION STOPPED  ==========================");
        this.log.info("init:{}", (Object)init);
        this.log.info("================================================================");
    }

    @Produces
    @ApplicationScoped
    public ConfigurationFactory getConfigurationFactory() {
        return this.configurationFactory;
    }

    @Produces
    @ApplicationScoped
    public AssetMgtConfiguration getAssetMgtConfiguration() {
        return this.configurationFactory.getApiAppConfiguration().getAssetMgtConfiguration();
    }

    @Produces
    @ApplicationScoped
    @Named(value="persistenceEntryManager")
    public PersistenceEntryManager createPersistenceEntryManager() throws OxIntializationException {
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.persistanceFactoryService.getPersistenceEntryManagerFactory(this.configurationFactory.getPersistenceConfiguration());
        PersistenceEntryManager persistenceEntryManager = persistenceEntryManagerFactory.createEntryManager(this.configurationFactory.getDecryptedConnectionProperties());
        this.log.debug("Created {} with operation service {}", (Object)persistenceEntryManager, (Object)persistenceEntryManager.getOperationService());
        return persistenceEntryManager;
    }

    @Produces
    @ApplicationScoped
    @Named(value="authorizationService")
    private AuthorizationService createAuthorizationService() {
        this.log.info("=============  AppInitializer::createAuthorizationService() - configurationFactory.getApiProtectionType():{} ", (Object)this.configurationFactory.getApiProtectionType());
        if (StringHelper.isEmpty((String)this.configurationFactory.getApiProtectionType())) {
            throw new ConfigurationException("API Protection Type not defined");
        }
        try {
            this.apiProtectionService.verifyResources(this.configurationFactory.getApiProtectionType(), this.configurationFactory.getApiClientId());
            return (AuthorizationService)this.authorizationServiceInstance.select(OpenIdAuthorizationService.class, new Annotation[0]).get();
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed to create AuthorizationService instance - apiProtectionType:{}, exception:{} ", (Object)this.configurationFactory.getApiProtectionType(), (Object)ex);
            }
            throw new ConfigurationException("Failed to create AuthorizationService instance  - apiProtectionType = " + this.configurationFactory.getApiProtectionType(), (Throwable)ex);
        }
    }

    public void recreatePersistanceEntryManager(@Observes @LdapConfigurationReload String event) {
        this.closePersistenceEntryManager();
        PersistenceEntryManager ldapEntryManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        this.persistenceEntryManagerInstance.destroy((Object)ldapEntryManager);
        this.log.debug("Recreated instance {} with operation service: {} - event:{}", new Object[]{ldapEntryManager, ldapEntryManager.getOperationService(), event});
    }

    private void closePersistenceEntryManager() {
        PersistenceEntryManager oldInstance = (PersistenceEntryManager)CdiUtil.getContextBean((BeanManager)this.beanManager, PersistenceEntryManager.class, (String)"persistenceEntryManager", (Annotation[])new Annotation[0]);
        if (oldInstance == null || oldInstance.getOperationService() == null) {
            return;
        }
        this.log.debug("Attempting to destroy {} with operation service: {}", (Object)oldInstance, (Object)oldInstance.getOperationService());
        oldInstance.destroy();
        this.log.debug("Destroyed {} with operation service: {}", (Object)oldInstance, (Object)oldInstance.getOperationService());
    }

    protected void initSchedulerService() {
        this.log.debug("Initializing Scheduler Service");
        this.quartzSchedulerManager.start();
        String disableScheduler = System.getProperties().getProperty("gluu.disable.scheduler");
        if (Boolean.parseBoolean(disableScheduler)) {
            this.log.warn("Suspending Quartz Scheduler Service...");
            this.quartzSchedulerManager.standby();
        }
    }

    private void initCustomScripts() {
        ArrayList supportedCustomScriptTypes = new ArrayList();
        this.customScriptManager.initTimer(Arrays.asList(CustomScriptType.CONFIG_API, CustomScriptType.PERSISTENCE_EXTENSION));
        this.log.info("Initialized Custom Scripts!");
    }

    private void loadCustomAsset(String serviceName) {
        try {
            if (StringHelper.isEmpty((String)serviceName)) {
                serviceName = "jans-config-api";
            }
            this.log.info("Loading Custom Asset for serviceName:{} ", (Object)serviceName);
            this.documentStoreManager.initTimer(Arrays.asList(serviceName));
            this.log.info("Custom Asset for serviceName:{} loaded", (Object)serviceName);
        }
        catch (Exception ex) {
            this.log.error("Error while loadCustomAsset is - ", (Throwable)ex);
        }
    }
}

