/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.external.context;

import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.model.SimpleCustomProperty;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.service.external.context.ExternalScriptContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConfigAuthContext
extends ExternalScriptContext {
    private CustomScriptConfiguration script;
    private ApiAppConfiguration apiAppConfiguration;
    private Map<String, Object> requestParameters;
    private final Map<String, SimpleCustomProperty> configurationAttributes;

    public ConfigAuthContext(HttpServletRequest httpRequest, HttpServletResponse httpResponse, ApiAppConfiguration apiAppConfiguration, Map<String, Object> requestParameters, CustomScriptConfiguration script) {
        this(httpRequest, httpResponse, apiAppConfiguration, requestParameters, script, null);
    }

    public ConfigAuthContext(HttpServletRequest httpRequest, HttpServletResponse httpResponse, ApiAppConfiguration apiAppConfiguration, Map<String, Object> requestParameters, CustomScriptConfiguration script, Map<String, SimpleCustomProperty> configurationAttributes) {
        super(httpRequest, httpResponse);
        this.apiAppConfiguration = apiAppConfiguration;
        this.requestParameters = requestParameters;
        this.script = script;
        this.configurationAttributes = configurationAttributes;
    }

    public CustomScriptConfiguration getScript() {
        return this.script;
    }

    public void setScript(CustomScriptConfiguration script) {
        this.script = script;
    }

    public ApiAppConfiguration getApiAppConfiguration() {
        return this.apiAppConfiguration;
    }

    public void setApiAppConfiguration(ApiAppConfiguration apiAppConfiguration) {
        this.apiAppConfiguration = apiAppConfiguration;
    }

    public Map<String, Object> getRequestParameters() {
        return this.requestParameters;
    }

    public Map<String, SimpleCustomProperty> getConfigurationAttributes() {
        return this.configurationAttributes;
    }

    public Map<String, SimpleCustomProperty> getConfigurationAttibutes() {
        String issuer;
        Map attrs = this.script.getConfigurationAttributes();
        if (this.httpRequest != null && StringUtils.isNotBlank((CharSequence)(issuer = this.httpRequest.getHeader("issuer")))) {
            SimpleCustomProperty issuerProperty = new SimpleCustomProperty();
            issuerProperty.setValue1(issuer);
            attrs.put("issuer", issuerProperty);
        }
        return attrs != null ? new HashMap<String, SimpleCustomProperty>(attrs) : new HashMap();
    }

    public String toString() {
        return "ConfigAuthContext [script=" + this.script + ", apiAppConfiguration=" + this.apiAppConfiguration + ", requestParameters=" + this.requestParameters + ", configurationAttributes=" + this.configurationAttributes + "]";
    }
}

