/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.filters;

import io.jans.configapi.model.configuration.CorsConfiguration;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@WebFilter(filterName="CorsFilter", asyncSupported=true, urlPatterns={"*"})
public class CorsFilter
implements Filter {
    @Inject
    private Logger log;
    @Inject
    private CorsConfiguration corsConfiguration;
    private static final Pattern COMMA_SEPARATED_SPLIT_REGEX = Pattern.compile("\\s*,\\s*");
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String RESPONSE_HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.log.debug("CorsFilter::doFilter() - corsConfiguration:{}", (Object)this.corsConfiguration);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String origin = request.getHeader("Origin");
        this.log.debug("CorsFilter::doFilter() - origin:{}", (Object)origin);
        if (this.corsConfiguration == null || StringUtils.isBlank((CharSequence)origin) || !this.corsConfiguration.isEnabled()) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String requestedMethods = request.getHeader(ACCESS_CONTROL_REQUEST_METHOD);
        this.log.debug("CorsFilter::doFilter() - requestedMethods:{}", (Object)requestedMethods);
        this.processMethods(response, requestedMethods);
        String requestedHeaders = request.getHeader(ACCESS_CONTROL_REQUEST_HEADERS);
        this.log.debug("CorsFilter::doFilter() -  requestedHeaders:{}", (Object)requestedHeaders);
        if (StringUtils.isNotBlank((CharSequence)requestedHeaders)) {
            this.processRequestedHeaders(response, requestedHeaders);
        }
        this.log.debug("CorsFilter::doFilter() - corsConfiguration.getAllowedOrigins():{} ", (Object)this.corsConfiguration.getAllowedOrigins());
        boolean allowOrigin = this.corsConfiguration.getAllowedOrigins() == null || this.corsConfiguration.getAllowedOrigins().isEmpty() || this.corsConfiguration.isOriginAllowed(origin);
        this.log.debug("CorsFilter::doFilter() - allowOrigin:{} ", (Object)allowOrigin);
        if (allowOrigin) {
            this.log.debug("CorsFilter::doFilter() - setting allowOrigin");
            response.addHeader(ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        }
        this.log.debug("CorsFilter::doFilter() - corsConfiguration.isSupportsCredentials():{} ", (Object)this.corsConfiguration.isSupportsCredentials());
        boolean allowCredentials = this.corsConfiguration.isSupportsCredentials() || this.corsConfiguration.getAllowedOrigins() != null && this.corsConfiguration.isOriginAllowed(origin) && !this.corsConfiguration.getAllowedOrigins().contains("*");
        this.log.debug("CorsFilter::doFilter() - allowCredentials:{} ", (Object)allowCredentials);
        response.addHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, String.valueOf(allowCredentials));
        this.log.debug("CorsFilter::doFilter() - corsConfiguration.getExposedHeaders():{}", (Object)this.corsConfiguration.getExposedHeaders());
        Collection exposedHeaders = this.corsConfiguration.getExposedHeaders();
        this.log.debug("CorsFilter::doFilter() - exposedHeaders:{}", (Object)exposedHeaders);
        if (exposedHeaders != null && !exposedHeaders.isEmpty()) {
            this.log.debug("CorsFilter::doFilter() - setting exposedHeaders ");
            response.addHeader(ACCESS_CONTROL_EXPOSE_HEADERS, String.join((CharSequence)",", exposedHeaders));
        }
        this.log.debug("CorsFilter::doFilter() - request.getMethod():{} , corsConfiguration.getPreflightMaxAge():{}", (Object)request.getMethod(), (Object)this.corsConfiguration.getPreflightMaxAge());
        if ("OPTIONS".equals(request.getMethod())) {
            this.log.debug("CorsFilter::doFilter() - OPTIONS method");
            if ((requestedHeaders != null || requestedMethods != null) && this.corsConfiguration.getPreflightMaxAge() != 0L) {
                this.log.debug("CorsFilter::doFilter() - setting PreflightMaxAge ");
                response.addHeader(ACCESS_CONTROL_MAX_AGE, String.valueOf(this.corsConfiguration.getPreflightMaxAge()));
            }
        } else {
            this.log.debug("CorsFilter::doFilter() - chaining request ");
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void processRequestedHeaders(HttpServletResponse response, String allowHeadersValue) {
        this.log.debug(" CorsFilter::processRequestedHeaders() - allowHeadersValue:{} , corsConfiguration.getAllowedHttpHeaders():{}", (Object)allowHeadersValue, (Object)this.corsConfiguration.getAllowedHttpHeaders());
        if (this.corsConfiguration.getAllowedHttpHeaders() == null || this.corsConfiguration.getAllowedHttpHeaders().isEmpty()) {
            response.addHeader("Access-Control-Allow-Headers", allowHeadersValue);
        } else {
            ArrayList<String> requestedHeaders = new ArrayList<String>();
            for (String requestedHeader : COMMA_SEPARATED_SPLIT_REGEX.split(allowHeadersValue)) {
                requestedHeaders.add(requestedHeader.toLowerCase());
            }
            this.log.debug("CorsFilter::processRequestedHeaders() - requestedHeaders:{}, corsConfiguration.getAllowedHttpHeaders():{}", requestedHeaders, (Object)this.corsConfiguration.getAllowedHttpHeaders());
            ArrayList<String> validRequestedHeaders = new ArrayList<String>();
            for (String configHeader : this.corsConfiguration.getAllowedHttpHeaders()) {
                this.log.debug("CorsFilter::processRequestedHeaders() - configHeader:{}", (Object)configHeader);
                if (!requestedHeaders.contains(configHeader.toLowerCase())) continue;
                validRequestedHeaders.add(configHeader);
            }
            this.log.debug("CorsFilter::processRequestedHeaders() - validRequestedHeaders:{}", validRequestedHeaders);
            if (!validRequestedHeaders.isEmpty()) {
                response.addHeader("Access-Control-Allow-Headers", String.join((CharSequence)",", validRequestedHeaders));
            }
        }
    }

    private void processMethods(HttpServletResponse response, String allowMethodsValue) {
        this.log.debug(" CorsFilter::processMethods() - allowMethodsValue:{} , corsConfiguration.getAllowedHttpMethods():{} ", (Object)allowMethodsValue, (Object)this.corsConfiguration.getAllowedHttpMethods());
        if (StringUtils.isBlank((CharSequence)allowMethodsValue)) {
            return;
        }
        if (this.corsConfiguration.getAllowedHttpMethods() == null || this.corsConfiguration.getAllowedHttpMethods().isEmpty()) {
            response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, allowMethodsValue);
        } else {
            ArrayList<String> requestedMethods = new ArrayList<String>();
            for (String requestedMethod : COMMA_SEPARATED_SPLIT_REGEX.split(allowMethodsValue)) {
                this.log.debug(" CorsFilter::processMethods() - requestedMethod:{}", (Object)requestedMethod);
                requestedMethods.add(requestedMethod.toLowerCase());
            }
            this.log.debug(" CorsFilter::processMethods() - requestedMethods:{} , corsConfiguration.getAllowedHttpMethods():{}", requestedMethods, (Object)this.corsConfiguration.getAllowedHttpMethods());
            ArrayList<String> validRequestedMethods = new ArrayList<String>();
            for (String configMethod : this.corsConfiguration.getAllowedHttpMethods()) {
                this.log.debug(" CorsFilter::processMethods() - configMethod:{}", (Object)configMethod);
                if (!requestedMethods.contains(configMethod.toLowerCase())) continue;
                this.log.debug(" CorsFilter::processMethods() - validRequestedMethods");
                validRequestedMethods.add(configMethod);
            }
            this.log.debug(" CorsFilter::processMethods() - validRequestedMethods:{}", validRequestedMethods);
            if (!validRequestedMethods.isEmpty()) {
                response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, String.join((CharSequence)",", validRequestedMethods));
            }
        }
    }
}

