/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.filters;

import io.swagger.v3.core.filter.AbstractSpecFilter;
import io.swagger.v3.core.model.ApiDescription;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SpecFilter
extends AbstractSpecFilter {
    public Optional<Operation> filterOperation(Operation operation, ApiDescription api, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        try {
            if (operation != null) {
                this.setRequestExample(operation);
                this.setResponseExample(operation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.of(operation);
    }

    private void setRequestExample(Operation operation) {
        if (operation != null && operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
            try {
                for (MediaType mediaType : operation.getRequestBody().getContent().values()) {
                    if (mediaType == null || mediaType.getExamples() == null || mediaType.getExamples().values() == null) continue;
                    for (Example example : mediaType.getExamples().values()) {
                        this.setExample(example);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setResponseExample(Operation operation) {
        if (operation != null && operation.getResponses() != null && !operation.getResponses().isEmpty()) {
            try {
                for (Map.Entry responseEntry : operation.getResponses().entrySet()) {
                    ApiResponse apiResponse = (ApiResponse)responseEntry.getValue();
                    if (apiResponse == null || apiResponse.getContent() == null) continue;
                    for (Map.Entry mediaEntry : apiResponse.getContent().entrySet()) {
                        if (mediaEntry.getValue() == null || ((MediaType)mediaEntry.getValue()).getExamples() == null) continue;
                        for (Example example : ((MediaType)mediaEntry.getValue()).getExamples().values()) {
                            this.setExample(example);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setExample(Example example) throws IOException {
        if (example == null) {
            return;
        }
        if (example.getValue() != null && example.getValue().toString().endsWith(".json")) {
            example.setValue((Object)this.getExample(example.getValue().toString()));
        }
    }

    private String getExample(String fileName) throws IOException {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return "";
        }
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
        return this.getExampleContent(inputStream);
    }

    private String getExampleContent(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(is);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
            is.close();
        }
        return stringBuilder.toString();
    }
}

