/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest;

import io.jans.configapi.core.rest.BaseApiApplication;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.rest.health.ApiHealthCheck;
import io.jans.configapi.rest.resource.auth.AcrsResource;
import io.jans.configapi.rest.resource.auth.AgamaDeploymentsResource;
import io.jans.configapi.rest.resource.auth.AgamaRepoResource;
import io.jans.configapi.rest.resource.auth.AgamaResource;
import io.jans.configapi.rest.resource.auth.AssetResource;
import io.jans.configapi.rest.resource.auth.AttributesResource;
import io.jans.configapi.rest.resource.auth.AuditLogResource;
import io.jans.configapi.rest.resource.auth.AuthConfigResource;
import io.jans.configapi.rest.resource.auth.CacheConfigurationResource;
import io.jans.configapi.rest.resource.auth.ClientAuthResource;
import io.jans.configapi.rest.resource.auth.ClientsResource;
import io.jans.configapi.rest.resource.auth.ConfigApiResource;
import io.jans.configapi.rest.resource.auth.ConfigSmtpResource;
import io.jans.configapi.rest.resource.auth.CustomScriptResource;
import io.jans.configapi.rest.resource.auth.DatabaseResource;
import io.jans.configapi.rest.resource.auth.HealthCheckResource;
import io.jans.configapi.rest.resource.auth.JwksResource;
import io.jans.configapi.rest.resource.auth.LdapConfigurationResource;
import io.jans.configapi.rest.resource.auth.LoggingResource;
import io.jans.configapi.rest.resource.auth.MessageConfigurationResource;
import io.jans.configapi.rest.resource.auth.OrganizationResource;
import io.jans.configapi.rest.resource.auth.PluginResource;
import io.jans.configapi.rest.resource.auth.ScopesResource;
import io.jans.configapi.rest.resource.auth.SessionResource;
import io.jans.configapi.rest.resource.auth.SsaResource;
import io.jans.configapi.rest.resource.auth.StatResource;
import io.jans.configapi.rest.resource.auth.TokenResource;
import io.jans.configapi.rest.resource.auth.UmaResourcesResource;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;

@ApplicationPath(value="/api/v1")
@OpenAPIDefinition(info=@Info(title="Jans Config API", contact=@Contact(name="Contact", url="https://github.com/JanssenProject/jans/discussions"), license=@License(name="License", url="https://github.com/JanssenProject/jans/blob/main/LICENSE"), version="OAS Version"), tags={@Tag(name="Attribute"), @Tag(name="Default Authentication Method"), @Tag(name="Cache Configuration"), @Tag(name="Cache Configuration \u2013 Memcached"), @Tag(name="Cache Configuration \u2013 Redis"), @Tag(name="Cache Configuration \u2013 in-Memory"), @Tag(name="Cache Configuration \u2013 Native-Persistence"), @Tag(name="Configuration \u2013 Properties"), @Tag(name="Configuration \u2013 SMTP"), @Tag(name="Configuration \u2013 Logging"), @Tag(name="Configuration \u2013 JWK - JSON Web Key (JWK)"), @Tag(name="Custom Scripts"), @Tag(name="Database - LDAP configuration"), @Tag(name="OAuth - OpenID Connect - Clients"), @Tag(name="OAuth - UMA Resources"), @Tag(name="OAuth - Scopes"), @Tag(name="Agama - Configuration"), @Tag(name="Agama"), @Tag(name="Statistics - User"), @Tag(name="Health - Check"), @Tag(name="Server Stats"), @Tag(name="Auth - Session Management"), @Tag(name="Organization Configuration"), @Tag(name="Auth Server Health - Check"), @Tag(name="Plugins"), @Tag(name="Configuration \u2013 Config API"), @Tag(name="Client Authorization"), @Tag(name="Jans Assets"), @Tag(name="Token"), @Tag(name="Logs"), @Tag(name="Database"), @Tag(name="Software Statement Assertion (SSA)")}, servers={@Server(url="https://jans.local.io", description="The Jans server")})
@SecurityScheme(name="oauth2", type=SecuritySchemeType.OAUTH2, flows=@OAuthFlows(clientCredentials=@OAuthFlow(tokenUrl="https://{op-hostname}/.../token", scopes={@OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/properties.readonly", description="View Auth Server properties related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/config/properties.write", description="Manage Auth Server properties related information"), @OAuthScope(name="https://jans.io/oauth/config/attributes.readonly", description="View attribute related information"), @OAuthScope(name="https://jans.io/oauth/config/attributes.write", description="Manage attribute related information"), @OAuthScope(name="https://jans.io/oauth/config/attributes.delete", description="Delete attribute related information"), @OAuthScope(name="https://jans.io/oauth/config/acrs.readonly", description="View ACRS related information"), @OAuthScope(name="https://jans.io/oauth/config/acrs.write", description="Manage ACRS related information"), @OAuthScope(name="https://jans.io/oauth/config/database/ldap.readonly", description="View LDAP database related information"), @OAuthScope(name="https://jans.io/oauth/config/database/ldap.write", description="Manage LDAP database related information"), @OAuthScope(name="https://jans.io/oauth/config/database/ldap.delete", description="Delete LDAP database related information"), @OAuthScope(name="https://jans.io/oauth/config/scripts.readonly", description="View cache scripts information"), @OAuthScope(name="https://jans.io/oauth/config/scripts.write", description="Manage scripts related information"), @OAuthScope(name="https://jans.io/oauth/config/scripts.delete", description="Delete scripts related information"), @OAuthScope(name="https://jans.io/oauth/config/cache.readonly", description="View cache related information"), @OAuthScope(name="https://jans.io/oauth/config/cache.write", description="Manage cache related information"), @OAuthScope(name="https://jans.io/oauth/config/smtp.readonly", description="View SMTP related information"), @OAuthScope(name="https://jans.io/oauth/config/smtp.write", description="Manage SMTP related information"), @OAuthScope(name="https://jans.io/oauth/config/smtp.delete", description="Delete SMTP related information"), @OAuthScope(name="https://jans.io/oauth/config/logging.readonly", description="View logging related information"), @OAuthScope(name="https://jans.io/oauth/config/logging.write", description="Manage logging related information"), @OAuthScope(name="https://jans.io/oauth/config/jwks.readonly", description="View JWKS related information"), @OAuthScope(name="https://jans.io/oauth/config/jwks.write", description="Manage JWKS related information"), @OAuthScope(name="https://jans.io/oauth/config/jwks.delete", description="Delete JWKS related information"), @OAuthScope(name="https://jans.io/oauth/config/openid/clients.readonly", description="View clients related information"), @OAuthScope(name="https://jans.io/oauth/config/openid/clients.write", description="Manage clients related information"), @OAuthScope(name="https://jans.io/oauth/config/openid/clients.delete", description="Delete clients related information"), @OAuthScope(name="https://jans.io/oauth/config/scopes.readonly", description="View scope related information"), @OAuthScope(name="https://jans.io/oauth/config/scopes.write", description="Manage scope related information"), @OAuthScope(name="https://jans.io/oauth/config/scopes.delete", description="Delete scope related information"), @OAuthScope(name="https://jans.io/oauth/config/uma/resources.readonly", description="View UMA Resource related information"), @OAuthScope(name="https://jans.io/oauth/config/uma/resources.write", description="Manage UMA Resource related information"), @OAuthScope(name="https://jans.io/oauth/config/uma/resources.delete", description="Delete UMA Resource related information"), @OAuthScope(name="https://jans.io/oauth/config/stats.readonly", description="View server with basic statistic"), @OAuthScope(name="https://jans.io/oauth/config/organization.readonly", description="View organization configuration information"), @OAuthScope(name="https://jans.io/oauth/config/organization.write", description="Manage organization configuration information"), @OAuthScope(name="https://jans.io/oauth/config/agama.readonly", description="View Agama Flow related information"), @OAuthScope(name="https://jans.io/oauth/config/agama.write", description="Manage Agama Flow related information"), @OAuthScope(name="https://jans.io/oauth/config/agama.delete", description="Delete Agama Flow related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/session.readonly", description="View Session related information"), @OAuthScope(name="https://jans.io/oauth/jans-auth-server/session.delete", description="Delete Session information"), @OAuthScope(name="https://jans.io/oauth/config/read-all", description="Admin read scope"), @OAuthScope(name="https://jans.io/oauth/config/write-all", description="Admin write scope"), @OAuthScope(name="https://jans.io/oauth/config/delete-all", description="Admin delete scope"), @OAuthScope(name="https://jans.io/oauth/config/openid-read", description="View OpenID functionality"), @OAuthScope(name="https://jans.io/oauth/config/openid/openid-write", description="Manage OpenID functionality"), @OAuthScope(name="https://jans.io/oauth/config/openid/openid-delete", description="Delete OpenID functionality"), @OAuthScope(name="https://jans.io/oauth/config/uma-read", description="View UMA functionality"), @OAuthScope(name="https://jans.io/oauth/config/uma-write", description="Manage UMA functionality"), @OAuthScope(name="https://jans.io/oauth/config/uma-delete", description="Delete UMA functionality"), @OAuthScope(name="https://jans.io/oauth/config/plugin.readonly", description="View Plugin information"), @OAuthScope(name="https://jans.io/oauth/config/properties.readonly", description="View Config-API related configuration properties"), @OAuthScope(name="https://jans.io/oauth/config/properties.write", description="Manage Config-API related configuration properties"), @OAuthScope(name="https://jans.io/oauth/client/authorizations.readonly", description="View ClientAuthorizations"), @OAuthScope(name="https://jans.io/oauth/client/authorizations.delete", description="Revoke ClientAuthorizations"), @OAuthScope(name="https://jans.io/oauth/config/jans_asset-read", description="View Jans Assets"), @OAuthScope(name="https://jans.io/oauth/config/jans_asset-write", description="Manage Jans Assets"), @OAuthScope(name="https://jans.io/oauth/config/jans_asset-delete", description="Delete Jans Assets"), @OAuthScope(name="https://jans.io/oauth/config/token.readonly", description="View Token details"), @OAuthScope(name="https://jans.io/oauth/config/token.write", description="Manage Token details"), @OAuthScope(name="https://jans.io/oauth/config/token.delete", description="Delete Token details"), @OAuthScope(name="https://jans.io/oauth/config/data.readonly", description="View Config-API related data"), @OAuthScope(name="https://jans.io/oauth/config/audit-read", description="View Audit Log related data"), @OAuthScope(name="https://jans.io/oauth/config/ssa.readonly", description="View SSA details"), @OAuthScope(name="https://jans.io/oauth/config/ssa.write", description="Manage SSA details"), @OAuthScope(name="https://jans.io/oauth/config/ssa.delete", description="Delete SSA details")})))
public class ApiApplication
extends BaseApiApplication {
    @Inject
    Logger log;
    @Inject
    private ApiAppConfiguration appConfiguration;

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        classes = (HashSet)this.addCommonClasses(classes);
        classes.add(ApiHealthCheck.class);
        classes.add(AcrsResource.class);
        classes.add(AttributesResource.class);
        classes.add(CacheConfigurationResource.class);
        classes.add(MessageConfigurationResource.class);
        classes.add(ClientsResource.class);
        classes.add(AuthConfigResource.class);
        classes.add(ConfigSmtpResource.class);
        classes.add(CustomScriptResource.class);
        classes.add(JwksResource.class);
        classes.add(LdapConfigurationResource.class);
        classes.add(LoggingResource.class);
        classes.add(ScopesResource.class);
        classes.add(UmaResourcesResource.class);
        classes.add(StatResource.class);
        classes.add(HealthCheckResource.class);
        classes.add(OrganizationResource.class);
        classes.add(AgamaResource.class);
        classes.add(AgamaDeploymentsResource.class);
        classes.add(SessionResource.class);
        classes.add(PluginResource.class);
        classes.add(ConfigApiResource.class);
        classes.add(ClientAuthResource.class);
        classes.add(TokenResource.class);
        classes.add(AgamaRepoResource.class);
        classes.add(AuditLogResource.class);
        classes.add(DatabaseResource.class);
        classes.add(SsaResource.class);
        this.log.info("appConfiguration:{}", (Object)this.appConfiguration);
        if (this.appConfiguration != null && this.appConfiguration.getAssetMgtConfiguration() != null && this.appConfiguration.getAssetMgtConfiguration().isAssetMgtEnabled()) {
            classes.add(AssetResource.class);
        }
        return classes;
    }
}

