/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.health;

import com.fasterxml.jackson.databind.JsonNode;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.model.HealthStatus;
import io.jans.configapi.core.model.Status;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.model.status.StatsData;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.configapi.service.status.StatusCheckerTimer;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import org.slf4j.Logger;

@Path(value="/health")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ApiHealthCheck {
    @Inject
    Logger logger;
    @Inject
    ConfigurationService configurationService;
    @Inject
    StatusCheckerTimer statusCheckerTimer;

    @Operation(summary="Returns application health status", description="Returns application health status", operationId="get-config-health", tags={"Health - Check"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=HealthStatus.class)))}), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    public Response getHealthResponse() {
        this.logger.debug("Api Health Check - /health/");
        HealthStatus healthStatus = new HealthStatus();
        healthStatus.setStatus("UP");
        ArrayList<Status> satusList = new ArrayList<Status>();
        Status liveness = new Status();
        liveness.setName("jans-config-api liveness");
        liveness.setStatus("UP");
        satusList.add(liveness);
        Status readiness = new Status();
        readiness.setName("jans-config-api readiness");
        try {
            this.checkDatabaseConnection();
            readiness.setStatus("UP");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            readiness.setStatus("DOWN");
            readiness.setError("e.getMessage()");
            this.logger.debug("Api Health Check - Error - status2:{}", (Object)readiness);
        }
        satusList.add(readiness);
        healthStatus.setChecks(satusList);
        this.logger.debug("ApiHealthCheck::getHealthResponse() - satusList:{}", satusList);
        return Response.ok(satusList).build();
    }

    @Operation(summary="Returns application liveness status", description="Returns application liveness status", operationId="get-config-health-live", tags={"Health - Check"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Status.class))}), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/live")
    public Response getLivenessResponse() {
        this.logger.info("ApiHealthCheck::/health/live");
        Status liveness = new Status();
        liveness.setName("jans-config-api liveness");
        liveness.setStatus("UP");
        this.logger.debug("ApiHealthCheck::getLivenessResponse() - liveness:{}", (Object)liveness);
        return Response.ok((Object)liveness).build();
    }

    @Operation(summary="Returns application readiness status", description="Returns application readiness status", operationId="get-config-health-ready", tags={"Health - Check"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Status.class))}), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/ready")
    public Response getReadinessResponse() {
        this.logger.info("ApiHealthCheck::/health/ready");
        Status readiness = new Status();
        readiness.setName("jans-config-api readiness");
        try {
            this.checkDatabaseConnection();
            readiness.setStatus("UP");
            this.logger.debug("Api Health Readiness - Success - readiness:{}", (Object)readiness);
            return Response.ok((Object)readiness).build();
        }
        catch (Exception e) {
            readiness.setStatus("DOWN");
            readiness.setError("e.getMessage()");
            this.logger.debug("Api Health Readiness - Error - readiness:{}", (Object)readiness);
            return Response.ok((Object)readiness).build();
        }
    }

    @Operation(summary="Returns application server status", description="Returns application server status", operationId="get-server-stat", tags={"Health - Check"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatsData.class), examples={@ExampleObject(name="Response json example", value="example/health/server-stat.json")})}), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/server-stat")
    public Response getServerStat() {
        this.logger.debug("Server Stat - Entry");
        StatsData statsData = this.statusCheckerTimer.getServerStatsData();
        this.logger.debug("Server Stat - statsData:{}", (Object)statsData);
        return Response.ok((Object)statsData).build();
    }

    @Operation(summary="Returns application version", description="Returns application version", operationId="get-app-version", tags={"Health - Check"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/app-version.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=JsonNode.class))}), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/app-version.readonly"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/app-version")
    public Response getApplicationVersion(@Parameter(description="artifact name for which version is requied else ALL") @DefaultValue(value="all") @QueryParam(value="artifact") String artifact) {
        this.logger.debug("Application Version - artifact:{}", (Object)artifact);
        return Response.ok((Object)this.statusCheckerTimer.getAppVersionData(artifact)).build();
    }

    @Operation(summary="Fetch service status", description="Fetch service status", operationId="get-service-status", tags={"Health - Check"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/data.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=JsonNode.class), examples={@ExampleObject(name="Response json example", value="example/health/service-status.json")})}), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/data.readonly"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/service-status")
    public Response getServiceStatus(@Parameter(description="Service name to check status") @DefaultValue(value="all") @QueryParam(value="service") String service) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Fetch ServiceStatus info - service:{}", (Object)Util.escapeLog((Object)service));
        }
        JsonNode serviceStatus = this.statusCheckerTimer.getServiceStatus(service);
        this.logger.debug("serviceStatus:{}", (Object)serviceStatus);
        return Response.ok((Object)serviceStatus).build();
    }

    private void checkDatabaseConnection() {
        this.configurationService.findConf();
    }
}

