/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.health;

import io.jans.configapi.service.auth.ConfigurationService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;
import org.slf4j.Logger;

@Readiness
@ApplicationScoped
public class DatabaseConnectionHealthCheck
implements HealthCheck {
    @Inject
    Logger logger;
    @Inject
    ConfigurationService configurationService;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)"jans-config-api readiness");
        try {
            this.checkDatabaseConnection();
            responseBuilder.up();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            responseBuilder.down().withData("error", e.getMessage());
        }
        return responseBuilder.build();
    }

    private void checkDatabaseConnection() {
        this.configurationService.findConf();
    }
}

