/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.DatabaseService;
import io.jans.orm.model.AttributeType;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

@Path(value="/config/database")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DatabaseResource
extends ConfigBaseResource {
    @Inject
    Logger log;
    @Inject
    private ApiAppConfiguration appConfiguration;
    @Inject
    DatabaseService databaseService;

    @Operation(summary="Gets schema objects", description="Gets schema objects.", operationId="get-schema", tags={"Database"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/database.readonly", "https://jans.io/oauth/config/database.write", "https://jans.io/oauth/config/read-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseSchemaMap.class, description="A map of table_name as key and Map of attributes"), examples={@ExampleObject(name="Response example", value="example/database/tableInfo.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/database.readonly"}, groupScopes={"https://jans.io/oauth/config/database.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getDefaultAuthenticationMethod() {
        Map<String, Map<String, AttributeType>> tableColumnsMap = this.databaseService.getTableColumnsMap();
        return Response.ok(tableColumnsMap).build();
    }

    @Schema(description="A map of table_name as key and Map of attributes")
    private class DatabaseSchemaMap
    extends HashMap<String, Map<String, AttributeType>> {
        private DatabaseSchemaMap() {
        }
    }
}

