/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.as.model.util.Util;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.SsaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/jans-auth-server/ssa")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SsaResource
extends ConfigBaseResource {
    @Inject
    Logger log;
    @Inject
    SsaService ssaService;

    @Operation(summary="Revoke existing active SSA based on `jti` or `org_id`", description="Revoke existing active SSA based on `jti` or `org_id`", operationId="revoke-ssa", tags={"Software Statement Assertion (SSA)"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/ssa.delete", "https://jans.io/auth/ssa.admin"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="422", description="Unprocessable Entity"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @ProtectedApi(scopes={"https://jans.io/oauth/config/ssa.delete"}, groupScopes={"https://jans.io/oauth/config/ssa.write"}, superScopes={"https://jans.io/oauth/config/delete-all"})
    public Response revokeSsa(@Parameter(description="Authorization code") @HeaderParam(value="Authorization") String authorization, @Parameter(description="JWT ID - unique identifier for the JWT") @QueryParam(value="jti") String jti) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Delete SSA - jti:{}", (Object)Util.escapeLog((Object)jti));
        }
        SsaResource.checkNotEmpty((String)jti, (String)"jti");
        JSONObject jsonObject = null;
        try {
            jsonObject = this.ssaService.revokeSsa(authorization, jti);
            this.log.info("SSA search parameters - jsonObject:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            SsaResource.throwInternalServerException((Throwable)ex);
        }
        return Response.ok().build();
    }
}

