/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.ClientService;
import io.jans.configapi.service.auth.TokenService;
import io.jans.model.SearchRequest;
import io.jans.model.token.TokenEntity;
import io.jans.orm.model.PagedResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Path(value="/token")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ApplicationScoped
public class TokenResource
extends ConfigBaseResource {
    private static final String TOKEN_NOT_FOUND = "Token identified by %s not found.";
    @Inject
    TokenService tokenService;
    @Inject
    ClientService clientService;

    @Operation(summary="Get token details by Id.", description="Get token details by Id.", operationId="get-token-by-id", tags={"Token"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/token.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=TokenEntity.class), examples={@ExampleObject(name="Response example", value="example/token/get-token.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/token.readonly"}, groupScopes={"https://jans.io/oauth/config/token.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/tknCde/{tknCde}")
    public Response getTokenById(@Parameter(description="Token identifier") @PathParam(value="tknCde") @NotNull String tknCde) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Serach tokens by id:{}", (Object)Util.escapeLog((Object)tknCde));
        }
        TokenResource.checkNotNull((String)tknCde, (String)"tknCde");
        TokenEntity tokenEntity = this.tokenService.getTokenEntityByCode(tknCde);
        if (tokenEntity == null) {
            TokenResource.throwNotFoundException((String)"Not Found", (String)String.format(TOKEN_NOT_FOUND, tknCde));
        }
        this.logger.info("Token fetched tokenEntity:{}", (Object)tokenEntity);
        return Response.ok((Object)tokenEntity).build();
    }

    @Operation(summary="Get token details by client.", description="Get token details by client.", operationId="get-token-by-client", tags={"Token"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/token.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=TokenEntityPagedResult.class), examples={@ExampleObject(name="Response example", value="example/token/get-all-token.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/token.readonly"}, groupScopes={"https://jans.io/oauth/config/token.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/client/{clientId}")
    public Response getClientToken(@Parameter(description="Client identifier") @PathParam(value="clientId") @NotNull String clientId) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Serach tokens by clientId:{}", (Object)Util.escapeLog((Object)clientId));
        }
        TokenResource.checkNotNull((String)clientId, (String)"clientId");
        Client client = this.clientService.getClientByInum(clientId);
        TokenResource.checkResourceNotNull((Object)client, (String)"Client");
        this.logger.debug("Serach tokens by client:{}", (Object)client);
        String fieldValuePair = "clnId=" + clientId;
        SearchRequest searchReq = this.createSearchRequest(this.tokenService.getDnForTokenEntity(null), null, "tknCde", "ascending", Integer.parseInt("0"), Integer.parseInt("50"), null, null, this.getMaxCount(), fieldValuePair, TokenEntity.class);
        TokenEntityPagedResult tokenEntityPagedResult = this.searchTokens(searchReq);
        this.logger.info("Token fetched are:{}", (Object)tokenEntityPagedResult);
        return Response.ok((Object)((Object)tokenEntityPagedResult)).build();
    }

    @Operation(summary="Search tokens", description="Search tokens", operationId="search-token", tags={"Token"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/token.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=TokenEntityPagedResult.class), examples={@ExampleObject(name="Response example", value="example/token/get-all-token.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/token.readonly"}, groupScopes={"https://jans.io/oauth/config/token.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/search")
    public Response searchTokenEntries(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="tknCde") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="grtTyp=client_credentials,tknTyp=access_token")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Token serach param - limit:{}, pattern:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.tokenService.getDnForTokenEntity(null), pattern, sortBy, sortOrder, startIndex, limit, null, null, this.getMaxCount(), fieldValuePair, TokenEntity.class);
        TokenEntityPagedResult tokenEntityPagedResult = this.searchTokens(searchReq);
        this.logger.info("Token fetched are:{}", (Object)tokenEntityPagedResult);
        return Response.ok((Object)((Object)tokenEntityPagedResult)).build();
    }

    @Operation(summary="Revoke client token.", description="Revoke client token.", operationId="revoke-token", tags={"Token"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/token.delete"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @ProtectedApi(scopes={"https://jans.io/oauth/config/token.delete"}, groupScopes={"https://jans.io/oauth/config/openid/openid-delete"}, superScopes={"https://jans.io/oauth/config/delete-all"})
    @Path(value="/revoke/{tknCde}")
    public Response revokeClientToken(@Parameter(description="Token Code") @PathParam(value="tknCde") @NotNull String tknCde) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Revoke token - tknCde():{}", (Object)Util.escapeLog((Object)tknCde));
        }
        TokenResource.checkResourceNotNull((Object)tknCde, (String)"tknCde");
        this.tokenService.revokeTokenEntity(tknCde);
        this.logger.info(" Successfully deleted token identified by tknCde:{}", (Object)tknCde);
        return Response.noContent().build();
    }

    private TokenEntityPagedResult searchTokens(SearchRequest searchReq) {
        this.logger.debug("Search Token by name params - searchReq:{} ", (Object)searchReq);
        TokenEntityPagedResult tokenEntityPagedResult = null;
        PagedResult<TokenEntity> pagedResult = this.tokenService.searchToken(searchReq);
        this.logger.debug("PagedResult  - pagedResult:{}", pagedResult);
        if (pagedResult != null) {
            this.logger.debug("Token fetched  - pagedResult.getTotalEntriesCount():{}, pagedResult.getEntriesCount():{}, pagedResult.getEntries():{}", new Object[]{pagedResult.getTotalEntriesCount(), pagedResult.getEntriesCount(), pagedResult.getEntries()});
            tokenEntityPagedResult = this.getTokenEntityPagedResult(pagedResult);
        }
        this.logger.debug("Token tokenEntityPagedResult:{} ", tokenEntityPagedResult);
        return tokenEntityPagedResult;
    }

    private TokenEntityPagedResult getTokenEntityPagedResult(PagedResult<TokenEntity> pagedResult) {
        TokenEntityPagedResult tokenEntityPagedResult = null;
        if (pagedResult != null) {
            List tokenEntityList = pagedResult.getEntries();
            tokenEntityPagedResult = new TokenEntityPagedResult();
            tokenEntityPagedResult.setStart(pagedResult.getStart());
            tokenEntityPagedResult.setEntriesCount(pagedResult.getEntriesCount());
            tokenEntityPagedResult.setTotalEntriesCount(pagedResult.getTotalEntriesCount());
            tokenEntityPagedResult.setEntries(tokenEntityList);
        }
        return tokenEntityPagedResult;
    }

    private class TokenEntityPagedResult
    extends PagedResult<TokenEntity> {
        private TokenEntityPagedResult() {
        }
    }
}

