/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import io.jans.as.common.model.common.User;
import io.jans.as.model.util.Util;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.model.JansAttribute;
import io.jans.model.SearchRequest;
import io.jans.orm.model.AttributeType;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
public class AttributeService
extends io.jans.as.common.service.AttributeService {
    private static final long serialVersionUID = -820393743995746612L;
    @Inject
    private transient ApiAppConfiguration appConfiguration;
    @Inject
    transient ConfigurationService configurationService;

    protected boolean isUseLocalCache() {
        return false;
    }

    public PagedResult<JansAttribute> searchJansAttributes(SearchRequest searchRequest, String status) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Search JansAttributes with searchRequest:{}, status:{}", (Object)Util.escapeLog((Object)searchRequest), (Object)Util.escapeLog((Object)status));
        }
        Filter activeFilter = null;
        if ("active".equalsIgnoreCase(status)) {
            activeFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"jansStatus"), (Object)"active");
        } else if ("inactive".equalsIgnoreCase(status)) {
            activeFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"jansStatus"), (Object)"inactive");
        }
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                if (StringUtils.isNotBlank((CharSequence)assertionValue)) {
                    assertionValue = assertionValue.toLowerCase();
                }
                String[] targetArray = new String[]{assertionValue};
                Filter displayNameFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"displayName"), null, (String[])targetArray, null);
                Filter descriptionFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"description"), null, (String[])targetArray, null);
                Filter nameFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"jansAttrName"), null, (String[])targetArray, null);
                Filter inumFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"inum"), null, (String[])targetArray, null);
                filters.add(Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, nameFilter, inumFilter}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        this.log.trace("Attributes pattern searchFilter:{}", searchFilter);
        ArrayList<Filter> fieldValueFilters = new ArrayList<Filter>();
        if (searchRequest.getFieldValueMap() != null && !searchRequest.getFieldValueMap().isEmpty()) {
            for (Map.Entry entry : searchRequest.getFieldValueMap().entrySet()) {
                Filter dataFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)((String)entry.getKey())), StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue())) ? ((String)entry.getValue()).toLowerCase() : entry.getValue());
                this.log.trace("dataFilter:{}", (Object)dataFilter);
                fieldValueFilters.add(Filter.createANDFilter((Filter[])new Filter[]{dataFilter}));
            }
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createANDFilter(fieldValueFilters)});
        }
        this.log.trace("Attributes pattern and field searchFilter:{}", (Object)searchFilter);
        if (activeFilter != null) {
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{searchFilter, activeFilter});
        }
        this.log.info("JansAttributes final searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getDnForAttribute(null), JansAttribute.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }

    public JansAttribute getAttributeUsingDn(String dn) {
        JansAttribute result = null;
        try {
            result = (JansAttribute)this.persistenceEntryManager.find(JansAttribute.class, (Object)dn);
        }
        catch (Exception ex) {
            this.log.error("Failed to load attribute with dn:{}, ex:{}", (Object)dn, (Object)ex);
        }
        return result;
    }

    public JansAttribute getAttributeUsingName(String name) {
        JansAttribute jansAttribute = null;
        try {
            jansAttribute = this.getByClaimName(name);
        }
        catch (Exception ex) {
            this.log.error("Failed to load attribute with name:{}, ex:{}", (Object)name, (Object)ex);
        }
        return jansAttribute;
    }

    public List<JansAttribute> getAttributeWithName(String name) {
        this.log.info("Get attribute by name:{}", (Object)name);
        List jansAttributes = null;
        try {
            Filter nameFilter = Filter.createEqualityFilter((String)"jansAttrName", (Object)name);
            this.log.info("JansAttribute nameFilter:{}", (Object)nameFilter);
            jansAttributes = this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), JansAttribute.class, nameFilter);
            this.log.info("JansAttribute by name:{} are jansAttributes:{}", (Object)name, (Object)jansAttributes);
        }
        catch (Exception ex) {
            this.log.error("Failed to load attribute with name:{}, ex:{}", (Object)name, (Object)ex);
        }
        return jansAttributes;
    }

    public boolean validateAttributeDefinition(String attributeName) {
        this.log.info(" Validate attributeName:{}, getPersistenceType():{}, appConfiguration:{}", new Object[]{attributeName, this.getPersistenceType(), this.appConfiguration});
        boolean isValidAttribute = false;
        try {
            if (this.appConfiguration != null && !this.appConfiguration.isCustomAttributeValidationEnabled()) {
                return true;
            }
            this.log.info("attributeName:{}, persistenceEntryManager.getAttributeType(ou=people,o=jans, User.class,attributeName)():{}", (Object)attributeName, (Object)this.persistenceEntryManager.getAttributeType("ou=people,o=jans", User.class, attributeName));
            AttributeType attributeType = this.persistenceEntryManager.getAttributeType("ou=people,o=jans", User.class, attributeName);
            this.log.error("\n attributeName:{}, attributeType():{}", (Object)attributeName, (Object)attributeType);
            if (attributeType != null) {
                isValidAttribute = true;
            }
        }
        catch (Exception ex) {
            this.log.error("Exception by ORM while validating attribute is:", (Throwable)ex);
        }
        return isValidAttribute;
    }

    private String getPersistenceType() {
        return this.configurationService.getPersistenceType();
    }
}

