/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.OrganizationService;
import io.jans.as.common.service.common.InumService;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.register.ApplicationType;
import io.jans.configapi.service.auth.AttributeService;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.configapi.service.auth.ScopeService;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class ClientService
implements Serializable {
    private static final long serialVersionUID = 7912416439116338984L;
    @Inject
    private transient PersistenceEntryManager persistenceEntryManager;
    @Inject
    private transient Logger logger;
    @Inject
    private OrganizationService organizationService;
    @Inject
    private transient InumService inumService;
    @Inject
    AttributeService attributeService;
    @Inject
    transient ScopeService scopeService;
    @Inject
    transient AppConfiguration appConfiguration;
    @Inject
    transient ConfigurationService configurationService;

    public boolean contains(String clientDn) {
        return this.persistenceEntryManager.contains(clientDn, Client.class);
    }

    public void addClient(Client client) {
        this.setClientDefaultAttributes(client, false);
        this.persistenceEntryManager.persist((Object)client);
    }

    public void removeClient(Client client) {
        this.persistenceEntryManager.removeRecursively(client.getDn(), Client.class);
    }

    public void updateClient(Client client) {
        this.persistenceEntryManager.merge((Object)client);
    }

    public Client getClientByInum(String inum) {
        Client result = null;
        try {
            result = (Client)this.persistenceEntryManager.find(Client.class, (Object)this.getDnForClient(inum));
        }
        catch (Exception ex) {
            this.logger.error("Failed to load client entry", (Throwable)ex);
        }
        return result;
    }

    public List<Client> searchClients(String pattern, int sizeLimit) {
        this.logger.debug("Search Clients with pattern:{}, sizeLimit:{}", (Object)pattern, (Object)sizeLimit);
        String[] targetArray = new String[]{pattern};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, inumFilter});
        this.logger.debug("Search Clients with searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findEntries(this.getDnForClient(null), Client.class, searchFilter, sizeLimit);
    }

    public List<Client> getAllClients(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForClient(null), Client.class, null, sizeLimit);
    }

    public List<Client> getAllClients() {
        return this.persistenceEntryManager.findEntries(this.getDnForClient(null), Client.class, null);
    }

    public PagedResult<Client> getClients(SearchRequest searchRequest) {
        this.logger.debug("Search Clients with searchRequest:{}", (Object)searchRequest);
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                String[] targetArray = new String[]{assertionValue};
                Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
                Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
                Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
                filters.add(Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, inumFilter}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        this.logger.trace("Clients pattern searchFilter:{}", searchFilter);
        ArrayList<Filter> fieldValueFilters = new ArrayList<Filter>();
        if (searchRequest.getFieldValueMap() != null && !searchRequest.getFieldValueMap().isEmpty()) {
            for (Map.Entry entry : searchRequest.getFieldValueMap().entrySet()) {
                Filter dataFilter = Filter.createEqualityFilter((String)((String)entry.getKey()), entry.getValue());
                this.logger.trace("Clients dataFilter:{}", (Object)dataFilter);
                fieldValueFilters.add(Filter.createANDFilter((Filter[])new Filter[]{dataFilter}));
            }
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createANDFilter(fieldValueFilters)});
        }
        this.logger.debug("Clients searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getDnForClient(null), Client.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }

    public Client getClientByDn(String dn) {
        try {
            return (Client)this.persistenceEntryManager.find(Client.class, (Object)dn);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    public ApplicationType[] getApplicationType() {
        return ApplicationType.values();
    }

    public SubjectType[] getSubjectTypes() {
        return SubjectType.values();
    }

    public SignatureAlgorithm[] getSignatureAlgorithms() {
        return SignatureAlgorithm.values();
    }

    public String getDnForClient(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=clients,%s", orgDn);
        }
        return String.format("inum=%s,ou=clients,%s", inum, orgDn);
    }

    public String generateInumForNewClient() {
        String newInum = null;
        String newDn = null;
        int trycount = 0;
        do {
            if (trycount < 10) {
                newInum = this.inumService.generateId("client");
                ++trycount;
                continue;
            }
            newInum = this.inumService.generateDefaultId();
        } while (this.persistenceEntryManager.contains(newDn = this.getDnForClient(newInum), Client.class));
        return newInum;
    }

    public Client setClientDefaultAttributes(Client client, boolean update) {
        List<String> authorizedOrigins;
        List<String> requestUris;
        List<String> postLogoutRedirectUris;
        List<String> groups;
        List<String> defaultAcrValues;
        List<String> contacts;
        HashSet<GrantType> grantTypeSet;
        List<String> claimsRedirectUris;
        List<String> redirectUris;
        this.logger.debug("Client data - client:{}", (Object)client);
        if (client == null) {
            return client;
        }
        this.logger.trace("client.getApplicationType:{}, client.getRedirectUris():{}, client.getClaimRedirectUris():{}", new Object[]{client.getApplicationType(), client.getRedirectUris(), client.getClaimRedirectUris()});
        List<String> list = redirectUris = client.getRedirectUris() != null ? Arrays.asList(client.getRedirectUris()) : null;
        if (redirectUris != null && !redirectUris.isEmpty()) {
            redirectUris = new ArrayList<String>(new HashSet<String>(redirectUris));
            client.setRedirectUris(redirectUris.toArray(new String[0]));
        }
        List<String> list2 = claimsRedirectUris = client.getClaimRedirectUris() != null ? Arrays.asList(client.getClaimRedirectUris()) : null;
        if (claimsRedirectUris != null && !claimsRedirectUris.isEmpty()) {
            claimsRedirectUris = new ArrayList<String>(new HashSet<String>(claimsRedirectUris));
            client.setClaimRedirectUris(claimsRedirectUris.toArray(new String[0]));
        }
        this.logger.trace("After setting client.getApplicationType:{}, client.getRedirectUris():{}, client.getClaimRedirectUris():{}", new Object[]{client.getApplicationType(), client.getRedirectUris(), client.getClaimRedirectUris()});
        client.setApplicationType(client.getApplicationType() != null ? client.getApplicationType() : ApplicationType.WEB);
        if (StringUtils.isNotBlank((CharSequence)client.getSectorIdentifierUri())) {
            client.setSectorIdentifierUri(client.getSectorIdentifierUri());
        }
        this.logger.trace("client.getApplicationType():{}, client.getResponseTypes():{}, client.getGrantTypes():{}", new Object[]{client.getApplicationType(), client.getResponseTypes(), client.getGrantTypes()});
        HashSet<ResponseType> responseTypeSet = client.getResponseTypes() != null ? new HashSet<ResponseType>(Arrays.asList(client.getResponseTypes())) : new HashSet();
        HashSet<Object> hashSet = grantTypeSet = client.getGrantTypes() != null ? new HashSet<GrantType>(Arrays.asList(client.getGrantTypes())) : new HashSet();
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getGrantTypesAndResponseTypesAutofixEnabled())) {
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getClientRegDefaultToCodeFlowWithRefresh())) {
                if (responseTypeSet.isEmpty() && grantTypeSet.isEmpty()) {
                    responseTypeSet.add(ResponseType.CODE);
                }
                if (responseTypeSet.contains(ResponseType.CODE)) {
                    grantTypeSet.add(GrantType.AUTHORIZATION_CODE);
                    grantTypeSet.add(GrantType.REFRESH_TOKEN);
                }
                if (grantTypeSet.contains(GrantType.AUTHORIZATION_CODE)) {
                    responseTypeSet.add(ResponseType.CODE);
                    grantTypeSet.add(GrantType.REFRESH_TOKEN);
                }
            }
            if (responseTypeSet.contains(ResponseType.TOKEN) || responseTypeSet.contains(ResponseType.ID_TOKEN)) {
                grantTypeSet.add(GrantType.IMPLICIT);
            }
            if (grantTypeSet.contains(GrantType.IMPLICIT)) {
                responseTypeSet.add(ResponseType.TOKEN);
            }
        }
        this.logger.trace("After setting - responseTypeSet:{}, client.getResponseTypes():{}, appConfiguration.getAllResponseTypesSupported():{}, grantTypeSet:{}, client.getGrantTypes():{}, appConfiguration.getGrantTypesSupported():{}", new Object[]{responseTypeSet, client.getResponseTypes(), this.appConfiguration.getAllResponseTypesSupported(), grantTypeSet, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported()});
        responseTypeSet.retainAll(this.appConfiguration.getAllResponseTypesSupported());
        grantTypeSet.retainAll(this.appConfiguration.getGrantTypesSupported());
        this.logger.trace("After setting - responseTypeSet:{}, grantTypeSet:{}, appConfiguration.getGrantTypesSupportedByDynamicRegistration():{}", new Object[]{responseTypeSet, grantTypeSet, this.appConfiguration.getGrantTypesSupportedByDynamicRegistration()});
        Set grantTypesSupportedByDynamicRegistration = this.appConfiguration.getGrantTypesSupportedByDynamicRegistration();
        grantTypeSet.retainAll(grantTypesSupportedByDynamicRegistration);
        if (!update || responseTypeSet != null && !responseTypeSet.isEmpty()) {
            client.setResponseTypes(responseTypeSet.toArray(new ResponseType[0]));
        }
        if (!update || BooleanUtils.isTrue((Boolean)this.appConfiguration.getEnableClientGrantTypeUpdate()) && client.getGrantTypes() != null && client.getGrantTypes().length > 0) {
            client.setGrantTypes(grantTypeSet.toArray(new GrantType[0]));
        }
        this.logger.trace("Set client.getResponseTypes():{}, client.getGrantTypes():{}", (Object)client.getResponseTypes(), (Object)client.getGrantTypes());
        List<String> list3 = contacts = client.getContacts() != null ? Arrays.asList(client.getContacts()) : null;
        if (contacts != null && !contacts.isEmpty()) {
            contacts = new ArrayList<String>(new HashSet<String>(contacts));
            client.setContacts(contacts.toArray(new String[0]));
        }
        this.logger.trace("client.getTokenEndpointAuthMethod():{}", (Object)client.getTokenEndpointAuthMethod());
        if (StringUtils.isBlank((CharSequence)client.getTokenEndpointAuthMethod())) {
            client.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        }
        this.logger.trace("client.getDefaultAcrValues():{}", (Object[])client.getDefaultAcrValues());
        List<String> list4 = defaultAcrValues = client.getDefaultAcrValues() != null ? Arrays.asList(client.getDefaultAcrValues()) : null;
        if (defaultAcrValues != null && !defaultAcrValues.isEmpty()) {
            defaultAcrValues = new ArrayList<String>(new HashSet<String>(defaultAcrValues));
            client.setDefaultAcrValues(defaultAcrValues.toArray(new String[defaultAcrValues.size()]));
        }
        this.logger.debug("client.getGroups():{}", (Object[])client.getGroups());
        List<String> list5 = groups = client.getGroups() != null ? Arrays.asList(client.getGroups()) : null;
        if (groups != null && !groups.isEmpty()) {
            client.setGroups(new HashSet<String>(groups).toArray(new String[0]));
        }
        this.logger.debug("client.getGroups():{}, client.getPostLogoutRedirectUris():{}", (Object)client.getGroups(), (Object)client.getPostLogoutRedirectUris());
        List<String> list6 = postLogoutRedirectUris = client.getPostLogoutRedirectUris() != null ? Arrays.asList(client.getPostLogoutRedirectUris()) : null;
        if (postLogoutRedirectUris != null && !postLogoutRedirectUris.isEmpty()) {
            postLogoutRedirectUris = new ArrayList<String>(new HashSet<String>(postLogoutRedirectUris));
            client.setPostLogoutRedirectUris(postLogoutRedirectUris.toArray(new String[postLogoutRedirectUris.size()]));
        }
        List<String> list7 = requestUris = client.getRequestUris() != null ? Arrays.asList(client.getRequestUris()) : null;
        if (requestUris != null && !requestUris.isEmpty()) {
            requestUris = new ArrayList<String>(new HashSet<String>(requestUris));
            client.setRequestUris(requestUris.toArray(new String[requestUris.size()]));
        }
        List<String> list8 = authorizedOrigins = client.getAuthorizedOrigins() != null ? Arrays.asList(client.getAuthorizedOrigins()) : null;
        if (authorizedOrigins != null && !authorizedOrigins.isEmpty()) {
            authorizedOrigins = new ArrayList<String>(new HashSet<String>(authorizedOrigins));
            client.setAuthorizedOrigins(authorizedOrigins.toArray(new String[authorizedOrigins.size()]));
        }
        this.logger.debug("client.getScopes():{}, appConfiguration.getDynamicRegistrationScopesParamEnabled():{}", (Object)client.getScopes(), (Object)this.appConfiguration.getDynamicRegistrationScopesParamEnabled());
        this.logger.debug("client.getClaims():{}, client.getAttributes().getAuthorizedAcrValues():{}", (Object)client.getClaims(), (Object)client.getAttributes().getAuthorizedAcrValues());
        ArrayList authorizedAcrValues = client.getAttributes().getAuthorizedAcrValues();
        if (authorizedAcrValues != null && !authorizedAcrValues.isEmpty()) {
            authorizedAcrValues = new ArrayList(new HashSet(authorizedAcrValues));
            client.getAttributes().setAuthorizedAcrValues(authorizedAcrValues);
        }
        this.logger.debug("Final client.getAttributes().getAuthorizedAcrValues():{}", (Object)client.getAttributes().getAuthorizedAcrValues());
        this.updateCustomAttributes(client);
        return client;
    }

    private void updateCustomAttributes(Client client) {
        this.logger.debug("ClientService::updateCustomAttributes() - client:{}, appConfiguration.getDynamicRegistrationCustomObjectClass():{},appConfiguration.getDynamicRegistrationCustomAttributes():{} ", new Object[]{client, this.appConfiguration.getDynamicRegistrationCustomObjectClass(), this.appConfiguration.getDynamicRegistrationCustomAttributes()});
        String customOC = this.appConfiguration.getDynamicRegistrationCustomObjectClass();
        String persistenceType = this.configurationService.getPersistenceType();
        if (PersistenceEntryManager.PERSITENCE_TYPES.ldap.name().equals(persistenceType) && StringUtils.isNotBlank((CharSequence)customOC)) {
            client.setCustomObjectClasses(new String[]{customOC});
        } else {
            client.setCustomObjectClasses(null);
        }
        List attrList = this.appConfiguration.getDynamicRegistrationCustomAttributes();
        if (attrList == null || attrList.isEmpty()) {
            return;
        }
        this.logger.debug("ClientService::updateCustomAttributes() - client.getCustomAttributes():{}, attrList:{}", (Object)client.getCustomAttributes(), (Object)attrList);
        for (String attr : attrList) {
            this.logger.debug("ClientService::updateCustomAttributes() - attr:{}", (Object)attr);
        }
    }
}

