/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import com.google.api.client.util.Lists;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.OrganizationService;
import io.jans.as.model.common.ScopeType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.uma.persistence.UmaResource;
import io.jans.as.persistence.model.Scope;
import io.jans.configapi.rest.model.CustomScope;
import io.jans.configapi.service.auth.ClientService;
import io.jans.configapi.service.auth.UmaResourceService;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class ScopeService {
    private static final String JANS_SCOPE_TYP = "jansScopeTyp";
    @Inject
    Logger logger;
    @Inject
    PersistenceEntryManager persistenceEntryManager;
    @Inject
    StaticConfiguration staticConfiguration;
    @Inject
    OrganizationService organizationService;
    @Inject
    ClientService clientService;
    @Inject
    UmaResourceService umaResourceService;

    public String baseDn() {
        return this.staticConfiguration.getBaseDn().getScopes();
    }

    public String createDn(String inum) {
        return String.format("inum=%s,%s", inum, this.baseDn());
    }

    public void persist(Scope scope) {
        if (StringUtils.isBlank((CharSequence)scope.getDn())) {
            scope.setDn(this.createDn(scope.getInum()));
        }
        this.persistenceEntryManager.persist((Object)scope);
    }

    public void addScope(Scope scope) {
        this.persistenceEntryManager.persist((Object)scope);
    }

    public void removeScope(Scope scope) {
        this.persistenceEntryManager.remove((Object)scope);
    }

    public void updateScope(Scope scope) {
        this.persistenceEntryManager.merge((Object)scope);
    }

    public Scope getScope(String inum) {
        try {
            return (Scope)this.persistenceEntryManager.find(Scope.class, (Object)this.getDnForScope(inum));
        }
        catch (Exception ex) {
            this.logger.error("Error while finding scope with inum:{} is:{}", (Object)inum, (Object)ex);
            return null;
        }
    }

    public CustomScope getScopeByInum(String inum) {
        return this.getScopeByInum(inum, false);
    }

    public CustomScope getScopeByInum(String inum, boolean withAssociatedClients) {
        try {
            CustomScope scope = (CustomScope)this.persistenceEntryManager.find(CustomScope.class, (Object)this.getDnForScope(inum));
            if (withAssociatedClients) {
                return this.setClients(scope);
            }
            return scope;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDnForScope(String inum) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=scopes,%s", orgDn);
        }
        return String.format("inum=%s,ou=scopes,%s", inum, orgDn);
    }

    public List<CustomScope> searchScopes(String pattern, int sizeLimit) {
        return this.searchScopes(pattern, sizeLimit, null);
    }

    public List<Scope> searchScopesById(String jsId) {
        Filter searchFilter = Filter.createEqualityFilter((String)"jansId", (Object)jsId);
        try {
            return this.persistenceEntryManager.findEntries(this.getDnForScope(null), Scope.class, searchFilter);
        }
        catch (Exception e) {
            this.logger.error("No scopes found by pattern: " + jsId, (Throwable)e);
            return new ArrayList<Scope>();
        }
    }

    public List<Scope> searchScopesById(Set<String> scopeIds) {
        this.logger.debug("Scope to search based on scopeIds:{}", scopeIds);
        try {
            if (scopeIds == null || scopeIds.isEmpty()) {
                return Collections.emptyList();
            }
            Filter[] filters = scopeIds.stream().map(id -> Filter.createEqualityFilter((String)"jansId", (Object)id)).collect(Collectors.toList()).toArray(new Filter[0]);
            return this.persistenceEntryManager.findEntries(this.getDnForScope(null), Scope.class, Filter.createORFilter((Filter[])filters));
        }
        catch (Exception e) {
            this.logger.error("No scopes found by Ids: " + scopeIds, (Throwable)e);
            return new ArrayList<Scope>();
        }
    }

    public Scope getScopeByDn(String dn) {
        return (Scope)this.persistenceEntryManager.find(Scope.class, (Object)dn);
    }

    public List<CustomScope> searchScopes(String pattern, int sizeLimit, String scopeType) {
        return this.searchScopes(pattern, sizeLimit, scopeType, false);
    }

    public List<CustomScope> searchScopes(String pattern, int sizeLimit, String scopeType, boolean withAssociatedClients) {
        String[] targetArray = new String[]{pattern};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter});
        if (StringHelper.isNotEmpty((String)scopeType)) {
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)JANS_SCOPE_TYP, (Object)scopeType), searchFilter});
        }
        try {
            List scopes = this.persistenceEntryManager.findEntries(this.getDnForScope(null), CustomScope.class, searchFilter, sizeLimit);
            if (withAssociatedClients) {
                this.getAssociatedClients(scopes);
            }
            return scopes;
        }
        catch (Exception e) {
            this.logger.error("No scopes found by patterns: " + pattern, (Throwable)e);
            return new ArrayList<CustomScope>();
        }
    }

    public List<CustomScope> getAllScopesList(int size) {
        return this.getAllScopesList(size, null);
    }

    public List<CustomScope> getAllScopesList(int size, String scopeType) {
        return this.getAllScopesList(size, scopeType, false);
    }

    public List<CustomScope> getAllScopesList(int size, String scopeType, boolean withAssociatedClients) {
        Filter searchFilter = null;
        if (StringHelper.isNotEmpty((String)scopeType)) {
            searchFilter = Filter.createEqualityFilter((String)JANS_SCOPE_TYP, (Object)scopeType);
        }
        List scopes = this.persistenceEntryManager.findEntries(this.getDnForScope(null), CustomScope.class, searchFilter, size);
        if (withAssociatedClients) {
            this.getAssociatedClients(scopes);
        }
        return scopes;
    }

    public List<CustomScope> searchScope(SearchRequest searchRequest) {
        this.logger.debug("Search Scope with searchRequest:{}", (Object)searchRequest);
        if (searchRequest != null && searchRequest.getFilterAttributeName() != null && !searchRequest.getFilterAttributeName().isEmpty()) {
            ArrayList<Filter> searchFilters = new ArrayList<Filter>();
            for (String filterAttribute : searchRequest.getFilterAttributeName()) {
                Filter filter = Filter.createEqualityFilter((String)filterAttribute, (Object)searchRequest.getFilter());
                searchFilters.add(filter);
            }
            this.logger.debug("Search Scope with searchFilters:{}", searchFilters);
            return this.persistenceEntryManager.findEntries(this.getDnForScope(null), CustomScope.class, Filter.createANDFilter(searchFilters));
        }
        return Collections.emptyList();
    }

    public List<Scope> getAllScopesList() {
        String scopesBaseDN = this.staticConfiguration.getBaseDn().getScopes();
        return this.persistenceEntryManager.findEntries(scopesBaseDN, Scope.class, Filter.createPresenceFilter((String)"inum"));
    }

    public List<String> getDefaultScopesDn() {
        ArrayList<String> defaultScopes = new ArrayList<String>();
        for (Scope scope : this.getAllScopesList()) {
            if (!Boolean.TRUE.equals(scope.isDefaultScope())) continue;
            defaultScopes.add(scope.getDn());
        }
        return defaultScopes;
    }

    public List<String> getScopesDn(List<String> scopeDnList) {
        ArrayList<String> scopes = new ArrayList<String>();
        for (String scopeDn : scopeDnList) {
            Scope scope = this.getScopeByDn(scopeDn);
            if (scope == null) continue;
            scopes.add(scope.getDn());
        }
        return scopes;
    }

    private CustomScope setClients(CustomScope customScope) {
        this.logger.debug("Getting associated-clients for scope - customScope:{}", (Object)customScope);
        List<Client> clients = this.clientService.getAllClients();
        List<UmaResource> umaResources = this.umaResourceService.getAllResources();
        this.logger.debug("Verifying associated-clients using clients:{}, umaResources:{}", clients, umaResources);
        customScope.setClients((List)Lists.newArrayList());
        for (Client client : clients) {
            this.logger.debug("Associated clients search - customScope.getScopeType():{}, customScope.getInum():{}, customScope.getCreatorId():{}, client.getClientId():{}, clientService.getDnForClient(client.getClientId()):{}, client.getScopes():{}, client.getClientId().equals(customScope.getCreatorId()):{}", new Object[]{customScope.getScopeType(), customScope.getInum(), customScope.getCreatorId(), client.getClientId(), this.clientService.getDnForClient(client.getClientId()), client.getScopes(), client.getClientId().equals(customScope.getCreatorId())});
            if (customScope.getScopeType() == ScopeType.OPENID || customScope.getScopeType() == ScopeType.OAUTH || customScope.getScopeType() == ScopeType.DYNAMIC) {
                if (client.getScopes() == null || !Arrays.asList(client.getScopes()).contains(this.getDnForScope(customScope.getInum()))) continue;
                this.logger.debug("Associated clients match for OOD - customScope.getScopeType():{}, customScope.getInum():{},client.getClientId():{}", new Object[]{customScope.getScopeType(), customScope.getInum(), client.getClientId()});
                customScope.getClients().add(client);
                continue;
            }
            if (customScope.getScopeType() == ScopeType.UMA) {
                List umaRes = umaResources.stream().filter(umaResource -> umaResource.getScopes() != null && umaResource.getScopes().contains(this.getDnForScope(customScope.getInum()))).collect(Collectors.toList());
                this.logger.trace("Associated clients search - umaRes():{}", umaRes);
                if (!umaRes.stream().anyMatch(ele -> ele.getClients().contains(this.clientService.getDnForClient(client.getClientId())))) continue;
                customScope.getClients().add(client);
                continue;
            }
            if (customScope.getScopeType() != ScopeType.SPONTANEOUS || !client.getClientId().equals(customScope.getCreatorId())) continue;
            this.logger.debug("Associated clients match for SPONTANEOUS - customScope.getScopeType():{}, customScope.getInum():{},customScope.getCreatorId():{}, client.getClientId():{}", new Object[]{customScope.getScopeType(), customScope.getInum(), customScope.getCreatorId(), client.getClientId()});
            customScope.getClients().add(client);
        }
        return customScope;
    }

    public List<CustomScope> getAssociatedClients(List<CustomScope> scopes) {
        this.logger.debug("Getting associatedClients for scopes:{}", scopes);
        if (scopes == null) {
            return scopes;
        }
        ArrayList scopeList = Lists.newArrayList();
        for (CustomScope scope : scopes) {
            scopeList.add(this.setClients(scope));
        }
        this.logger.debug("Getting associatedClients for scopeList:{}", (Object)scopeList);
        return scopeList;
    }

    public PagedResult<CustomScope> getScopeResult(SearchRequest searchRequest, String scopeType, boolean withAssociatedClients) {
        this.logger.debug("Search Scope with searchRequest:{}, scopeType:{}, withAssociatedClients:{}", new Object[]{searchRequest, scopeType, withAssociatedClients});
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                String[] targetArray = new String[]{assertionValue};
                Filter filter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
                Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
                Filter nameFilter = Filter.createSubstringFilter((String)"jansId", null, (String[])targetArray, null);
                Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
                Filter scopeTypeFilter = Filter.createSubstringFilter((String)JANS_SCOPE_TYP, null, (String[])targetArray, null);
                filters.add(Filter.createORFilter((Filter[])new Filter[]{filter, descriptionFilter, nameFilter, inumFilter, scopeTypeFilter}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        if (StringHelper.isNotEmpty((String)scopeType)) {
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createEqualityFilter((String)JANS_SCOPE_TYP, (Object)scopeType)});
        }
        this.logger.trace("Scope pattern searchFilter:{}", searchFilter);
        ArrayList<Filter> fieldValueFilters = new ArrayList<Filter>();
        Filter dataFilter = null;
        if (searchRequest.getFieldValueMap() != null && !searchRequest.getFieldValueMap().isEmpty()) {
            for (Map.Entry entry : searchRequest.getFieldValueMap().entrySet()) {
                this.logger.trace("Scope entry.getKey():{}, entry.getValue():{}", entry.getKey(), entry.getValue());
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey()))) continue;
                dataFilter = Filter.createEqualityFilter((String)((String)entry.getKey()), entry.getValue());
                fieldValueFilters.add(Filter.createANDFilter((Filter[])new Filter[]{dataFilter}));
            }
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createANDFilter(fieldValueFilters)});
        }
        this.logger.trace("Scope pattern and field searchFilter:{}", (Object)searchFilter);
        this.logger.debug("Final Scope searchFilter:{}", (Object)searchFilter);
        PagedResult pagedResult = this.persistenceEntryManager.findPagedEntries(this.getDnForScope(null), CustomScope.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
        if (pagedResult != null) {
            this.logger.debug("Scope fetched  - pagedResult.getTotalEntriesCount():{}, pagedResult.getEntriesCount():{}, pagedResult.getEntries():{}", new Object[]{pagedResult.getTotalEntriesCount(), pagedResult.getEntriesCount(), pagedResult.getEntries()});
            List list = pagedResult.getEntries();
            if (withAssociatedClients) {
                this.getAssociatedClients(list);
            }
            this.logger.debug("scopes:{}", (Object)list);
            pagedResult.setEntries(list);
        }
        return pagedResult;
    }
}

