/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import com.github.fge.jackson.JacksonUtils;
import com.google.common.collect.Lists;
import io.jans.config.GluuConfiguration;
import io.jans.config.IDPAuthConf;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.orm.sql.model.SqlConnectionConfiguration;
import io.jans.service.EncryptionService;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
public class SqlConfService {
    private static final String AUTH = "auth";
    @Inject
    ConfigurationService configurationService;
    @Inject
    private EncryptionService encryptionService;

    public List<SqlConnectionConfiguration> findAll() {
        return this.getIDPAuthConf().stream().filter(c -> c.asSqlConfiguration() != null).map(IDPAuthConf::asSqlConfiguration).collect(Collectors.toList());
    }

    public void save(SqlConnectionConfiguration conf) {
        this.save(Lists.newArrayList((Object[])new SqlConnectionConfiguration[]{conf}));
    }

    public void save(List<SqlConnectionConfiguration> confs) {
        GluuConfiguration configuration = this.configurationService.findGluuConfiguration();
        configuration.setIdpAuthn(this.getOrCreateIDPAuthConfs(configuration.getIdpAuthn(), confs));
        this.configurationService.merge(configuration);
    }

    public void remove(String name) {
        GluuConfiguration gluuConfiguration = this.configurationService.findGluuConfiguration();
        List existing = gluuConfiguration.getIdpAuthn();
        Optional<IDPAuthConf> existingConf = existing.stream().filter(o -> o.getName() != null && o.getName().equals(name)).findFirst();
        if (!existingConf.isPresent()) {
            return;
        }
        existing.remove(existingConf.get());
        gluuConfiguration.setIdpAuthn(existing);
        this.configurationService.merge(gluuConfiguration);
    }

    public Optional<SqlConnectionConfiguration> findByName(String name) {
        List<SqlConnectionConfiguration> all = this.findAll();
        return all.stream().filter(d -> d != null && d.getConfigId() != null && d.getConfigId().equals(name)).findFirst();
    }

    private List<IDPAuthConf> getIDPAuthConf() {
        List idpConfList = this.configurationService.findGluuConfiguration().getIdpAuthn();
        if (idpConfList == null) {
            return Lists.newArrayList();
        }
        return idpConfList;
    }

    private List<IDPAuthConf> getOrCreateIDPAuthConfs(List<IDPAuthConf> existing, List<SqlConnectionConfiguration> confs) {
        if (existing == null) {
            existing = Lists.newArrayList();
        }
        for (SqlConnectionConfiguration conf : confs) {
            IDPAuthConf idpConf;
            Optional<IDPAuthConf> existingConf = existing.stream().filter(o -> o.getName() != null && o.getName().equals(conf.getConfigId())).findFirst();
            if (!existingConf.isPresent()) {
                idpConf = new IDPAuthConf();
                existing.add(idpConf);
            } else {
                idpConf = existingConf.get();
            }
            if (this.shouldEncryptPassword(conf)) {
                try {
                    conf.setUserPassword(this.encryptionService.encrypt(conf.getUserPassword()));
                }
                catch (StringEncrypter.EncryptionException e) {
                    throw new RuntimeException("Unable to decrypt password.", e);
                }
            }
            idpConf.setType(AUTH);
            idpConf.setVersion(idpConf.getVersion() + 1);
            idpConf.setName(conf.getConfigId());
            idpConf.setEnabled(true);
            idpConf.setConfig(JacksonUtils.newMapper().valueToTree((Object)conf));
        }
        return existing;
    }

    private boolean shouldEncryptPassword(SqlConnectionConfiguration conf) {
        Optional<SqlConnectionConfiguration> oldConfiguration = this.findByName(conf.getConfigId());
        if (!oldConfiguration.isPresent()) {
            return false;
        }
        String encryptedOldPassword = oldConfiguration.get().getUserPassword();
        return !StringUtils.equals((CharSequence)encryptedOldPassword, (CharSequence)conf.getUserPassword());
    }
}

