/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.uma.persistence.UmaResource;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class UmaResourceService {
    @Inject
    PersistenceEntryManager persistenceEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private Logger logger;

    public void addBranch() {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("resources");
        branch.setDn(this.getDnForResource(null));
        this.persistenceEntryManager.persist((Object)branch);
    }

    public List<UmaResource> findResources(String pattern, int sizeLimit) {
        String[] targetArray = new String[]{pattern};
        Filter jsIdFilter = Filter.createSubstringFilter((String)"jansId", null, (String[])targetArray, null);
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{jsIdFilter, displayNameFilter});
        return this.persistenceEntryManager.findEntries(this.getDnForResource(null), UmaResource.class, searchFilter, sizeLimit);
    }

    public List<UmaResource> findResourcesByName(String name, int sizeLimit) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            Filter searchFilter = Filter.createEqualityFilter((String)"displayName", (Object)name);
            return this.persistenceEntryManager.findEntries(this.getDnForResource(null), UmaResource.class, searchFilter, sizeLimit);
        }
        return Collections.emptyList();
    }

    public List<UmaResource> getAllResources(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getDnForResource(null), UmaResource.class, null, sizeLimit);
    }

    public List<UmaResource> getAllResources() {
        return this.persistenceEntryManager.findEntries(this.getDnForResource(null), UmaResource.class, null);
    }

    public void addResource(UmaResource resource) {
        this.persistenceEntryManager.persist((Object)resource);
    }

    public void updateResource(UmaResource resource) {
        this.persistenceEntryManager.merge((Object)resource);
    }

    public void remove(UmaResource resource) {
        this.persistenceEntryManager.remove((Object)resource);
    }

    public void remove(String rsid) {
        this.persistenceEntryManager.remove((Object)this.getResourceById(rsid));
    }

    public UmaResource getResourceById(String id) {
        this.prepareBranch();
        String dn = this.getDnForResource(id);
        return (UmaResource)this.persistenceEntryManager.find(UmaResource.class, (Object)dn);
    }

    public List<UmaResource> getResourcesByClient(String clientDn) {
        try {
            this.logger.debug(" Fetch UmaResource based on client - clientDn:{} ", (Object)clientDn);
            this.prepareBranch();
            if (StringUtils.isNotBlank((CharSequence)clientDn)) {
                return this.persistenceEntryManager.findEntries(this.getBaseDnForResource(), UmaResource.class, Filter.createEqualityFilter((String)"jansAssociatedClnt", (Object)clientDn));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private void prepareBranch() {
        if (!this.persistenceEntryManager.hasBranchesSupport(this.getDnForResource(null))) {
            return;
        }
        if (!this.persistenceEntryManager.contains(this.getDnForResource(null), SimpleBranch.class)) {
            this.addBranch();
        }
    }

    public String getDnForResource(String jsId) {
        if (StringHelper.isEmpty((String)jsId)) {
            return this.getBaseDnForResource();
        }
        return String.format("jansId=%s,%s", jsId, this.getBaseDnForResource());
    }

    public String getBaseDnForResource() {
        String umaBaseDn = this.staticConfiguration.getBaseDn().getUmaBase();
        return String.format("ou=resources,%s", umaBaseDn);
    }

    public PagedResult<UmaResource> searchUmaResource(SearchRequest searchRequest) {
        this.logger.debug("Search UmaResource with searchRequest:{}", (Object)searchRequest);
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                String[] targetArray = new String[]{assertionValue};
                Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
                Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
                Filter inumFilter = Filter.createSubstringFilter((String)"jansId", null, (String[])targetArray, null);
                filters.add(Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, inumFilter}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        this.logger.debug("UmaResources searchFilter:{}", searchFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getBaseDnForResource(), UmaResource.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }
}

