/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.test.auth;

import io.jans.configapi.ConfigServerBaseTest;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class AcrsResourceTest
extends ConfigServerBaseTest {
    private String defaultAcr;

    @Parameters(value={"test.issuer", "acrsUrl"})
    @Test
    public void getDefaultAuthenticationMethod(String issuer, String acrsUrl) {
        this.log.info("accessToken:{}, issuer:{}, acrsUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)acrsUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + acrsUrl);
        request.header("Authorization", (Object)("Bearer " + this.accessToken));
        request.header("Content-Type", (Object)"application/json");
        Response response = request.get();
        this.log.info("response:{}", (Object)response);
        this.defaultAcr = (String)response.readEntity(String.class);
        this.log.info("Response for getDefaultAuthenticationMethod -  defaultAcr:{}, response.getStatus():{}", (Object)this.defaultAcr, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }

    @Parameters(value={"test.issuer", "acrsUrl"})
    @Test
    public void postClient(String issuer, String acrsUrl) {
        this.log.info("accessToken:{}, issuer:{}, acrsUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)acrsUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + acrsUrl);
        request.header("Authorization", (Object)("Bearer " + this.accessToken));
        request.header("Content-Type", (Object)"application/json");
        this.log.info("Update defaultAcr:{}", (Object)this.defaultAcr);
        Response response = request.put(Entity.entity((Object)this.defaultAcr, (String)"application/json"));
        this.log.info("Response for getApiConfigtion -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }
}

