/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.test.auth;

import io.jans.configapi.ConfigServerBaseTest;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class AuthConfigResourceTest
extends ConfigServerBaseTest {
    @Parameters(value={"test.issuer", "authConfigurationUrl"})
    @Test
    public void getAuthConfigurationProperty(String issuer, String authConfigurationUrl) {
        this.log.info("getAuthConfigurationProperty() - accessToken:{}, issuer:{}, authConfigurationUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)authConfigurationUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + authConfigurationUrl);
        request.header("Authorization", (Object)("Bearer " + this.accessToken));
        request.header("Content-Type", (Object)"application/json");
        Response response = request.get();
        this.log.info("Response for getAuthConfigurationProperty() -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }

    @Parameters(value={"test.issuer", "authConfigurationUrl"})
    @Test
    public void getPersistenceDetails(String issuer, String authConfigurationUrl) {
        this.log.info("getPersistenceDetails() - accessToken:{}, issuer:{}, authConfigurationUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)authConfigurationUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + authConfigurationUrl + "/persistence");
        request.header("Authorization", (Object)("Bearer " + this.accessToken));
        request.header("Content-Type", (Object)"application/json");
        Response response = request.get();
        this.log.info("Response for getPersistenceDetails() -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }

    @Parameters(value={"test.issuer", "authConfigurationUrl", "auth_config_patch_1"})
    @Test
    public void patchAuthConfigurationProperty(String issuer, String authConfigurationUrl, String json) {
        this.log.info("patchAuthConfigurationProperty() - getApiConfigtion() - accessToken:{}, issuer:{}, authConfigurationUrl:{}, json:{}", (Object)this.accessToken, (Object)issuer, (Object)authConfigurationUrl, (Object)json);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + authConfigurationUrl);
        request.header("Authorization", (Object)("Bearer " + this.accessToken));
        request.header("Content-Type", (Object)"application/json-patch+json");
        Response response = request.method("PATCH", Entity.entity((Object)json, (String)"application/json-patch+json"));
        this.log.info("Response patchAuthConfigurationProperty() -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }
}

